/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyNotification;
import com.sun.identity.policy.remote.PolicyRequest;
import com.sun.identity.policy.remote.PolicyResponse;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PolicyService {
    static final String POLICY_SERVICE_ROOT = "PolicyService";
    static final String POLICY_REQUEST = "PolicyRequest";
    static final String POLICY_RESPONSE = "PolicyResponse";
    static final String POLICY_NOTIFICATION = "PolicyNotification";
    static final String POLICYSERVICE_VERSION = "version";
    static final String POLICYSERVICE_REVISION = "revisionNumber";
    static final String CRLF = "\r\n";
    public static final String POLICY_SERVICE = "policy";
    public static final int POLICY_REQUEST_ID = 1;
    public static final int POLICY_RESPONSE_ID = 2;
    public static final int POLICY_NOTIFICATION_ID = 3;
    static Debug debug = Debug.getInstance("amPolicy");
    static final String ON_ERROR_REVISION_NUMBER = "0";
    private String version = "1.0";
    private int methodID = 0;
    private PolicyRequest policyReq;
    private PolicyResponse policyRes;
    private PolicyNotification policyNotification;
    private String revision;

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String ver) {
        this.version = ver;
    }

    public int getMethodID() {
        return this.methodID;
    }

    public void setMethodID(int id) {
        this.methodID = id;
    }

    public PolicyRequest getPolicyRequest() {
        return this.policyReq;
    }

    public void setPolicyRequest(PolicyRequest req) {
        this.policyReq = req;
    }

    public PolicyResponse getPolicyResponse() {
        return this.policyRes;
    }

    public void setPolicyResponse(PolicyResponse res) {
        this.policyRes = res;
    }

    public PolicyNotification getPolicyNotification() {
        return this.policyNotification;
    }

    public void setPolicyNotification(PolicyNotification noti) {
        this.policyNotification = noti;
    }

    public static PolicyService parseXML(String xml) throws PolicyEvaluationException {
        Node node;
        String rev;
        Document doc = null;
        try {
            doc = XMLUtils.getXMLDocument(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        }
        catch (Exception xe) {
            debug.error("PolicyService.parseXML(String): XML parsing error");
            throw new PolicyEvaluationException("amPolicy", "xml_parsing_error", null, xe);
        }
        PolicyService ps = new PolicyService();
        Node rootNode = XMLUtils.getRootNode(doc, POLICY_SERVICE_ROOT);
        if (rootNode == null) {
            debug.error("PolicyServiceparseXML(String): invalid root element specified in the request");
            throw new PolicyEvaluationException("amPolicy", "invalid_root_element", null, null);
        }
        String ver = XMLUtils.getNodeAttributeValue(rootNode, POLICYSERVICE_VERSION);
        if (ver != null) {
            ps.setVersion(ver);
        }
        if ((rev = XMLUtils.getNodeAttributeValue(rootNode, POLICYSERVICE_REVISION)) != null) {
            ps.setRevision(rev);
        }
        if ((node = XMLUtils.getChildNode(rootNode, POLICY_REQUEST)) != null) {
            PolicyRequest preq = PolicyRequest.parseXML(node);
            ps.setPolicyRequest(preq);
            ps.setMethodID(1);
            return ps;
        }
        node = XMLUtils.getChildNode(rootNode, POLICY_RESPONSE);
        if (node != null) {
            PolicyResponse pres = PolicyResponse.parseXML(node);
            ps.setPolicyResponse(pres);
            ps.setMethodID(2);
            return ps;
        }
        node = XMLUtils.getChildNode(rootNode, POLICY_NOTIFICATION);
        if (node != null) {
            PolicyNotification pn = PolicyNotification.parseXML(node);
            ps.setPolicyNotification(pn);
            ps.setMethodID(3);
            return ps;
        }
        debug.error("PolicyService: invalid method specified");
        throw new PolicyEvaluationException("amPolicy", "invalid_policy_service_method", null, null);
    }

    public String toXMLString() {
        StringBuffer xmlsb = new StringBuffer(1000);
        xmlsb.append("<").append(POLICY_SERVICE_ROOT).append(" ").append(POLICYSERVICE_VERSION).append("=").append("\"").append(this.version).append("\"");
        if (this.revision != null && this.revision.trim().length() != 0) {
            xmlsb.append(" ").append(POLICYSERVICE_REVISION).append("=").append("\"").append(this.revision).append("\"");
        }
        xmlsb.append(">\r\n");
        switch (this.methodID) {
            case 1: {
                if (this.policyReq == null) break;
                xmlsb.append(this.policyReq.toXMLString());
                break;
            }
            case 2: {
                if (this.policyRes == null) break;
                xmlsb.append(this.policyRes.toXMLString());
                break;
            }
            case 3: {
                if (this.policyNotification == null) break;
                xmlsb.append(this.policyNotification.toXMLString());
                break;
            }
        }
        xmlsb.append("</").append(POLICY_SERVICE_ROOT).append(">").append(CRLF);
        return xmlsb.toString();
    }
}

