/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultDetail;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.shared.xml.XMLUtils;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPFault {
    private QName faultcode = null;
    private String faultstring = null;
    private String faultactor = null;
    private SOAPFaultDetail detail = null;

    public SOAPFault(QName faultcode, String faultstring) {
        this(faultcode, faultstring, null, null);
    }

    public SOAPFault(QName faultcode, String faultstring, String faultactor, SOAPFaultDetail detail) {
        this.faultcode = faultcode;
        this.faultstring = faultstring;
        this.faultactor = faultactor;
        this.detail = detail;
    }

    SOAPFault(Element faultElement) throws SOAPBindingException {
        NodeList nl = faultElement.getChildNodes();
        int length = nl.getLength();
        boolean foundInvalidChild = false;
        Element detailE = null;
        int numElements = 0;
        for (int i = 0; i < length; ++i) {
            String msg;
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            String localName = element.getLocalName();
            String namespaceURI = element.getNamespaceURI();
            if (++numElements == 1) {
                if ("faultcode".equals(localName) && namespaceURI == null) {
                    String value = XMLUtils.getElementValue(element);
                    if (value == null || value.length() == 0) {
                        String msg2 = Utils.bundle.getString("missingFaultCode");
                        Utils.debug.error("SOAPFaultException: " + msg2);
                        throw new SOAPBindingException(msg2);
                    }
                    this.faultcode = Utils.convertStringToQName(value, element);
                    continue;
                }
                msg = Utils.bundle.getString("missingFaultCode");
                Utils.debug.error("SOAPFaultException: " + msg);
                throw new SOAPBindingException(msg);
            }
            if (numElements == 2) {
                if ("faultstring".equals(localName) && namespaceURI == null) {
                    this.faultstring = XMLUtils.getElementValue(element);
                    continue;
                }
                msg = Utils.bundle.getString("missingFaultString");
                Utils.debug.error("SOAPFaultException: " + msg);
                throw new SOAPBindingException(msg);
            }
            if (numElements == 3) {
                if ("faultactor".equals(localName) && namespaceURI == null) {
                    this.faultactor = XMLUtils.getElementValue(element);
                    continue;
                }
                if ("detail".equals(localName) && namespaceURI == null) {
                    detailE = element;
                    continue;
                }
                msg = Utils.bundle.getString("invalidChild");
                Utils.debug.error("SOAPFaultException: " + msg);
                throw new SOAPBindingException(msg);
            }
            if (numElements == 4) {
                if (detailE == null && "detail".equals(localName) && namespaceURI == null) {
                    detailE = element;
                    continue;
                }
                msg = Utils.bundle.getString("invalidChild");
                Utils.debug.error("SOAPFaultException: " + msg);
                throw new SOAPBindingException(msg);
            }
            msg = Utils.bundle.getString("invalidChild");
            Utils.debug.error("SOAPFaultException: " + msg);
            throw new SOAPBindingException(msg);
        }
        if (detailE != null) {
            this.detail = new SOAPFaultDetail(detailE);
        }
    }

    public QName getFaultCode() {
        return this.faultcode;
    }

    public String getFaultString() {
        return this.faultstring;
    }

    public String getFaultActor() {
        return this.faultactor;
    }

    public SOAPFaultDetail getDetail() {
        return this.detail;
    }

    public void setFaultCode(QName faultcode) {
        this.faultcode = faultcode;
    }

    public void setFaultString(String faultstring) {
        this.faultstring = faultstring;
    }

    public void setFaultActor(String faultactor) {
        this.faultactor = faultactor;
    }

    public void setDetail(SOAPFaultDetail detail) {
        this.detail = detail;
    }

    void addToParent(Element bodyE) {
        Document doc = bodyE.getOwnerDocument();
        Element faultE = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "S:Fault");
        bodyE.appendChild(faultE);
        Element faultcodeE = doc.createElement("faultcode");
        String localPart = this.faultcode.getLocalPart();
        String ns = this.faultcode.getNamespaceURI();
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("SOAPFault.addToParent: faultcode ns = " + ns + ", localPart = " + localPart);
        }
        if (ns != null && ns.length() > 0) {
            String prefix;
            if (ns.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                prefix = "S";
            } else if (ns.equals("urn:liberty:sb:2003-08")) {
                prefix = "sb";
            } else {
                prefix = "fc";
                faultcodeE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, ns);
            }
            faultcodeE.appendChild(doc.createTextNode(prefix + ":" + localPart));
        } else {
            faultcodeE.appendChild(doc.createTextNode(localPart));
        }
        faultE.appendChild(faultcodeE);
        Element faultstringE = doc.createElement("faultstring");
        faultstringE.appendChild(doc.createTextNode(this.faultstring));
        faultE.appendChild(faultstringE);
        if (this.faultactor != null) {
            Element faultactorE = doc.createElement("faultactor");
            faultactorE.appendChild(doc.createTextNode(this.faultactor));
            faultE.appendChild(faultactorE);
        }
        if (this.detail != null) {
            this.detail.addToParent(faultE);
        }
    }
}

