/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.liberty.ws.security.SessionSubject;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.DateUtils;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SessionContext {
    protected SessionSubject _sessionSubject = null;
    protected AuthnContext _authnContext = null;
    protected String _providerID = null;
    protected Date _issueInstant = null;
    protected Date _authenticationInstant = null;

    protected SessionContext() {
    }

    public SessionContext(SessionSubject sessionSubject, AuthnContext authnContext, String providerID) throws SAMLException {
        if (sessionSubject == null || providerID == null) {
            SAMLUtils.debug.message("SessionContext: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._sessionSubject = sessionSubject;
        this._authnContext = authnContext;
        this._providerID = providerID;
        this._issueInstant = new Date();
        this._authenticationInstant = new Date();
    }

    public SessionSubject getSessionSubject() {
        return this._sessionSubject;
    }

    public void setSessionSubject(SessionSubject sub) {
        this._sessionSubject = sub;
    }

    public AuthnContext getAuthnContext() {
        return this._authnContext;
    }

    public String getProviderID() {
        return this._providerID;
    }

    public boolean setAuthnContext(AuthnContext authnContext) {
        if (authnContext == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SessionContext: setAuthnContext: Input is null.");
            }
            return false;
        }
        this._authnContext = authnContext;
        return true;
    }

    public SessionContext(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("AttributeStatement: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean valid = SAMLUtils.checkStatement(element, "SessionContext");
        if (!valid) {
            SAMLUtils.debug.message("SessionContext: Wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        String authInstant = element.getAttribute("AuthenticationInstant");
        String issueInstant = element.getAttribute("AssertionIssueInstant");
        if (authInstant == null || issueInstant == null) {
            SAMLUtils.debug.message("SessionContext: AuthenticationInstant or AssertionIssueInstant is missing!");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        try {
            this._issueInstant = DateUtils.stringToDate(issueInstant);
            this._authenticationInstant = DateUtils.stringToDate(authInstant);
        }
        catch (ParseException e) {
            // empty catch block
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (int i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String tagName = currentNode.getLocalName();
                String tagNS = currentNode.getNamespaceURI();
                if (tagName == null || tagName.length() == 0 || tagNS == null || tagNS.length() == 0) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SessionContext: The tag name or tag namespace of child element is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                }
                if (tagName.equals("SessionSubject") && tagNS.equals("urn:liberty:sec:2003-08")) {
                    if (this._sessionSubject != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContext: should only contain one SessionSubject");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                    }
                    try {
                        this._sessionSubject = new SessionSubject((Element)currentNode);
                        continue;
                    }
                    catch (Exception e) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContext:could not new SessionSubject object.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("SessionSubject"));
                    }
                }
                if (tagName.equals("ProviderID") && tagNS.equals("urn:liberty:sec:2003-08")) {
                    if (this._providerID != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContext: should at most contain one ProviderID.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                    }
                    this._providerID = currentNode.getChildNodes().item(0).getNodeValue();
                    continue;
                }
                if (tagName.equals("AuthnContext") && tagNS.equals("urn:liberty:iff:2003-08")) {
                    if (this._authnContext != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContext: should at most contain one AuthnContext");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                    }
                    try {
                        this._authnContext = new AuthnContext((Element)currentNode);
                        continue;
                    }
                    catch (Exception e) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContext:could not new AuthnContext object.", e);
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("AuthnContext"));
                    }
                }
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SessionContext: Wrong element " + tagName + " included.");
                }
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
            }
        }
        if (this._sessionSubject == null || this._authnContext == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SessionContext should contain one SessionSubject and one  one AuthnContext.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    public String toXMLString() throws ParseException, FSMsgException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws ParseException, FSMsgException {
        StringBuffer xml = new StringBuffer(3000);
        String secprefix = "";
        String libprefix = "";
        String liburi = "";
        String secNS = "";
        if (includeNS) {
            libprefix = "lib:";
            secprefix = "sec:";
        }
        if (declareNS) {
            liburi = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            secNS = " xmlns:sec=\"urn:liberty:sec:2003-08\"";
        }
        xml.append("<").append(secprefix).append("SessionContext").append(secNS).append(" ").append("AuthenticationInstant=").append("\"").append(DateUtils.toUTCDateFormat(this._issueInstant)).append("\" ").append("AssertionIssueInstant=").append("\"").append(DateUtils.toUTCDateFormat(this._authenticationInstant)).append("\"").append(">");
        xml.append(this._sessionSubject.toXMLString(includeNS, declareNS));
        xml.append("<").append(secprefix).append("ProviderID").append(">").append(this._providerID).append("</").append(secprefix).append("ProviderID").append(">");
        if (this._authnContext != null) {
            xml.append(this._authnContext.toXMLString(includeNS, declareNS));
        }
        xml.append("</").append(secprefix).append("SessionContext").append(">");
        return xml.toString();
    }
}

