/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class Directive {
    public static final String AUTHENTICATE_REQUESTER = "AuthenticateRequester";
    public static final String AUTHORIZE_REQUESTER = "AuthorizeRequester";
    public static final String AUTHENTICATE_SESSION_CONTEXT = "AuthenticateSessionContext";
    public static final String ENCRYPT_RESOURCEID = "EncryptResourceID";
    public static final String GENERATE_BEARER_TOKEN = "GenerateBearerToken";
    private String type = null;
    private List descIDRefs = null;

    public Directive(String directiveType) {
        this.type = directiveType;
    }

    public Directive(Element elem) throws DiscoveryException {
        String tag = null;
        if (elem == null) {
            DiscoUtils.debug.message("Directive(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        tag = elem.getLocalName();
        if (tag == null) {
            DiscoUtils.debug.message("Directive(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        if (tag.equals(AUTHENTICATE_REQUESTER)) {
            this.type = AUTHENTICATE_REQUESTER;
            this.setDescIDRefs(elem);
        } else if (tag.equals(AUTHORIZE_REQUESTER)) {
            this.type = AUTHORIZE_REQUESTER;
            this.setDescIDRefs(elem);
        } else if (tag.equals(AUTHENTICATE_SESSION_CONTEXT)) {
            this.type = AUTHENTICATE_SESSION_CONTEXT;
            this.setDescIDRefs(elem);
        } else if (tag.equals(ENCRYPT_RESOURCEID)) {
            this.type = ENCRYPT_RESOURCEID;
            this.setDescIDRefs(elem);
        } else if (tag.equals(GENERATE_BEARER_TOKEN)) {
            this.type = GENERATE_BEARER_TOKEN;
            this.setDescIDRefs(elem);
        } else {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Directive(Element): not supported:" + tag);
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("directiveNotSupported"));
        }
    }

    private void setDescIDRefs(Element elem) {
        StringTokenizer st;
        String ids = elem.getAttribute("descriptionIDRefs");
        if (ids != null && ids.length() != 0 && (st = new StringTokenizer(ids)).countTokens() > 0) {
            if (this.descIDRefs == null) {
                this.descIDRefs = new ArrayList();
            }
            while (st.hasMoreTokens()) {
                this.descIDRefs.add(st.nextToken());
            }
        }
    }

    public List getDescriptionIDRef() {
        return this.descIDRefs;
    }

    public void setDescriptionIDRef(List idrefs) {
        this.descIDRefs = idrefs;
    }

    public String getDirectiveType() {
        return this.type;
    }

    public void setDirectiveType(String directiveType) {
        this.type = directiveType;
    }

    public String toString() {
        String ns = null;
        ns = this.type.equals(GENERATE_BEARER_TOKEN) ? "urn:liberty:disco:2004-04" : "urn:liberty:disco:2003-08";
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append(this.type).append(" xmlns=\"").append(ns).append("\"");
        if (this.descIDRefs != null) {
            sb.append(" descriptionIDRefs=\"");
            Iterator iter = this.descIDRefs.iterator();
            if (iter.hasNext()) {
                sb.append((String)iter.next());
            }
            while (iter.hasNext()) {
                sb.append(" ").append((String)iter.next());
            }
            sb.append("\"");
        }
        sb.append(">");
        sb.append("</").append(this.type).append(">");
        return sb.toString();
    }
}

