/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.common.wsse;

import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class BinarySecurityToken {
    private String value = null;
    private QName valueType = null;
    private QName encodingType = null;
    private String id = null;
    private String xmlString = null;
    private static ResourceBundle bundle = Locale.getInstallResourceBundle("libBinarySecurityToken");
    private static Debug debug = Debug.getInstance("libBinarySecurityToken");
    private static final String WSSE = "wsse";
    private static final String WSU = "wsu";
    private static final String BINARY_SECURITY_TOKEN = "BinarySecurityToken";
    private static final String ENCODING_TYPE = "EncodingType";
    private static final String VALUE_TYPE = "ValueType";
    private static final String ID = "Id";
    private static final String XML_NS = "xmlns";
    private String wsfVersion = null;
    private String wsseNS = null;
    private String wsuNS = null;
    public static final QName X509V3 = new QName("X509v3");
    public static final QName KERBEROSV5TGT = new QName("Kerberosv5TGT");
    public static final QName KERBEROSV5ST = new QName("Kerberosv5ST");
    public static final QName PKCS7 = new QName("PKCS7");
    public static final QName PKIPath = new QName("PKIPath");
    static Map valueMap = new HashMap();
    public static final QName BASE64BINARY;
    public static final QName HEXBINARY;
    static Map encodingMap;

    private BinarySecurityToken() {
    }

    public BinarySecurityToken(String value, QName valueType, QName encodingType) throws Exception {
        if (value == null || valueType == null || encodingType == null) {
            debug.error("BinarySecurityToken: null input param");
            throw new Exception(bundle.getString("nullInputParameter"));
        }
        this.value = value;
        this.valueType = valueType;
        this.encodingType = encodingType;
        this.id = SAMLUtils.generateID();
        this.setWSFVersion(Utils.getDefaultWSFVersion());
    }

    public BinarySecurityToken(Element token) throws Exception {
        if (token == null) {
            debug.error("BinarySecurityToken: null input token");
            throw new Exception(bundle.getString("nullInputParameter"));
        }
        String elementName = token.getLocalName();
        if (elementName == null) {
            debug.error("BinarySecurityToken: local name missing");
            throw new Exception(bundle.getString("nullInput"));
        }
        if (!elementName.equals(BINARY_SECURITY_TOKEN)) {
            debug.error("BinarySecurityToken: invalid root element");
            throw new Exception(bundle.getString("invalidElement") + ":" + elementName);
        }
        this.wsseNS = token.getNamespaceURI();
        if (this.wsseNS != null && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(this.wsseNS)) {
            this.wsfVersion = "1.1";
        } else if (this.wsseNS != null && "http://schemas.xmlsoap.org/ws/2003/06/secext".equals(this.wsseNS)) {
            this.wsfVersion = "1.0";
        } else {
            throw new Exception(bundle.getString("invalidNameSpace"));
        }
        NamedNodeMap nm = token.getAttributes();
        if (nm == null) {
            debug.error("BinarySecurityToken: missing attr in element");
            throw new Exception(bundle.getString("missingAttribute"));
        }
        int len = nm.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)nm.item(i);
            String localName = attr.getLocalName();
            if (localName == null) {
                if (!debug.messageEnabled()) continue;
                debug.message("BST.Elemement, invalid attr " + localName);
                continue;
            }
            if (localName.equals(ID)) {
                this.id = attr.getValue();
                this.wsuNS = attr.getNamespaceURI();
                continue;
            }
            if (localName.equals(ENCODING_TYPE)) {
                this.encodingType = (QName)encodingMap.get(this.trimPrefix(attr.getValue()));
                continue;
            }
            if (!localName.equals(VALUE_TYPE)) continue;
            this.valueType = (QName)valueMap.get(this.trimPrefix(attr.getValue()));
        }
        if (this.id == null || this.id.length() == 0) {
            debug.error("BinarySecurityToken: ID missing");
            throw new Exception(bundle.getString("missingAttribute") + " : " + ID);
        }
        if (this.encodingType == null) {
            debug.error("BinarySecurityToken: encoding type missing");
            throw new Exception(bundle.getString("missingAttribute") + " : " + ENCODING_TYPE);
        }
        if (this.valueType == null) {
            debug.error("BinarySecurityToken: valueType missing");
            throw new Exception(bundle.getString("missingAttribute") + " : " + VALUE_TYPE);
        }
        try {
            this.value = token.getFirstChild().getNodeValue().trim();
        }
        catch (Exception e) {
            debug.error("BinarySecurityToken: unable to get value", e);
            this.value = null;
        }
        if (this.value == null) {
            debug.error("BinarySecurityToken: value missing");
            throw new Exception(bundle.getString("missingValue"));
        }
        this.xmlString = XMLUtils.print(token);
    }

    private String trimPrefix(String val) {
        if (val != null && (val.startsWith("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0") || val.startsWith("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0"))) {
            return val;
        }
        int pos = val.indexOf(":");
        if (pos == -1) {
            return val;
        }
        if (pos == val.length()) {
            return "";
        }
        return val.substring(pos + 1);
    }

    public QName getEncodingType() {
        return this.encodingType;
    }

    public QName getValueType() {
        return this.valueType;
    }

    public String getId() {
        return this.id;
    }

    public String getTokenValue() {
        return this.value;
    }

    public String toString() {
        if (this.xmlString == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<").append(WSSE).append(":").append(BINARY_SECURITY_TOKEN).append(" ").append(XML_NS).append(":").append(WSSE).append("=\"").append(this.wsseNS).append("\" ").append(XML_NS).append(":").append(WSU).append("=\"").append(this.wsuNS).append("\" ").append(WSU).append(":").append(ID).append("=\"").append(this.id).append("\" ").append(VALUE_TYPE).append("=\"");
            if ("1.1".equals(this.wsfVersion)) {
                sb.append("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0").append("#").append(this.valueType.getLocalPart()).append("\" ").append(ENCODING_TYPE).append("=\"").append("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0").append("#").append(this.encodingType.getLocalPart()).append("\">\n");
            } else {
                sb.append(WSSE).append(":").append(this.valueType.getLocalPart()).append("\" ").append(ENCODING_TYPE).append("=\"").append(WSSE).append(":").append(this.encodingType.getLocalPart()).append("\">\n");
            }
            sb.append(this.value.toString()).append("\n").append("</").append(WSSE).append(":").append(BINARY_SECURITY_TOKEN).append(">\n");
            this.xmlString = sb.toString();
        }
        return this.xmlString;
    }

    public void addToParent(Element headerE) throws Exception {
        Document doc = headerE.getOwnerDocument();
        Element securityE = doc.createElementNS(this.wsseNS, "wsse:Security");
        securityE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", this.wsseNS);
        headerE.appendChild(securityE);
        Document binaryTokenD = XMLUtils.toDOMDocument(this.toString(), debug);
        Element binaryTokenE = binaryTokenD.getDocumentElement();
        securityE.appendChild(doc.importNode(binaryTokenE, true));
    }

    public String getWSFVersion() {
        return this.wsfVersion;
    }

    public void setWSFVersion(String version) {
        this.wsfVersion = version;
        if (this.wsfVersion != null && "1.0".equals(this.wsfVersion)) {
            this.wsseNS = "http://schemas.xmlsoap.org/ws/2003/06/secext";
            this.wsuNS = "http://schemas.xmlsoap.org/ws/2003/06/utility";
        } else {
            this.wsseNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
            this.wsuNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        }
        this.xmlString = null;
    }

    static {
        valueMap.put(X509V3.getLocalPart(), X509V3);
        valueMap.put(PKIPath.getLocalPart(), PKIPath);
        valueMap.put(PKCS7.getLocalPart(), PKCS7);
        valueMap.put(KERBEROSV5ST.getLocalPart(), KERBEROSV5ST);
        valueMap.put(KERBEROSV5TGT.getLocalPart(), KERBEROSV5TGT);
        valueMap.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", X509V3);
        BASE64BINARY = new QName("Base64Binary");
        HEXBINARY = new QName("HexBinary");
        encodingMap = new HashMap();
        encodingMap.put(HEXBINARY.getLocalPart(), HEXBINARY);
        encodingMap.put(BASE64BINARY.getLocalPart(), BASE64BINARY);
        encodingMap.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary", BASE64BINARY);
    }
}

