/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.protocol;

import com.sun.identity.liberty.ws.authnsvc.AuthnSvcException;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SASLRequest {
    private byte[] data = null;
    private Element requestAuthnContext = null;
    private String mechanism = null;
    private String authzID = null;
    private String advisoryAuthnID = null;
    private String id = null;
    private String messageID = null;
    private String refToMessageID = null;

    public SASLRequest(String mechanism) {
        this.mechanism = mechanism;
    }

    public SASLRequest(Element element) throws AuthnSvcException {
        Element dataE = null;
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            Element childElement = (Element)child;
            String localName = childElement.getLocalName();
            String namespaceURI = childElement.getNamespaceURI();
            if ("urn:liberty:sa:2004-04".equals(namespaceURI) && "Data".equals(localName)) {
                if (dataE != null) {
                    throw new AuthnSvcException("tooManyDataInReq");
                }
                if (this.requestAuthnContext != null) {
                    throw new AuthnSvcException("invalidSeqInReq");
                }
                dataE = childElement;
                continue;
            }
            if ("urn:liberty:iff:2003-08".equals(namespaceURI) && "RequestAuthnContext".equals(localName)) {
                if (this.requestAuthnContext != null) {
                    throw new AuthnSvcException("tooManyReqAuthnCon");
                }
                this.requestAuthnContext = childElement;
                continue;
            }
            throw new AuthnSvcException("invalidChildReq");
        }
        this.data = AuthnSvcUtils.decodeDataElement(dataE);
        this.mechanism = XMLUtils.getNodeAttributeValue(element, "mechanism");
        if (this.mechanism == null) {
            String msg = AuthnSvcUtils.getString("missingMechanism");
            AuthnSvcUtils.debug.error("SASLRequest: " + msg);
            throw new AuthnSvcException(msg);
        }
        this.id = XMLUtils.getNodeAttributeValue(element, "id");
        this.authzID = XMLUtils.getNodeAttributeValue(element, "authzID");
        this.advisoryAuthnID = XMLUtils.getNodeAttributeValue(element, "advisoryAuthnID");
    }

    public byte[] getData() {
        return this.data;
    }

    public Element getRequestAuthnContext() {
        return this.requestAuthnContext;
    }

    public String getMechanism() {
        return this.mechanism;
    }

    public String getAuthzID() {
        return this.authzID;
    }

    public String getAdvisoryAuthnID() {
        return this.advisoryAuthnID;
    }

    public String getId() {
        return this.id;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getRefToMessageID() {
        return this.refToMessageID;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setRequestAuthnContext(Element requestAuthnContext) {
        this.requestAuthnContext = requestAuthnContext;
    }

    public void setMechanism(String mechanism) {
        this.mechanism = mechanism;
    }

    public void setAuthzID(String authzID) {
        this.authzID = authzID;
    }

    public void setAdvisoryAuthnID(String advisoryAuthnID) {
        this.advisoryAuthnID = advisoryAuthnID;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public void setRefToMessageID(String refToMessageID) {
        this.refToMessageID = refToMessageID;
    }

    public Element toElement() throws AuthnSvcException {
        Document doc = null;
        try {
            doc = XMLUtils.newDocument();
        }
        catch (Exception ex) {
            AuthnSvcUtils.debug.error("SASLRequest:toElement", ex);
            throw new AuthnSvcException(ex.getMessage());
        }
        Element saslReqE = doc.createElementNS("urn:liberty:sa:2004-04", "sa:SASLRequest");
        saslReqE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sa", "urn:liberty:sa:2004-04");
        saslReqE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:lib", "urn:liberty:iff:2003-08");
        saslReqE.setAttributeNS(null, "mechanism", this.mechanism);
        if (this.authzID != null) {
            saslReqE.setAttributeNS(null, "authzID", this.authzID);
        }
        if (this.advisoryAuthnID != null) {
            saslReqE.setAttributeNS(null, "advisoryAuthnID", this.advisoryAuthnID);
        }
        if (this.id != null) {
            saslReqE.setAttributeNS(null, "id", this.id);
        }
        if (this.data != null) {
            Element dataE = doc.createElementNS("urn:liberty:sa:2004-04", "sa:Data");
            dataE.appendChild(doc.createTextNode(Base64.encode(this.data)));
            saslReqE.appendChild(dataE);
        }
        doc.appendChild(saslReqE);
        return doc.getDocumentElement();
    }
}

