/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.protocol;

import com.sun.identity.liberty.ws.authnsvc.AuthnSvcException;
import com.sun.identity.liberty.ws.authnsvc.protocol.Transform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PasswordTransforms {
    private List transforms = null;

    public PasswordTransforms(List transforms) {
        this.transforms = transforms;
    }

    PasswordTransforms(Element element) throws AuthnSvcException {
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            Element childElement = (Element)child;
            String localName = childElement.getLocalName();
            String namespaceURI = childElement.getNamespaceURI();
            if ("urn:liberty:sa:2004-04".equals(namespaceURI) && "Transform".equals(localName)) {
                Transform tf = Transform.getTransform(childElement);
                if (this.transforms == null) {
                    this.transforms = new ArrayList();
                }
                this.transforms.add(tf);
                continue;
            }
            throw new AuthnSvcException("invalidChildPT");
        }
    }

    public List getTransforms() {
        return this.transforms;
    }

    public void setTransforms(List transforms) {
        this.transforms = transforms;
    }

    void addToParent(Element respE) throws AuthnSvcException {
        if (this.transforms == null || this.transforms.isEmpty()) {
            throw new AuthnSvcException("noChildPT");
        }
        Document doc = respE.getOwnerDocument();
        Element ptE = doc.createElementNS("urn:liberty:sa:2004-04", "sa:PasswordTransforms");
        respE.appendChild(ptE);
        Iterator iter = this.transforms.iterator();
        while (iter.hasNext()) {
            Transform tf = (Transform)iter.next();
            tf.addToParent(ptE);
        }
    }
}

