/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdServicesFactory;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceListener;

public class IdRepoServiceListener
implements ServiceListener {
    Debug debug = AMIdentityRepository.debug;

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        if (this.debug.messageEnabled()) {
            this.debug.message("IdRepoServiceListener: Global Config changed called");
        }
        if (serviceComponent.equals("") || serviceComponent.equals("/")) {
            return;
        }
        if (!serviceComponent.startsWith("/users/") && !serviceComponent.startsWith("/roles/") && type != 1) {
            idServices.clearIdRepoPlugins();
        }
        IdUtils.clearOrganizationNamesCache();
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        if (this.debug.messageEnabled()) {
            this.debug.message("IdRepoServiceListener: Org Config changed called");
        }
        if (type == 2 && serviceComponent.equals("/")) {
            idServices.clearIdRepoPlugins(orgName, serviceComponent, type);
        } else if (!serviceComponent.equals("") && !serviceComponent.equals("/")) {
            idServices.clearIdRepoPlugins(orgName, serviceComponent, type);
        }
        IdUtils.clearOrganizationNamesCache();
    }

    public void schemaChanged(String serviceName, String version) {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        if (this.debug.messageEnabled()) {
            this.debug.message("IdRepoServiceListener: Schema changed called");
        }
        idServices.clearIdRepoPlugins();
        idServices.reloadIdRepoServiceSchema();
    }
}

