/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.meta;

import com.sun.identity.federation.jaxb.entityconfig.AttributeType;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.NamespacePrefixMapperImpl;
import com.sun.identity.liberty.ws.meta.jaxb.EntityDescriptorElement;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.shared.debug.Debug;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class IDFFMetaUtils {
    public static final String IDFF_META_SERVICE = "ID-FF_META";
    public static Debug debug = Debug.getInstance("libIDFFMeta");
    protected static String IDFF_BUNDLE_NAME = "libIDFFMeta";
    private static final String JAXB_PACKAGES = "com.sun.identity.liberty.ws.meta.jaxb:com.sun.identity.federation.jaxb.entityconfig:";
    private static JAXBContext jaxbContext = null;
    private static final String PROP_JAXB_FORMATTED_OUTPUT = "jaxb.formatted.output";
    private static final String PROP_NAMESPACE_PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
    private static NamespacePrefixMapperImpl nsPrefixMapper = new NamespacePrefixMapperImpl();

    protected IDFFMetaUtils() {
    }

    public static String convertJAXBToString(Object jaxbObj) throws JAXBException {
        StringWriter sw = new StringWriter();
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty(PROP_JAXB_FORMATTED_OUTPUT, (Object)Boolean.TRUE);
        marshaller.setProperty(PROP_NAMESPACE_PREFIX_MAPPER, (Object)nsPrefixMapper);
        marshaller.marshal(jaxbObj, (Writer)sw);
        return sw.toString();
    }

    protected static Map convertJAXBToAttrMap(String attrName, Object jaxbObj) throws JAXBException {
        String xmlString = IDFFMetaUtils.convertJAXBToString(jaxbObj);
        HashMap attrs = new HashMap();
        HashSet<String> values = new HashSet<String>();
        values.add(xmlString);
        attrs.put(attrName, values);
        return attrs;
    }

    public static Object convertNodeToJAXB(Node node) throws JAXBException {
        Unmarshaller u = jaxbContext.createUnmarshaller();
        return u.unmarshal(node);
    }

    public static Object convertStringToJAXB(String str) throws JAXBException {
        Unmarshaller u = jaxbContext.createUnmarshaller();
        return u.unmarshal((Source)new StreamSource(new StringReader(str)));
    }

    public static SPDescriptorType getSPDescriptor(EntityDescriptorElement entityDescriptor) {
        List spList;
        SPDescriptorType spDescriptor = null;
        if (entityDescriptor != null && (spList = entityDescriptor.getSPDescriptor()) != null && !spList.isEmpty()) {
            Iterator spIterator = spList.iterator();
            while (spIterator.hasNext()) {
                Object eObj = spIterator.next();
                if (!(eObj instanceof SPDescriptorType)) continue;
                spDescriptor = (SPDescriptorType)eObj;
                break;
            }
        }
        return spDescriptor;
    }

    public static IDPDescriptorType getIDPDescriptor(EntityDescriptorElement entityDescriptor) {
        List idpList;
        IDPDescriptorType idpDescriptor = null;
        if (entityDescriptor != null && (idpList = entityDescriptor.getIDPDescriptor()) != null && !idpList.isEmpty()) {
            Iterator idpIterator = idpList.iterator();
            while (idpIterator.hasNext()) {
                Object eObj = idpIterator.next();
                if (!(eObj instanceof IDPDescriptorType)) continue;
                idpDescriptor = (IDPDescriptorType)eObj;
                break;
            }
        }
        return idpDescriptor;
    }

    public static SPDescriptorConfigElement getSPDescriptorConfig(EntityConfigElement entityConfig) {
        List spCfgList;
        SPDescriptorConfigElement spEntityConfig = null;
        if (entityConfig != null && (spCfgList = entityConfig.getSPDescriptorConfig()) != null && !spCfgList.isEmpty()) {
            Iterator spCfgIterator = spCfgList.iterator();
            while (spCfgIterator.hasNext()) {
                Object eObj = spCfgIterator.next();
                if (!(eObj instanceof SPDescriptorConfigElement)) continue;
                spEntityConfig = (SPDescriptorConfigElement)eObj;
                break;
            }
        }
        return spEntityConfig;
    }

    public static IDPDescriptorConfigElement getIDPDescriptorConfig(EntityConfigElement entityConfig) {
        List idpCfgList;
        IDPDescriptorConfigElement idpEntityConfig = null;
        if (entityConfig != null && (idpCfgList = entityConfig.getIDPDescriptorConfig()) != null && !idpCfgList.isEmpty()) {
            Iterator idpCfgIterator = idpCfgList.iterator();
            while (idpCfgIterator.hasNext()) {
                Object eObj = idpCfgIterator.next();
                if (!(eObj instanceof IDPDescriptorConfigElement)) continue;
                idpEntityConfig = (IDPDescriptorConfigElement)eObj;
                break;
            }
        }
        return idpEntityConfig;
    }

    public static Map getAttributes(BaseConfigType config) {
        HashMap<String, List> attrMap = new HashMap<String, List>();
        List list = config.getAttribute();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            AttributeType avp = (AttributeType)iter.next();
            attrMap.put(avp.getName(), avp.getValue());
        }
        return attrMap;
    }

    public static String getFirstAttributeValue(Map attrMap, String key) {
        List valueList;
        String retValue = null;
        if (attrMap != null && !attrMap.isEmpty() && (valueList = (List)attrMap.get(key)) != null && !valueList.isEmpty()) {
            retValue = (String)valueList.iterator().next();
        }
        return retValue;
    }

    public static boolean isAutoFedEnabled(Map attributes) {
        boolean returnVal = false;
        String autoFedEnabledStr = IDFFMetaUtils.getFirstAttributeValue(attributes, "enableAutoFederation");
        if (autoFedEnabledStr != null) {
            returnVal = autoFedEnabledStr.equalsIgnoreCase("true");
        }
        return returnVal;
    }

    public static String getFirstAttributeValueFromIDPConfig(IDFFMetaManager metaManager, String realm, String idpEntityID, String attrName) {
        if (metaManager == null || idpEntityID == null || attrName == null) {
            return null;
        }
        String returnVal = null;
        try {
            IDPDescriptorConfigElement idpConfig = metaManager.getIDPDescriptorConfig(realm, idpEntityID);
            if (idpConfig != null) {
                Map attributes = IDFFMetaUtils.getAttributes(idpConfig);
                returnVal = IDFFMetaUtils.getFirstAttributeValue(attributes, attrName);
            }
        }
        catch (IDFFMetaException e) {
            returnVal = null;
        }
        return returnVal;
    }

    public static boolean getBooleanAttributeValueFromConfig(BaseConfigType config, String attrName) {
        String valStr = IDFFMetaUtils.getFirstAttributeValueFromConfig(config, attrName);
        return valStr != null && valStr.equalsIgnoreCase("true");
    }

    public static String getFirstAttributeValueFromConfig(BaseConfigType config, String attrName) {
        if (config == null || attrName == null) {
            return null;
        }
        Map attributes = IDFFMetaUtils.getAttributes(config);
        return IDFFMetaUtils.getFirstAttributeValue(attributes, attrName);
    }

    public static List getAttributeValueFromConfig(BaseConfigType config, String attrName) {
        if (config == null || attrName == null) {
            return null;
        }
        Map attributes = IDFFMetaUtils.getAttributes(config);
        if (attributes != null) {
            return (List)attributes.get(attrName);
        }
        return null;
    }

    public static String getRealmByMetaAlias(String metaAlias) {
        if (metaAlias == null) {
            return null;
        }
        int index = metaAlias.lastIndexOf("/");
        if (index == -1 || index == 0) {
            return "/";
        }
        return metaAlias.substring(0, index);
    }

    public static String getMetaAliasByUri(String uri) {
        if (uri == null) {
            return null;
        }
        int index = uri.indexOf("metaAlias");
        if (index == -1 || index + 9 == uri.length()) {
            return null;
        }
        return uri.substring(index + 9);
    }

    public static String getMetaAlias(String realm, String providerID, String providerRole, Object session) {
        block3: {
            try {
                BaseConfigType extendedConfig;
                IDFFMetaManager metaManager = new IDFFMetaManager(session);
                if (metaManager != null && (extendedConfig = IDFFMetaUtils.getExtendedConfig(realm, providerID, providerRole, metaManager)) != null) {
                    return extendedConfig.getMetaAlias();
                }
            }
            catch (IDFFMetaException e) {
                if (!debug.messageEnabled()) break block3;
                debug.message("IDFFMetaUtils.getMetaAlias:", e);
            }
        }
        return null;
    }

    public static BaseConfigType getExtendedConfig(String realm, String providerId, String providerRole, IDFFMetaManager metaManager) {
        BaseConfigType providerConfig = null;
        if (metaManager != null && providerRole != null) {
            try {
                if (providerRole.equalsIgnoreCase("IDP")) {
                    providerConfig = metaManager.getIDPDescriptorConfig(realm, providerId);
                } else if (providerRole.equalsIgnoreCase("SP")) {
                    providerConfig = metaManager.getSPDescriptorConfig(realm, providerId);
                }
            }
            catch (IDFFMetaException ie) {
                debug.error("IDFFMetaUtils.getExtendedConfig: couldn't get meta:", ie);
            }
        }
        return providerConfig;
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGES);
        }
        catch (JAXBException jaxbe) {
            debug.error("IDFFMetaUtils.static:", jaxbe);
            jaxbe.printStackTrace();
        }
    }
}

