/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.meta;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.AffiliationDescriptorConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.meta.IDFFMetaCache;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaServiceListener;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.liberty.ws.meta.jaxb.AffiliationDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.EntityDescriptorElement;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;

public class IDFFMetaManager {
    private static Debug debug = IDFFMetaUtils.debug;
    private static String ROOT_REALM = "/";
    private static String IDFF_METADATA_ATTR = "sun-fm-idff-metadata";
    private static String IDFF_ENTITY_CONFIG_ATTR = "sun-fm-idff-entityconfig";
    private static CircleOfTrustManager cotManager = null;
    ConfigurationInstance idffMetaConfigInstance = null;
    Object session = null;
    public static final String NAME_META_ALIAS_IN_URI = "metaAlias";

    public IDFFMetaManager(Object session) throws IDFFMetaException {
        String classMethod = "IDFFMetaManger:Constructor : ";
        this.session = session;
        try {
            this.idffMetaConfigInstance = ConfigurationManager.getConfigurationInstance("ID-FF_META");
        }
        catch (ConfigurationException ce) {
            debug.error("IDFFManager:Constructor : ", ce);
            throw new IDFFMetaException(ce);
        }
        if (this.idffMetaConfigInstance == null) {
            debug.error(classMethod + "Could not get Configuration Instance for" + "IDFF Meta Service");
            LogUtil.error(Level.INFO, "ERROR_GET_IDFF_META_INSTANCE", null);
            throw new IDFFMetaException("nullConfig", null);
        }
        try {
            this.idffMetaConfigInstance.addListener(new IDFFMetaServiceListener());
        }
        catch (ConfigurationException ce) {
            debug.error(classMethod + "Unable to register " + "ConfigurationListener for IDFF Meta service", ce);
        }
    }

    public void createEntityDescriptor(String realm, EntityDescriptorElement entityDescriptor) throws IDFFMetaException {
        String classMethod = "IDFFMetaManager.createEntityDescriptor:";
        String entityId = null;
        if (entityDescriptor == null) {
            LogUtil.error(Level.INFO, "NULL_ENTITY_DESCRIPTOR", null);
            throw new IDFFMetaException("nullEntityDescriptor", null);
        }
        entityId = entityDescriptor.getProviderID();
        if (entityId == null) {
            debug.error(classMethod + "Entity ID is null");
            LogUtil.error(Level.INFO, "NULL_ENTITY_ID", null);
            throw new IDFFMetaException("nullEntityID", null);
        }
        if (realm == null || realm.length() == 0) {
            realm = ROOT_REALM;
        }
        Object[] args = new String[]{entityId, realm};
        EntityDescriptorElement descriptor = this.getEntityDescriptor(realm, entityId);
        if (descriptor != null) {
            List idps = descriptor.getIDPDescriptor();
            boolean hasIDP = idps != null && !idps.isEmpty();
            List sps = descriptor.getSPDescriptor();
            boolean hasSP = sps != null && !sps.isEmpty();
            List newIDPs = entityDescriptor.getIDPDescriptor();
            List newSPs = entityDescriptor.getSPDescriptor();
            if (newIDPs != null && !newIDPs.isEmpty() && hasIDP) {
                LogUtil.error(Level.INFO, "SET_ENTITY_FAILED", (String[])args);
                throw new IDFFMetaException("idpAlreadyExisted", args);
            }
            if (newSPs != null && !newSPs.isEmpty() && hasSP) {
                LogUtil.error(Level.INFO, "SET_ENTITY_FAILED", (String[])args);
                throw new IDFFMetaException("spAlreadyExisted", args);
            }
            idps.addAll(newIDPs);
            sps.addAll(newSPs);
            this.setEntityDescriptor(realm, descriptor);
        } else {
            try {
                Map attrs = IDFFMetaUtils.convertJAXBToAttrMap(IDFF_METADATA_ATTR, entityDescriptor);
                if (debug.messageEnabled()) {
                    debug.message(classMethod + attrs);
                }
                this.idffMetaConfigInstance.createConfiguration(realm, entityId, attrs);
                LogUtil.access(Level.INFO, "CREATE_ENTITY_SUCCEEDED", (String[])args);
            }
            catch (ConfigurationException ce) {
                debug.error("Cannot create entity descriptor", ce);
                LogUtil.error(Level.INFO, "CREATE_ENTITY_FAILED", (String[])args);
                throw new IDFFMetaException(ce);
            }
            catch (UnsupportedOperationException uoe) {
                debug.error("Creating EntityDescriptor : Unsupported operation");
                LogUtil.error(Level.INFO, "UNSUPPORTED_OPERATION", null);
                throw new IDFFMetaException("unsupportedOperation", null);
            }
            catch (JAXBException jaxbe) {
                debug.error(classMethod, jaxbe);
                LogUtil.error(Level.INFO, "INVALID_ENTITY_DESCRIPTOR", (String[])args);
                throw new IDFFMetaException("invalidEntityDescriptor", args);
            }
        }
    }

    public EntityDescriptorElement getEntityDescriptor(String realm, String entityID) throws IDFFMetaException {
        String classMethod = "IDFFMetaManager.getEntityDescriptor:";
        if (debug.messageEnabled()) {
            debug.message(classMethod + " Retreiving EntityDescriptor");
        }
        EntityDescriptorElement entityDescriptor = null;
        if (entityID != null) {
            if (realm == null || realm.length() == 0) {
                realm = ROOT_REALM;
            }
            Object[] args = new String[]{entityID, realm};
            entityDescriptor = IDFFMetaCache.getEntityDescriptor(realm, entityID);
            if (entityDescriptor == null) {
                try {
                    Set metaValues;
                    Map attrs = this.idffMetaConfigInstance.getConfiguration(realm, entityID);
                    if (attrs != null && (metaValues = (Set)attrs.get(IDFF_METADATA_ATTR)) != null && !metaValues.isEmpty()) {
                        String metaValue = (String)metaValues.iterator().next();
                        Object object = IDFFMetaUtils.convertStringToJAXB(metaValue);
                        if (object instanceof EntityDescriptorElement) {
                            entityDescriptor = (EntityDescriptorElement)object;
                            IDFFMetaCache.setEntityDescriptor(realm, entityID, entityDescriptor);
                        } else {
                            debug.error(classMethod + "Invalid standard " + " meta value for : " + entityID);
                        }
                    }
                }
                catch (ConfigurationException ce) {
                    debug.error("Cannot retrieve entity descriptor", ce);
                    LogUtil.error(Level.INFO, "GET_ENTITY_FAILED", (String[])args);
                    throw new IDFFMetaException("cannotRetreiveEntityDescriptor", null);
                }
                catch (JAXBException jaxbe) {
                    debug.error(classMethod, jaxbe);
                    LogUtil.error(Level.INFO, "INVALID_ENTITY_DESCRIPTOR", (String[])args);
                    throw new IDFFMetaException("invalidEntityDescriptor", args);
                }
            }
            if (entityDescriptor != null) {
                LogUtil.access(Level.INFO, "GET_ENTITY_SUCCEEDED", (String[])args);
            }
        } else {
            LogUtil.error(Level.INFO, "NULL_ENTITY_ID", null);
            throw new IDFFMetaException("nullEntityID", null);
        }
        return entityDescriptor;
    }

    public void setEntityDescriptor(String realm, EntityDescriptorElement entityDescriptor) throws IDFFMetaException {
        String classMethod = "IDFFMetaManager:setEntityDescriptor";
        if (entityDescriptor != null) {
            String entityID = entityDescriptor.getProviderID();
            if (realm == null || realm.length() == 0) {
                realm = ROOT_REALM;
            }
            Object[] args = new String[]{entityID, realm};
            try {
                Map origEntityAttrs = null;
                if (entityID == null) {
                    LogUtil.error(Level.INFO, "NULL_ENTITY_ID", (String[])args);
                    throw new IDFFMetaException("nullEntityID", null);
                }
                origEntityAttrs = this.idffMetaConfigInstance.getConfiguration(realm, entityID);
                Map newAttrs = IDFFMetaUtils.convertJAXBToAttrMap(IDFF_METADATA_ATTR, entityDescriptor);
                origEntityAttrs.put(IDFF_METADATA_ATTR, newAttrs.get(IDFF_METADATA_ATTR));
                this.idffMetaConfigInstance.setConfiguration(realm, entityID, origEntityAttrs);
                LogUtil.access(Level.INFO, "SET_ENTITY_SUCCEEDED", (String[])args);
            }
            catch (ConfigurationException ce) {
                debug.error("Error setting Entity Descriptor ", ce);
                LogUtil.error(Level.INFO, "SET_ENTITY_FAILED", (String[])args);
                throw new IDFFMetaException(ce);
            }
            catch (JAXBException jaxbe) {
                debug.error(classMethod + "Invalid EntityID" + entityID, jaxbe);
                LogUtil.error(Level.INFO, "INVALID_ENTITY_DESCRIPTOR", (String[])args);
                throw new IDFFMetaException("invalidEntityDescriptor", args);
            }
        }
    }

    public void deleteEntityDescriptor(String realm, String entityID) throws IDFFMetaException {
        if (entityID == null) {
            LogUtil.error(Level.INFO, "NULL_ENTITY_ID", null);
            throw new IDFFMetaException("nullEntityID", null);
        }
        if (realm == null || realm.length() == 0) {
            realm = ROOT_REALM;
        }
        Object[] args = new String[]{entityID, realm};
        try {
            Map oldAttrs = this.idffMetaConfigInstance.getConfiguration(realm, entityID);
            if (oldAttrs == null || oldAttrs.isEmpty()) {
                LogUtil.error(Level.INFO, "ENTITY_DOES_NOT_EXISTS", (String[])args);
                throw new IDFFMetaException("entityDoesNotExists", args);
            }
            this.removeEntityFromCOT(realm, entityID);
            this.idffMetaConfigInstance.deleteConfiguration(realm, entityID, null);
            LogUtil.access(Level.INFO, "DELETE_ENTITY_SUCCEEDED", (String[])args);
            IDFFMetaCache.setEntityDescriptor(realm, entityID, null);
        }
        catch (ConfigurationException ce) {
            debug.error("Error deleting Entity Descriptor" + entityID, ce);
            LogUtil.error(Level.INFO, "DELETE_ENTITY_FAILED", (String[])args);
            throw new IDFFMetaException(ce);
        }
        catch (UnsupportedOperationException uoe) {
            debug.error("Unsupported operation", uoe);
            LogUtil.error(Level.INFO, "UNSUPPORTED_OPERATION", null);
            throw new IDFFMetaException("unsupportedOperation", null);
        }
    }

    public void deleteEntityConfig(String realm, String entityId) throws IDFFMetaException {
        if (entityId == null) {
            LogUtil.error(Level.INFO, "NULL_ENTITY_ID", null);
            throw new IDFFMetaException("nullEntityID", null);
        }
        if (realm == null || realm.length() == 0) {
            realm = ROOT_REALM;
        }
        Object[] args = new String[]{entityId, realm};
        try {
            Map oldAttrs = this.idffMetaConfigInstance.getConfiguration(realm, entityId);
            if (oldAttrs == null || oldAttrs.isEmpty()) {
                LogUtil.error(Level.INFO, "ENTITY_DOES_NOT_EXISTS", (String[])args);
                throw new IDFFMetaException("entityDoesNotExists", args);
            }
            Set oldValues = (Set)oldAttrs.get(IDFF_ENTITY_CONFIG_ATTR);
            if (oldValues == null || oldValues.isEmpty()) {
                LogUtil.error(Level.INFO, "NO_ENTITY_CONFIG_TO_DELETE", (String[])args);
                throw new IDFFMetaException("noEntityConfig", args);
            }
            this.removeEntityFromCOT(realm, entityId);
            HashSet<String> attr = new HashSet<String>();
            attr.add(IDFF_ENTITY_CONFIG_ATTR);
            this.idffMetaConfigInstance.deleteConfiguration(realm, entityId, attr);
            LogUtil.access(Level.INFO, "DELETE_ENTITY_CONFIG_SUCCEEDED", (String[])args);
            IDFFMetaCache.setEntityConfig(realm, entityId, null);
        }
        catch (ConfigurationException e) {
            debug.error("IDFFMetaManager.deleteEntityConfig:", e);
            LogUtil.error(Level.INFO, "DELETE_ENTITY_CONFIG_FAILED", (String[])args);
            throw new IDFFMetaException(e);
        }
        catch (UnsupportedOperationException uoe) {
            debug.error("Unsupported operation", uoe);
            LogUtil.error(Level.INFO, "UNSUPPORTED_OPERATION", null);
            throw new IDFFMetaException("unsupportedOperation", null);
        }
    }

    public SPDescriptorType getSPDescriptor(String realm, String entityID) throws IDFFMetaException {
        EntityDescriptorElement entityDescriptor = this.getEntityDescriptor(realm, entityID);
        return IDFFMetaUtils.getSPDescriptor(entityDescriptor);
    }

    public IDPDescriptorType getIDPDescriptor(String realm, String entityID) throws IDFFMetaException {
        EntityDescriptorElement entityDescriptor = this.getEntityDescriptor(realm, entityID);
        return IDFFMetaUtils.getIDPDescriptor(entityDescriptor);
    }

    public AffiliationDescriptorType getAffiliationDescriptor(String realm, String entityID) throws IDFFMetaException {
        AffiliationDescriptorType affiliationDescriptor = null;
        EntityDescriptorElement entityDescriptor = this.getEntityDescriptor(realm, entityID);
        if (entityDescriptor != null) {
            affiliationDescriptor = entityDescriptor.getAffiliationDescriptor();
        }
        return affiliationDescriptor;
    }

    public void createEntityConfig(String realm, EntityConfigElement entityConfig) throws IDFFMetaException {
        String classMethod = "IDFFMetaManager.createEntityConfig:";
        String entityID = null;
        if (entityConfig == null) {
            LogUtil.error(Level.INFO, "NULL_ENTITY_CONFIG", null);
            throw new IDFFMetaException("nullEntityConfig", null);
        }
        entityID = entityConfig.getEntityID();
        if (entityID == null) {
            LogUtil.error(Level.INFO, "NULL_ENTITY_ID", null);
            debug.error(classMethod + "entity ID is null");
            throw new IDFFMetaException("nullEntityID", null);
        }
        if (realm == null || realm.length() == 0) {
            realm = ROOT_REALM;
        }
        Object[] args = new String[]{entityID, realm};
        try {
            Map attrs = IDFFMetaUtils.convertJAXBToAttrMap(IDFF_ENTITY_CONFIG_ATTR, entityConfig);
            Map origAttrs = this.idffMetaConfigInstance.getConfiguration(realm, entityID);
            if (origAttrs == null) {
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "Entity Descriptor for" + entityID + " does not exist");
                }
                LogUtil.error(Level.INFO, "ENTITY_CONFIG_NOT_FOUND", (String[])args);
                throw new IDFFMetaException("noEntityDescriptor", args);
            }
            Set origValues = (Set)origAttrs.get(IDFF_ENTITY_CONFIG_ATTR);
            if (!origValues.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "Entity Config exists. " + "Use setEntityConfig to set the configuration");
                }
                LogUtil.error(Level.INFO, "ENTITY_CONFIG_EXISTS", (String[])args);
                throw new IDFFMetaException("entityConfigExists", args);
            }
            if (debug.messageEnabled()) {
                debug.message(classMethod + "Entity Config Attrs :" + attrs);
            }
            this.idffMetaConfigInstance.setConfiguration(realm, entityID, attrs);
            this.addEntityToCOT(realm, entityID);
            LogUtil.access(Level.INFO, "CREATE_ENTITY_CONFIG_SUCCEEDED", (String[])args);
        }
        catch (ConfigurationException ce) {
            debug.error(classMethod + "Cannot create entity config", ce);
            LogUtil.error(Level.INFO, "CREATE_ENTITY_CONFIG_FAILED", (String[])args);
            throw new IDFFMetaException(ce);
        }
        catch (UnsupportedOperationException uoe) {
            debug.error(classMethod + "Unsupported operation");
            LogUtil.error(Level.INFO, "UNSUPPORTED_OPERATION", (String[])args);
            throw new IDFFMetaException(uoe);
        }
        catch (JAXBException jaxbe) {
            debug.error(classMethod, jaxbe);
            LogUtil.error(Level.INFO, "INVALID_ENTITY_CONFIG", (String[])args);
            throw new IDFFMetaException("invalidEntityConfig", args);
        }
    }

    public EntityConfigElement getEntityConfig(String realm, String entityID) throws IDFFMetaException {
        String classMethod = "IDFFMetaManager:getEntityConfig:";
        EntityConfigElement entityConfig = null;
        if (entityID != null) {
            if (realm == null || realm.length() == 0) {
                realm = ROOT_REALM;
            }
            Object[] args = new String[]{entityID, realm};
            entityConfig = IDFFMetaCache.getEntityConfig(realm, entityID);
            if (entityConfig == null) {
                try {
                    Set cfgValues;
                    Map attrs = this.idffMetaConfigInstance.getConfiguration(realm, entityID);
                    if (attrs != null && (cfgValues = (Set)attrs.get(IDFF_ENTITY_CONFIG_ATTR)) != null && !cfgValues.isEmpty()) {
                        String cfgValue = (String)cfgValues.iterator().next();
                        Object object = IDFFMetaUtils.convertStringToJAXB(cfgValue);
                        if (object instanceof EntityConfigElement) {
                            entityConfig = (EntityConfigElement)object;
                            IDFFMetaCache.setEntityConfig(realm, entityID, entityConfig);
                        } else {
                            debug.error(classMethod + "Invalid entityID" + entityID);
                        }
                    }
                }
                catch (ConfigurationException ce) {
                    debug.error(classMethod + "Cannot retrieve entity config", ce);
                    LogUtil.error(Level.INFO, "GET_ENTITY_CONFIG_FAILED", (String[])args);
                    throw new IDFFMetaException("cannotRetreiveEntityConfig", null);
                }
                catch (JAXBException jaxbe) {
                    debug.error(classMethod, jaxbe);
                    LogUtil.error(Level.INFO, "INVALID_ENTITY_CONFIG", (String[])args);
                    throw new IDFFMetaException("invalidEntityConfig", args);
                }
            }
            if (entityConfig != null) {
                LogUtil.access(Level.INFO, "GET_ENTITY_CONFIG_SUCCEEDED", (String[])args);
            }
        } else {
            LogUtil.error(Level.INFO, "NULL_ENTITY_ID", null);
            throw new IDFFMetaException("nullEntityID", null);
        }
        return entityConfig;
    }

    public void setEntityConfig(String realm, EntityConfigElement entityConfig) throws IDFFMetaException {
        String classMethod = "IDFFMetaManager:setEntityConfig";
        if (entityConfig != null) {
            String entityID = entityConfig.getEntityID();
            if (realm == null || realm.length() == 0) {
                realm = ROOT_REALM;
            }
            Map origEntityAttrs = null;
            Object[] args = new String[]{entityID, realm};
            try {
                if (entityID == null) {
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "Entity Identifier is null");
                    }
                    LogUtil.error(Level.INFO, "NULL_ENTITY_ID", null);
                    throw new IDFFMetaException("nullEntityID", null);
                }
                origEntityAttrs = this.idffMetaConfigInstance.getConfiguration(realm, entityID);
                Map newAttrs = IDFFMetaUtils.convertJAXBToAttrMap(IDFF_ENTITY_CONFIG_ATTR, entityConfig);
                origEntityAttrs.put(IDFF_ENTITY_CONFIG_ATTR, newAttrs.get(IDFF_ENTITY_CONFIG_ATTR));
                this.idffMetaConfigInstance.setConfiguration(realm, entityID, origEntityAttrs);
                LogUtil.access(Level.INFO, "SET_ENTITY_CONFIG_SUCCEEDED", (String[])args);
            }
            catch (ConfigurationException ce) {
                debug.error("Error setting Entity Descriptor ", ce);
                LogUtil.error(Level.INFO, "SET_ENTITY_CONFIG_FAILED", (String[])args);
                throw new IDFFMetaException(ce);
            }
            catch (JAXBException jaxbe) {
                debug.error(classMethod, jaxbe);
                LogUtil.error(Level.INFO, "INVALID_ENTITY_CONFIG", (String[])args);
                throw new IDFFMetaException("invalidEntityConfig", args);
            }
        }
    }

    public SPDescriptorConfigElement getSPDescriptorConfig(String realm, String entityID) throws IDFFMetaException {
        EntityConfigElement entityConfigElement = this.getEntityConfig(realm, entityID);
        return IDFFMetaUtils.getSPDescriptorConfig(entityConfigElement);
    }

    public IDPDescriptorConfigElement getIDPDescriptorConfig(String realm, String entityID) throws IDFFMetaException {
        EntityConfigElement entityConfigElement = this.getEntityConfig(realm, entityID);
        return IDFFMetaUtils.getIDPDescriptorConfig(entityConfigElement);
    }

    public AffiliationDescriptorConfigElement getAffiliationDescriptorConfig(String realm, String entityID) throws IDFFMetaException {
        AffiliationDescriptorConfigElement affiliationDesConfig = null;
        EntityConfigElement entityConfig = this.getEntityConfig(realm, entityID);
        if (entityConfig != null) {
            affiliationDesConfig = (AffiliationDescriptorConfigElement)entityConfig.getAffiliationDescriptorConfig();
        }
        return affiliationDesConfig;
    }

    public Set getAllEntities(String realm) throws IDFFMetaException {
        HashSet entityIDSet = new HashSet();
        try {
            Set entityIDs = this.idffMetaConfigInstance.getAllConfigurationNames(realm);
            if (entityIDs != null && !entityIDs.isEmpty()) {
                entityIDSet.addAll(entityIDs);
            }
            LogUtil.access(Level.INFO, "GET_ENTITY_NAMES_SUCCEEDED", null);
        }
        catch (ConfigurationException e) {
            debug.error("IDFFMetaManager.getAllEntities:", e);
            LogUtil.error(Level.INFO, "GET_ENTITY_NAMES_FAILED", null);
            throw new IDFFMetaException(e);
        }
        return entityIDSet;
    }

    public List getAllHostedEntities(String realm) throws IDFFMetaException {
        ArrayList<String> hostedEntityList = new ArrayList<String>();
        try {
            Set entityIDs = this.idffMetaConfigInstance.getAllConfigurationNames(realm);
            if (entityIDs != null && !entityIDs.isEmpty()) {
                Iterator entityIterator = entityIDs.iterator();
                while (entityIterator.hasNext()) {
                    String entityID = (String)entityIterator.next();
                    EntityConfigElement entityConfig = this.getEntityConfig(realm, entityID);
                    if (entityConfig == null || !entityConfig.isHosted()) continue;
                    hostedEntityList.add(entityID);
                }
            }
            LogUtil.access(Level.INFO, "GET_HOSTED_ENTITIES_SUCCEEDED", null);
        }
        catch (ConfigurationException e) {
            debug.error("IDFFMetaManager.getAllHostedEntities:", e);
            LogUtil.error(Level.INFO, "GET_HOSTED_ENTITIES_FAILED", null);
            throw new IDFFMetaException(e);
        }
        return hostedEntityList;
    }

    public List getAllRemoteEntities(String realm) throws IDFFMetaException {
        ArrayList<String> remoteEntityList = new ArrayList<String>();
        try {
            Set entityIDs = this.idffMetaConfigInstance.getAllConfigurationNames(realm);
            if (entityIDs != null && !entityIDs.isEmpty()) {
                Iterator entityIterator = entityIDs.iterator();
                while (entityIterator.hasNext()) {
                    String entityID = (String)entityIterator.next();
                    EntityConfigElement entityConfig = this.getEntityConfig(realm, entityID);
                    if (entityConfig == null || entityConfig.isHosted()) continue;
                    remoteEntityList.add(entityID);
                }
            }
            LogUtil.access(Level.INFO, "GET_REMOTE_ENTITIES_SUCCEEDED", null);
        }
        catch (ConfigurationException e) {
            debug.error("IDFFMetaManager.getAllRemoteEntities:", e);
            LogUtil.error(Level.INFO, "GET_REMOTE_ENTITIES_FAILED", null);
            throw new IDFFMetaException(e);
        }
        return remoteEntityList;
    }

    public List getAllHostedServiceProviderEntities(String realm) throws IDFFMetaException {
        ArrayList<String> hostedSPEntityList = new ArrayList<String>();
        List hostedEntityIds = this.getAllHostedEntities(realm);
        Iterator entityIterator = hostedEntityIds.iterator();
        while (entityIterator.hasNext()) {
            String entityID = (String)entityIterator.next();
            if (this.getSPDescriptor(realm, entityID) == null) continue;
            hostedSPEntityList.add(entityID);
        }
        LogUtil.access(Level.INFO, "GET_HOSTED_SERVICE_PROVIDERS_SUCCEEDED", null);
        return hostedSPEntityList;
    }

    public List getAllRemoteServiceProviderEntities(String realm) throws IDFFMetaException {
        ArrayList<String> remoteSPEntityList = new ArrayList<String>();
        List remoteEntitiesList = this.getAllRemoteEntities(realm);
        Iterator entityIterator = remoteEntitiesList.iterator();
        while (entityIterator.hasNext()) {
            String entityID = (String)entityIterator.next();
            if (this.getSPDescriptor(realm, entityID) == null) continue;
            remoteSPEntityList.add(entityID);
        }
        LogUtil.access(Level.INFO, "GET_REMOTE_SERVICE_PROVIDERS_SUCCEEDED", null);
        return remoteSPEntityList;
    }

    public List getAllHostedIdentityProviderIDs(String realm) throws IDFFMetaException {
        ArrayList<String> hostedIDPEntityList = new ArrayList<String>();
        List hostedEntityIds = this.getAllHostedEntities(realm);
        Iterator entityIterator = hostedEntityIds.iterator();
        while (entityIterator.hasNext()) {
            String entityID = (String)entityIterator.next();
            if (this.getIDPDescriptor(realm, entityID) == null) continue;
            hostedIDPEntityList.add(entityID);
        }
        LogUtil.access(Level.INFO, "GET_HOSTED_IDENTITY_PROVIDERS_SUCCEEDED", null);
        return hostedIDPEntityList;
    }

    public List getAllRemoteIdentityProviderIDs(String realm) throws IDFFMetaException {
        ArrayList<String> remoteIDPEntityList = new ArrayList<String>();
        List remoteEntitiesList = this.getAllRemoteEntities(realm);
        Iterator entityIterator = remoteEntitiesList.iterator();
        while (entityIterator.hasNext()) {
            String entityID = (String)entityIterator.next();
            if (this.getIDPDescriptor(realm, entityID) == null) continue;
            remoteIDPEntityList.add(entityID);
        }
        LogUtil.access(Level.INFO, "GET_REMOTE_IDENTITY_PROVIDERS_SUCCEEDED", null);
        return remoteIDPEntityList;
    }

    public boolean isTrustedProvider(String realm, String hostedEntityID, String entityID) {
        String classMethod = "IDFFMetaManager:isTrustedProvider";
        boolean isTrusted = false;
        try {
            SPDescriptorConfigElement spConfig = this.getSPDescriptorConfig(realm, entityID);
            if (spConfig != null) {
                isTrusted = this.isSameCircleOfTrust(spConfig, realm, entityID);
            } else {
                IDPDescriptorConfigElement idpConfig = this.getIDPDescriptorConfig(realm, entityID);
                if (idpConfig != null) {
                    isTrusted = this.isSameCircleOfTrust(idpConfig, realm, entityID);
                }
            }
        }
        catch (IDFFMetaException ide) {
            debug.error(classMethod + "Error retrieving trust relationship" + "between " + hostedEntityID + "with " + entityID);
        }
        return isTrusted;
    }

    public Set getAllTrustedProviders(String hostedProviderMetaAlias) {
        String classMethod = "IDFFMetaManager:getAllTrustedProviders:";
        HashSet<String> trustedProviders = new HashSet<String>();
        try {
            String hostedEntityID = this.getEntityIDByMetaAlias(hostedProviderMetaAlias);
            String role = this.getProviderRoleByMetaAlias(hostedProviderMetaAlias);
            String realm = IDFFMetaUtils.getRealmByMetaAlias(hostedProviderMetaAlias);
            List hostedEntityIDs = new ArrayList();
            List remoteEntityIDs = new ArrayList();
            if (role != null && role.equalsIgnoreCase("SP")) {
                hostedEntityIDs = this.getAllHostedServiceProviderEntities(realm);
                remoteEntityIDs = this.getAllRemoteIdentityProviderIDs(realm);
            } else if (role != null && role.equalsIgnoreCase("IDP")) {
                hostedEntityIDs = this.getAllHostedIdentityProviderIDs(realm);
                remoteEntityIDs = this.getAllRemoteServiceProviderEntities(realm);
            }
            Map idffCOTs = cotManager.getIDFFCOTProviderMapping(realm);
            Set cotSet = idffCOTs.keySet();
            if (hostedEntityIDs.size() > 0 && hostedEntityIDs.contains(hostedEntityID)) {
                Iterator iter = cotSet.iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    Set tProviders = (Set)idffCOTs.get(name);
                    if (!tProviders.contains(hostedEntityID)) continue;
                    Iterator i = tProviders.iterator();
                    while (i.hasNext()) {
                        String trustedProvider = (String)i.next();
                        if (remoteEntityIDs.size() <= 0 || !remoteEntityIDs.contains(trustedProvider)) continue;
                        trustedProviders.add(trustedProvider);
                    }
                }
            }
        }
        catch (COTException cote) {
            debug.error(classMethod + "Error getting trustedProvider list", cote);
        }
        catch (IDFFMetaException ide) {
            debug.error(classMethod + "Error getting trustedProvider list", ide);
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + " remote trusted providers :" + trustedProviders);
        }
        return trustedProviders;
    }

    public boolean isAffiliateMember(String realm, String providerID, String affiliationID) throws IDFFMetaException {
        Set entityIDSet;
        boolean isAffiliateMember = false;
        if (realm == null || realm.length() == 0) {
            realm = ROOT_REALM;
        }
        if (providerID != null && affiliationID != null && (entityIDSet = this.getAllEntities(realm)) != null && !entityIDSet.isEmpty()) {
            Iterator entityIterator = entityIDSet.iterator();
            while (entityIterator.hasNext()) {
                List affMemberList;
                String affID;
                String entityID = (String)entityIterator.next();
                AffiliationDescriptorType affDescriptor = this.getAffiliationDescriptor(realm, entityID);
                if (affDescriptor == null || (affID = affDescriptor.getAffiliationID()) == null || !affID.equals(affiliationID) || (affMemberList = affDescriptor.getAffiliateMember()) == null || affMemberList.isEmpty() || !affMemberList.contains(providerID)) continue;
                isAffiliateMember = true;
                break;
            }
        }
        String[] args = new String[]{providerID, affiliationID, realm};
        LogUtil.access(Level.INFO, "IS_AFFILIATE_MEMBER_SUCCEEDED", args);
        return isAffiliateMember;
    }

    public Set getAffiliateEntity(String realm, String providerID) {
        HashSet<AffiliationDescriptorType> affDescSet;
        block5: {
            String classMethod = "IDFFMetaManager:getAffiliateEntity:";
            affDescSet = new HashSet<AffiliationDescriptorType>();
            if (realm == null || realm.length() == 0) {
                realm = ROOT_REALM;
            }
            try {
                Set entityIDs = this.getAllEntities(realm);
                if (entityIDs != null && !entityIDs.isEmpty()) {
                    Iterator eIter = entityIDs.iterator();
                    while (eIter.hasNext()) {
                        String affId;
                        String entityID = (String)eIter.next();
                        AffiliationDescriptorType affDesc = this.getAffiliationDescriptor(realm, entityID);
                        if (affDesc == null || !this.isAffiliateMember(realm, providerID, affId = affDesc.getAffiliationID())) continue;
                        affDescSet.add(affDesc);
                    }
                }
            }
            catch (IDFFMetaException ide) {
                if (!debug.messageEnabled()) break block5;
                debug.error(classMethod + "Error getting affiliate entities", ide);
            }
        }
        return affDescSet;
    }

    public String getEntityIDByMetaAlias(String metaAlias) throws IDFFMetaException {
        try {
            if (metaAlias == null || metaAlias.length() == 0) {
                return null;
            }
            String entityId = IDFFMetaCache.getEntityByMetaAlias(metaAlias);
            if (entityId != null) {
                if (debug.messageEnabled()) {
                    debug.message("IDFFMetaManager.getEntityByMetaAlias : found entity in cache, metaAlias=" + metaAlias + ", ID=" + entityId);
                }
                return entityId;
            }
            String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
            Set entityIds = this.idffMetaConfigInstance.getAllConfigurationNames(realm);
            if (entityIds == null || entityIds.isEmpty()) {
                return null;
            }
            Iterator iter = entityIds.iterator();
            while (iter.hasNext()) {
                String tmpMetaAlias;
                IDPDescriptorConfigElement idpconfig;
                String tmpMetaAlias2;
                SPDescriptorConfigElement spconfig;
                String tmpId = (String)iter.next();
                if (debug.messageEnabled()) {
                    debug.message("IDFFMetaManager.getEntityByMetaAlias : process entity cache for metaAlias=" + metaAlias + ", ID=" + tmpId);
                }
                if ((spconfig = this.getSPDescriptorConfig(realm, tmpId)) != null && (tmpMetaAlias2 = spconfig.getMetaAlias()) != null && tmpMetaAlias2.length() > 0) {
                    if (metaAlias.equals(tmpMetaAlias2)) {
                        entityId = tmpId;
                    }
                    IDFFMetaCache.setMetaAliasEntityMapping(tmpMetaAlias2, tmpId);
                    IDFFMetaCache.setMetaAliasRoleMapping(tmpMetaAlias2, "SP");
                    if (debug.messageEnabled()) {
                        debug.message("IDFFMetaManager.getEntityByMetaAlias : save to cache, metaAlias=" + tmpMetaAlias2 + ", ID=" + tmpId + ", role=" + "SP");
                    }
                }
                if ((idpconfig = this.getIDPDescriptorConfig(realm, tmpId)) == null || (tmpMetaAlias = idpconfig.getMetaAlias()) == null || tmpMetaAlias.length() <= 0) continue;
                if (metaAlias.equals(tmpMetaAlias)) {
                    entityId = tmpId;
                }
                IDFFMetaCache.setMetaAliasEntityMapping(tmpMetaAlias, tmpId);
                IDFFMetaCache.setMetaAliasRoleMapping(tmpMetaAlias, "IDP");
                if (!debug.messageEnabled()) continue;
                debug.message("IDFFMetaManager.getEntityByMetaAlias : save to cache, metaAlias=" + tmpMetaAlias + ", ID=" + tmpId + ", role=" + "IDP");
            }
            return entityId;
        }
        catch (ConfigurationException e) {
            debug.error("IDFFMetaManager.getEntityByMetaAlias:", e);
            throw new IDFFMetaException(e);
        }
    }

    public String getProviderRoleByMetaAlias(String metaAlias) throws IDFFMetaException {
        String entityID = this.getEntityIDByMetaAlias(metaAlias);
        if (entityID == null) {
            return null;
        }
        return IDFFMetaCache.getRoleByMetaAlias(metaAlias);
    }

    public String getEntityIDBySuccinctID(String realm, String succinctId) throws IDFFMetaException {
        try {
            Set entityIds;
            if (succinctId == null || succinctId.length() == 0) {
                return null;
            }
            String entityId = IDFFMetaCache.getEntityBySuccinctID(succinctId);
            if (entityId != null) {
                if (debug.messageEnabled()) {
                    debug.message("IDFFMetaManager.getEntityIDBySuccinctID : found entity in cache, succinctId=" + succinctId + ", ID=" + entityId);
                }
                return entityId;
            }
            if (realm == null || realm.length() == 0) {
                realm = ROOT_REALM;
            }
            if ((entityIds = this.idffMetaConfigInstance.getAllConfigurationNames(realm)) == null || entityIds.isEmpty()) {
                return null;
            }
            Iterator iter = entityIds.iterator();
            while (iter.hasNext()) {
                IDPDescriptorConfigElement idpconfig;
                String tmpId = (String)iter.next();
                if (debug.messageEnabled()) {
                    debug.message("IDFFMetaManager.getEntityIDBySuccinctID : process entity cache for succinctID=" + succinctId + ", ID=" + tmpId);
                }
                if ((idpconfig = this.getIDPDescriptorConfig(realm, tmpId)) == null) continue;
                String tmpSuccinctId = FSUtils.generateSourceID(tmpId);
                if (tmpSuccinctId != null && succinctId.equals(tmpSuccinctId)) {
                    entityId = tmpId;
                }
                IDFFMetaCache.setEntitySuccinctIDMapping(tmpSuccinctId, tmpId);
                if (!debug.messageEnabled()) continue;
                debug.message("IDFFMetaManager.getEntityBySuccinctID: update cache, succinctId=" + tmpSuccinctId + ", entity ID=" + tmpId);
            }
            return entityId;
        }
        catch (ConfigurationException e) {
            debug.error("IDFFMetaManager.getEntityIDBySuccinctID:", e);
            throw new IDFFMetaException(e);
        }
    }

    private boolean isSameCircleOfTrust(BaseConfigType config, String realm, String entityID) {
        Map attr;
        List cotList;
        boolean isTrusted = false;
        if (config != null && (cotList = (List)(attr = IDFFMetaUtils.getAttributes(config)).get("cotlist")) != null && !cotList.isEmpty()) {
            Iterator iter = cotList.iterator();
            while (iter.hasNext()) {
                String cotName = (String)iter.next();
                if (!cotManager.isInCircleOfTrust(realm, cotName, "idff", entityID)) continue;
                isTrusted = true;
            }
        }
        return isTrusted;
    }

    private void addToCircleOfTrust(BaseConfigType config, String realm, String entityId) {
        String classMethod = "COTManager:addToCircleOfTrust :";
        try {
            Map attr;
            List cotAttr;
            ArrayList cotList;
            if (config != null && (cotList = new ArrayList(cotAttr = (List)(attr = IDFFMetaUtils.getAttributes(config)).get("cotlist"))) != null && !cotList.isEmpty()) {
                Iterator iter = cotList.iterator();
                while (iter.hasNext()) {
                    String cotName = (String)iter.next();
                    try {
                        cotManager.addCircleOfTrustMember(realm, cotName, "idff", entityId);
                    }
                    catch (COTException ce) {
                        debug.error(classMethod + cotName + " cotName");
                    }
                }
            }
        }
        catch (Exception e) {
            debug.error(classMethod + "Error while adding entity" + entityId + "to COT.", e);
        }
    }

    private void removeFromCircleOfTrust(BaseConfigType config, String realm, String entityId) {
        String classMethod = "IDFFMetaManager:removeFromCircleOfTrust:";
        try {
            Map attr;
            List cotAttr;
            ArrayList cotList;
            if (config != null && (cotList = new ArrayList(cotAttr = (List)(attr = IDFFMetaUtils.getAttributes(config)).get("cotlist"))) != null && !cotList.isEmpty()) {
                Iterator iter = cotList.iterator();
                while (iter.hasNext()) {
                    String cotName = (String)iter.next();
                    if (cotName == null || cotName.length() <= 0) continue;
                    try {
                        cotManager.removeCircleOfTrustMember(realm, cotName, "idff", entityId);
                    }
                    catch (COTException ce) {
                        if (!debug.messageEnabled()) continue;
                        debug.message(classMethod + "Invalid COT: " + cotName);
                    }
                }
            }
        }
        catch (Exception e) {
            debug.error("IDFFMetaManager.removeFromCircleOfTrust:Error while removing entity" + entityId + "from COT.", e);
        }
    }

    private void addEntityToCOT(String realm, String entityID) throws IDFFMetaException {
        SPDescriptorConfigElement spConfig;
        IDPDescriptorConfigElement idpConfig = this.getIDPDescriptorConfig(realm, entityID);
        if (idpConfig != null) {
            this.addToCircleOfTrust(idpConfig, realm, entityID);
        }
        if ((spConfig = this.getSPDescriptorConfig(realm, entityID)) != null) {
            this.addToCircleOfTrust(spConfig, realm, entityID);
        }
    }

    private void removeEntityFromCOT(String realm, String entityID) throws IDFFMetaException {
        SPDescriptorConfigElement spConfig;
        IDPDescriptorConfigElement idpConfig = this.getIDPDescriptorConfig(realm, entityID);
        if (idpConfig != null) {
            this.removeFromCircleOfTrust(idpConfig, realm, entityID);
        }
        if ((spConfig = this.getSPDescriptorConfig(realm, entityID)) != null) {
            this.removeFromCircleOfTrust(spConfig, realm, entityID);
        }
    }

    static {
        try {
            cotManager = new CircleOfTrustManager();
        }
        catch (COTException ce) {
            debug.error("IDFFMetaManager:static:Error initializing COTManager");
        }
    }
}

