/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequestVersionTooHighException;
import com.sun.identity.saml.common.SAMLRequestVersionTooLowException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.AttributeQuery;
import com.sun.identity.saml.protocol.AuthenticationQuery;
import com.sun.identity.saml.protocol.AuthorizationDecisionQuery;
import com.sun.identity.saml.protocol.Query;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSRequest
extends Request {
    protected String id = null;

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    protected FSRequest() {
    }

    public FSRequest(String requestId, Query query) throws SAMLException {
        super(requestId, query);
    }

    public FSRequest(String requestId, List contents) throws SAMLException {
        super(requestId, contents);
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public static Request parseXML(String xml) throws SAMLException {
        Document doc = XMLUtils.toDOMDocument(xml, FSUtils.debug);
        Element root = doc.getDocumentElement();
        return new FSRequest(root);
    }

    public FSRequest(Element root) throws SAMLException {
        String tag = null;
        if (root == null) {
            FSUtils.debug.message("Request(Element): null input.");
            throw new SAMLRequesterException("libIDFF", "nullInput", null);
        }
        tag = root.getLocalName();
        if (tag == null || !tag.equals("Request")) {
            FSUtils.debug.message("Request(Element): wrong input");
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        this.id = root.getAttribute("id");
        List signs = XMLUtils.getElementsByTagNameNS1(root, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            this.valid = this.id == null ? manager.verifyXMLSignature(root, "RequestID", null) : manager.verifyXMLSignature(root);
            if (!this.valid && FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): couldn't verify Request's signature.");
            }
            this.xmlString = XMLUtils.print(root);
            this.signed = true;
        } else if (signsSize != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException("libIDFF", "moreElement", null);
        }
        this.requestID = root.getAttribute("RequestID");
        if (this.requestID == null || this.requestID.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): Request doesn't have a RequestID.");
            }
            Object[] args = new String[]{"RequestID"};
            throw new SAMLRequesterException("libIDFF", "missingAttribute", args);
        }
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        String instantString = root.getAttribute("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            FSUtils.debug.message("Request(Element): missing IssueInstant");
            Object[] args = new String[]{"IssueInstant"};
            throw new SAMLRequesterException("libIDFF", "missingAttribute", args);
        }
        try {
            this.issueInstant = DateUtils.stringToDate(instantString);
        }
        catch (Exception e) {
            FSUtils.debug.message("Request(Element): could not parse IssueInstant", e);
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        NodeList contentnl = root.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            String nodeName = child.getLocalName();
            if (nodeName == null) continue;
            if (nodeName.equals("RespondWith")) {
                String respondWith = XMLUtils.getElementValue((Element)child);
                if (respondWith.length() == 0) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request(Element): wrong RespondWith value.");
                    }
                    throw new SAMLRequesterException("libIDFF", "wrongInput", null);
                }
                if (this.respondWiths == Collections.EMPTY_LIST) {
                    this.respondWiths = new ArrayList();
                }
                this.respondWiths.add(respondWith);
                continue;
            }
            if (nodeName.equals("Signature")) {
                this.signature = (Element)child;
                continue;
            }
            if (nodeName.equals("AuthenticationQuery")) {
                if (this.contentType != -1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request(Element): shouldcontain only one AuthenticationQuery.");
                    }
                    throw new SAMLRequesterException("libIDFF", "wrongInput", null);
                }
                this.contentType = 0;
                this.query = new AuthenticationQuery((Element)child);
                continue;
            }
            if (nodeName.equals("AuthorizationDecisionQuery")) {
                if (this.contentType != -1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request(Element): shouldcontain only one AuthorizationDecisionQuery.");
                    }
                    throw new SAMLRequesterException("libIDFF", "wrongInput", null);
                }
                this.contentType = 1;
                this.query = new AuthorizationDecisionQuery((Element)child);
                continue;
            }
            if (nodeName.equals("AttributeQuery")) {
                if (this.contentType != -1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request(Element): shouldcontain only one AttributeQuery.");
                    }
                    throw new SAMLRequesterException("libIDFF", "wrongInput", null);
                }
                this.contentType = 4;
                this.query = new AttributeQuery((Element)child);
                continue;
            }
            if (nodeName.equals("AssertionIDReference")) {
                if (this.contentType != -1 && this.contentType != 2) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request(Element): contained mixed contents.");
                    }
                    throw new SAMLRequesterException("libIDFF", "wrongInput", null);
                }
                this.contentType = 2;
                if (this.assertionIDRefs == Collections.EMPTY_LIST) {
                    this.assertionIDRefs = new ArrayList();
                }
                this.assertionIDRefs.add(new AssertionIDReference(XMLUtils.getElementValue((Element)child)));
                continue;
            }
            if (nodeName.equals("AssertionArtifact")) {
                if (this.contentType != -1 && this.contentType != 3) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request(Element): contained mixed contents.");
                    }
                    throw new SAMLRequesterException("libIDFF", "wrongInput", null);
                }
                this.contentType = 3;
                if (this.artifacts == Collections.EMPTY_LIST) {
                    this.artifacts = new ArrayList();
                }
                this.artifacts.add(new AssertionArtifact(XMLUtils.getElementValue((Element)child)));
                continue;
            }
            if (nodeName.equals("Query") || nodeName.equals("SubjectQuery")) {
                this.parseQuery(child);
                continue;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): invalid node" + nodeName);
            }
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        if (this.contentType == -1) {
            FSUtils.debug.message("Request: empty content.");
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
    }

    private String checkAndGetRespondWith(String respondWith) throws SAMLException {
        if (respondWith == null || respondWith.length() == 0) {
            FSUtils.debug.message("Request: empty RespondWith Value.");
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        if (respondWith.indexOf(":") == -1) {
            return "saml:" + respondWith;
        }
        StringTokenizer st = new StringTokenizer(respondWith, ":");
        if (st.countTokens() != 2) {
            FSUtils.debug.message("Request: wrong RespondWith value.");
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        st.nextToken();
        String temp = st.nextToken().trim();
        if (temp.length() == 0) {
            FSUtils.debug.message("Request: wrong RespondWith value.");
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        return "saml:" + temp;
    }

    private void parseMajorVersion(String majorVer) throws SAMLException {
        try {
            this.majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): invalid MajorVersion", e);
            }
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Request(Element):MajorVersion of the Request is too high.");
                }
                throw new SAMLRequestVersionTooHighException("libIDFF", "requestVersionTooHigh", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element):MajorVersion of the Request is too low.");
            }
            throw new SAMLRequestVersionTooLowException("libIDFF", "requestVersionTooLow", null);
        }
    }

    private void parseMinorVersion(String minorVer) throws SAMLException {
        try {
            this.minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): invalid MinorVersion", e);
            }
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        if (this.minorVersion > 1) {
            FSUtils.debug.error("Request(Element): MinorVersion of the Request is too high.");
            throw new SAMLRequestVersionTooHighException("libIDFF", "requestVersionTooHigh", null);
        }
        if (this.minorVersion < 0) {
            FSUtils.debug.error("Request(Element): MinorVersion of the Request is too low.");
            throw new SAMLRequestVersionTooLowException("libIDFF", "requestVersionTooLow", null);
        }
    }

    private void parseQuery(Node child) throws SAMLException {
        NamedNodeMap nm = child.getAttributes();
        int len = nm.getLength();
        boolean found = false;
        for (int j = 0; j < len; ++j) {
            Attr attr = (Attr)nm.item(j);
            String attrName = attr.getLocalName();
            if (attrName == null || !attrName.equals("type")) continue;
            String attrValue = attr.getNodeValue();
            if (attrValue.equals("AuthenticationQueryType")) {
                if (this.contentType != -1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request(Element): should contain only one AuthenticationQuery.");
                    }
                    throw new SAMLRequesterException("libIDFF", "wrongInput", null);
                }
                this.contentType = 0;
                this.query = new AuthenticationQuery((Element)child);
            } else if (attrValue.equals("AuthorizationDecisionQueryType")) {
                if (this.contentType != -1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request(Element): should contain one AuthorizationDecisionQuery.");
                    }
                    throw new SAMLRequesterException("libIDFF", "wrongInput", null);
                }
                this.contentType = 1;
                this.query = new AuthorizationDecisionQuery((Element)child);
            } else if (attrValue.equals("AttributeQueryType")) {
                if (this.contentType != -1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Request(Element): should contain one AttributeQuery.");
                    }
                    throw new SAMLRequesterException("libIDFF", "wrongInput", null);
                }
                this.contentType = 4;
                this.query = new AttributeQuery((Element)child);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Request(Element): This type of " + attrName + " is not supported.");
                }
                throw new SAMLResponderException("libIDFF", "queryNotSupported", null);
            }
            found = true;
            break;
        }
        if (!found) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): missing xsi:type definition in " + child.getLocalName());
            }
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
    }

    public String toXMLString() {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) {
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String prefix = "";
        String libprefix = "";
        String uri = "";
        String liburi = "";
        String uriXSI = "";
        if (includeNS) {
            prefix = "samlp:";
            libprefix = "lib:";
        }
        if (declareNS) {
            uri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
            liburi = this.minorVersion == 1 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            uriXSI = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        }
        String instantString = DateUtils.toUTCDateFormat(this.issueInstant);
        xml.append("<").append(prefix).append("Request").append(uri).append(" ").append(liburi).append(" ").append(uriXSI);
        if (this.minorVersion == 0 && this.id != null && this.id.length() != 0) {
            xml.append(" id=\"").append(this.id).append("\"");
        }
        xml.append(" RequestID=\"").append(this.requestID).append("\"").append(" MajorVersion=\"").append(this.majorVersion).append("\"").append(" MinorVersion=\"").append(this.minorVersion).append("\"").append(" IssueInstant=\"").append(instantString).append("\"");
        if (this.minorVersion == 0) {
            xml.append(" xsi:type").append("=\"").append(libprefix).append("SignedSAMLRequestType").append("\"");
        }
        xml.append(">");
        if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
            Iterator i = this.respondWiths.iterator();
            String respondWith = null;
            while (i.hasNext()) {
                respondWith = (String)i.next();
                xml.append("<").append(prefix).append("RespondWith>");
                if (respondWith.startsWith("saml:")) {
                    xml.append(respondWith);
                } else {
                    try {
                        xml.append(this.checkAndGetRespondWith(respondWith));
                    }
                    catch (SAMLException e) {
                        FSUtils.debug.error("Request.toString: ", e);
                        xml.append(respondWith);
                    }
                }
                xml.append("</").append(prefix).append("RespondWith>");
            }
        }
        if (this.signed) {
            if (this.signatureString != null) {
                xml.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print(this.signature);
                xml.append(this.signatureString);
            }
        }
        switch (this.contentType) {
            case 0: {
                xml.append(((AuthenticationQuery)this.query).toString(includeNS, false));
                break;
            }
            case 1: {
                xml.append(((AuthorizationDecisionQuery)this.query).toString(includeNS, false));
                break;
            }
            case 4: {
                xml.append(((AttributeQuery)this.query).toString(includeNS, false));
                break;
            }
            case 2: {
                Iterator j = this.assertionIDRefs.iterator();
                while (j.hasNext()) {
                    xml.append(((AssertionIDReference)j.next()).toString(true, true));
                }
                break;
            }
            case 3: {
                Iterator j = this.artifacts.iterator();
                while (j.hasNext()) {
                    xml.append(((AssertionArtifact)j.next()).toString(includeNS, false));
                }
                break;
            }
        }
        xml.append("</").append(prefix).append("Request>");
        return xml.toString();
    }
}

