/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.message.common.OldProvidedNameIdentifier;
import com.sun.identity.federation.message.common.SPProvidedNameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSNameRegistrationRequest
extends AbstractRequest {
    private String providerId;
    private SPProvidedNameIdentifier spProvidedNameIdentifier;
    private IDPProvidedNameIdentifier idpProvidedNameIdentifier;
    private OldProvidedNameIdentifier oldProvidedNameIdentifier;
    private String relayState = "";
    protected String xmlString;
    protected String signatureString;
    protected String id;
    protected int minorVersion = 0;

    public FSNameRegistrationRequest() {
        this.setIssueInstant(new Date());
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public FSNameRegistrationRequest(String requestId, List respondWiths, String providerId, SPProvidedNameIdentifier spProvidedNameIdentifier, IDPProvidedNameIdentifier idpProvidedNameIdentifier, OldProvidedNameIdentifier oldProvidedNameIdentifier, String relayState) throws FSMsgException {
        int length = 0;
        this.setIssueInstant(new Date());
        if (respondWiths != null && respondWiths != Collections.EMPTY_LIST) {
            length = respondWiths.size();
            for (int i = 0; i < length; ++i) {
                Object temp = respondWiths.get(i);
                if (temp instanceof String) continue;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("NameRegistrationRequest: wrong input for RespondWith");
                }
                throw new FSMsgException("wrongInput", null);
            }
            this.respondWiths = respondWiths;
        }
        if (requestId != null && requestId.length() != 0) {
            this.requestID = requestId;
        } else {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSNameRegistrationRequest: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        this.providerId = providerId;
        this.spProvidedNameIdentifier = spProvidedNameIdentifier;
        this.idpProvidedNameIdentifier = idpProvidedNameIdentifier;
        this.oldProvidedNameIdentifier = oldProvidedNameIdentifier;
        this.relayState = relayState;
    }

    public FSNameRegistrationRequest(Element root) throws FSMsgException {
        String tag = null;
        if (root == null) {
            FSUtils.debug.message("FSNameRegistrationRequest(Element): null input.");
            throw new FSMsgException("nullInput", null);
        }
        tag = root.getLocalName();
        if (tag == null || !tag.equals("RegisterNameIdentifierRequest")) {
            FSUtils.debug.message("FSNameRegistrationRequest(Element): wrong input");
            throw new FSMsgException("wrongInput", null);
        }
        String instantString = root.getAttribute("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            FSUtils.debug.error("FSNameRegistrationRequest(Element):missing IssueInstant");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            this.issueInstant = DateUtils.stringToDate(instantString);
        }
        catch (ParseException e) {
            FSUtils.debug.error("FSNameRegistrationRequest(Element): could not parse IssueInstant", e);
            throw new FSMsgException("wrongInput", null);
        }
        int length = 0;
        this.id = root.getAttribute("id");
        this.requestID = root.getAttribute("RequestID");
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        NodeList contentnl = root.getChildNodes();
        length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            String nodeName = child.getLocalName();
            if (nodeName == null) continue;
            if (nodeName.equals("RespondWith")) {
                if (this.respondWiths == Collections.EMPTY_LIST) {
                    this.respondWiths = new ArrayList();
                }
                this.respondWiths.add(XMLUtils.getElementValue((Element)child));
                continue;
            }
            if (nodeName.equals("Signature")) continue;
            if (nodeName.equals("ProviderID")) {
                if (this.providerId != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationRequest(Element): should contain only one ProviderID.");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                this.providerId = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (nodeName.equals("SPProvidedNameIdentifier")) {
                this.spProvidedNameIdentifier = new SPProvidedNameIdentifier((Element)child);
                continue;
            }
            if (nodeName.equals("IDPProvidedNameIdentifier")) {
                this.idpProvidedNameIdentifier = new IDPProvidedNameIdentifier((Element)child);
                continue;
            }
            if (nodeName.equals("OldProvidedNameIdentifier")) {
                this.oldProvidedNameIdentifier = new OldProvidedNameIdentifier((Element)child);
                continue;
            }
            if (nodeName.equals("RelayState")) {
                this.relayState = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationRequest(Element): invalid node" + nodeName);
            }
            throw new FSMsgException("wrongInput", null);
        }
        List signs = XMLUtils.getElementsByTagNameNS1(root, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            Element elem = (Element)signs.get(0);
            this.setSignature(elem);
            this.xmlString = XMLUtils.print(root);
            this.signed = true;
        } else if (signsSize != 0) {
            FSUtils.debug.error("FSNameRegistrationRequest(Element): included more than one Signature element.");
            throw new FSMsgException("moreElement", null);
        }
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public static FSNameRegistrationRequest parseXML(String xml) throws FSMsgException {
        Document doc = XMLUtils.toDOMDocument(xml, FSUtils.debug);
        if (doc == null) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseXML:Error while parsing input xml string");
            throw new FSMsgException("parseError", null);
        }
        Element root = doc.getDocumentElement();
        return new FSNameRegistrationRequest(root);
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSNameRegistrationRequest.toXMLString: providerId is null in the request with requestId:" + this.requestID);
            Object[] args = new String[]{this.requestID};
            throw new FSMsgException("nullProviderIdWRequestId", args);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSNameRegistrationRequest.toXMLString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer xml = new StringBuffer(1000);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String prefix = "";
        String uri = "";
        String uriSAML = "";
        if (includeNS) {
            prefix = "lib:";
        }
        if (declareNS) {
            uri = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            uriSAML = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        String instantString = DateUtils.toUTCDateFormat(this.issueInstant);
        if (this.requestID != null) {
            xml.append("<").append(prefix).append("RegisterNameIdentifierRequest").append(uri).append(uriSAML);
            if (this.minorVersion == 0 && this.id != null && this.id.length() != 0) {
                xml.append(" id=\"").append(this.id).append("\" ");
            }
            xml.append(" RequestID=\"").append(this.requestID).append("\" ").append(" MajorVersion=\"").append(this.majorVersion).append("\" ").append(" MinorVersion=\"").append(this.minorVersion).append("\" ").append(" IssueInstant=\"").append(instantString).append("\"").append(">");
            if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
                Iterator i = this.respondWiths.iterator();
                while (i.hasNext()) {
                    xml.append("<").append(prefix).append("RespondWith>").append((String)i.next()).append("</").append(prefix).append("RespondWith>");
                }
            }
            if (this.signed) {
                if (this.signatureString != null) {
                    xml.append(this.signatureString);
                } else if (this.signature != null) {
                    this.signatureString = XMLUtils.print(this.signature);
                    xml.append(this.signatureString);
                }
            }
            xml.append("<").append(prefix).append("ProviderID").append(">").append(this.providerId).append("</").append(prefix).append("ProviderID").append(">");
            if (this.idpProvidedNameIdentifier != null && this.idpProvidedNameIdentifier.getName().length() != 0) {
                xml.append(this.idpProvidedNameIdentifier.toXMLString());
            }
            if (this.spProvidedNameIdentifier != null && this.spProvidedNameIdentifier.getName().length() != 0) {
                xml.append(this.spProvidedNameIdentifier.toXMLString());
            }
            if (this.oldProvidedNameIdentifier != null && this.oldProvidedNameIdentifier.getName().length() != 0) {
                xml.append(this.oldProvidedNameIdentifier.toXMLString());
            }
            if (this.relayState != null) {
                xml.append("<").append(prefix).append("RelayState").append(">").append(this.relayState).append("</").append(prefix).append("RelayState").append(">");
            }
        } else {
            FSUtils.debug.error("FSNameRegistrationRequest.toString: requestID is null ");
            throw new FSMsgException("nullRequestID", null);
        }
        xml.append("</").append(prefix).append("RegisterNameIdentifierRequest>");
        return xml.toString();
    }

    public IDPProvidedNameIdentifier getIDPProvidedNameIdentifier() {
        return this.idpProvidedNameIdentifier;
    }

    public OldProvidedNameIdentifier getOldProvidedNameIdentifier() {
        return this.oldProvidedNameIdentifier;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setIDPProvidedNameIdentifier(IDPProvidedNameIdentifier nameIdentifier) {
        this.idpProvidedNameIdentifier = nameIdentifier;
    }

    public void setOldProvidedNameIdentifier(OldProvidedNameIdentifier nameIdentifier) {
        this.oldProvidedNameIdentifier = nameIdentifier;
    }

    public void setSPProvidedNameIdentifier(SPProvidedNameIdentifier nameIdentifier) {
        this.spProvidedNameIdentifier = nameIdentifier;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public SPProvidedNameIdentifier getSPProvidedNameIdentifier() {
        return this.spProvidedNameIdentifier;
    }

    public String toBASE64EncodedString() throws FSMsgException {
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSNameRegistrationRequest.toBASE64EncodedString: providerId is null in the request with requestId:" + this.requestID);
            Object[] args = new String[]{this.requestID};
            throw new FSMsgException("nullProviderIdWRequestId", args);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSNameRegistrationRequest.toBASE64EncodedString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        return Base64.encode(this.toXMLString().getBytes());
    }

    private void parseMajorVersion(String majorVer) throws FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationRequest(Element): invalid MajorVersion", e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationRequest(Element): MajorVersion of the RegisterNameIdentifierRequestis too high.");
                }
                throw new FSMsgException("requestVersionTooHigh", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationRequest(Element): MajorVersion of the RegisterNameIdentifierRequestis too low.");
            }
            throw new FSMsgException("requestVersionTooLow", null);
        }
    }

    private void parseMinorVersion(String minorVer) throws FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegis(Element): invalid MinorVersion", e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion > 2) {
            FSUtils.debug.error("FSNameRegisNot(Element):MinorVersion of the Response is too high.");
            throw new FSMsgException("responseVersionTooHigh", null);
        }
        if (this.minorVersion < 0) {
            FSUtils.debug.error("FSNameRegis(Element):MinorVersion of the Response is too low.");
            throw new FSMsgException("responseVersionTooLow", null);
        }
    }

    public void signXML() {
    }

    public void signXML(String certAlias) throws SAMLException {
        FSUtils.debug.message("FSNameRegistrationRequest.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationRequest.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException("libIDFF", "alreadySigned", null);
        }
        if (certAlias == null || certAlias.length() == 0) {
            throw new SAMLResponderException("libIDFF", "cannotFindCertAlias", null);
        }
        try {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, null, "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, null, "RequestID", this.getRequestID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument(this.signatureString, FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception e) {
            throw new SAMLResponderException("libIDFF", "signFailed", null);
        }
    }

    public boolean setSignature(Element elem) {
        this.signatureString = XMLUtils.print(elem);
        return super.setSignature(elem);
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSNameRegistrationRequest.toURLEncodedQueryString: providerId is null in the request with requestId: " + this.requestID);
            throw new FSMsgException("nullProviderID", null);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSNameRegistrationRequest.toURLEncodedQueryString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer urlEncodedAuthnReq = new StringBuffer(300);
        urlEncodedAuthnReq.append("RequestID=").append(URLEncDec.encode(this.requestID)).append('&');
        urlEncodedAuthnReq.append("MajorVersion=").append(this.majorVersion).append('&');
        urlEncodedAuthnReq.append("MinorVersion=").append(this.minorVersion).append('&');
        urlEncodedAuthnReq.append("RelayState=").append(URLEncDec.encode(this.relayState)).append('&');
        if (this.issueInstant == null) {
            FSUtils.debug.error("FSNameRegistrationRequest.toURLEncodedQueryString: issueInstant missing");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        urlEncodedAuthnReq.append("IssueInstant=").append(URLEncDec.encode(DateUtils.toUTCDateFormat(this.issueInstant))).append('&');
        if (this.providerId != null && this.providerId.length() > 0) {
            urlEncodedAuthnReq.append("ProviderID=").append(URLEncDec.encode(this.providerId)).append('&');
        }
        if (this.spProvidedNameIdentifier != null) {
            if (this.spProvidedNameIdentifier.getName() != null && this.spProvidedNameIdentifier.getName().length() != 0) {
                urlEncodedAuthnReq.append("SPProvidedNameIdentifier=").append(URLEncDec.encode(this.spProvidedNameIdentifier.getName())).append('&');
            }
            if (this.spProvidedNameIdentifier.getNameQualifier() != null && this.spProvidedNameIdentifier.getNameQualifier().length() != 0) {
                urlEncodedAuthnReq.append("SPNameQualifier=").append(URLEncDec.encode(this.spProvidedNameIdentifier.getNameQualifier())).append('&');
            }
            if (this.spProvidedNameIdentifier.getFormat() != null && this.spProvidedNameIdentifier.getFormat().length() != 0) {
                urlEncodedAuthnReq.append("SPNameFormat=").append(URLEncDec.encode(this.spProvidedNameIdentifier.getFormat())).append('&');
            }
        }
        if (this.oldProvidedNameIdentifier != null) {
            if (this.oldProvidedNameIdentifier.getName() != null && this.oldProvidedNameIdentifier.getName().length() != 0) {
                urlEncodedAuthnReq.append("OldProvidedNameIdentifier=").append(URLEncDec.encode(this.oldProvidedNameIdentifier.getName())).append('&');
            }
            if (this.oldProvidedNameIdentifier.getNameQualifier() != null && this.oldProvidedNameIdentifier.getNameQualifier().length() != 0) {
                urlEncodedAuthnReq.append("OldNameQualifier=").append(URLEncDec.encode(this.oldProvidedNameIdentifier.getNameQualifier())).append('&');
            }
            if (this.oldProvidedNameIdentifier.getFormat() != null && this.oldProvidedNameIdentifier.getFormat().length() != 0) {
                urlEncodedAuthnReq.append("OldNameFormat=").append(URLEncDec.encode(this.oldProvidedNameIdentifier.getFormat())).append('&');
            }
        }
        if (this.idpProvidedNameIdentifier != null) {
            if (this.idpProvidedNameIdentifier.getName() != null && this.idpProvidedNameIdentifier.getName().length() != 0) {
                urlEncodedAuthnReq.append("IDPProvidedNameIdentifier=").append(URLEncDec.encode(this.idpProvidedNameIdentifier.getName())).append('&');
            }
            if (this.idpProvidedNameIdentifier.getNameQualifier() != null && this.idpProvidedNameIdentifier.getNameQualifier().length() != 0) {
                urlEncodedAuthnReq.append("IDPNameQualifier=").append(URLEncDec.encode(this.idpProvidedNameIdentifier.getNameQualifier())).append('&');
            }
            if (this.idpProvidedNameIdentifier.getFormat() != null && this.idpProvidedNameIdentifier.getFormat().length() != 0) {
                urlEncodedAuthnReq.append("IDPNameFormat=").append(URLEncDec.encode(this.idpProvidedNameIdentifier.getFormat())).append('&');
            }
        }
        return urlEncodedAuthnReq.toString();
    }

    public static FSNameRegistrationRequest parseURLEncodedRequest(HttpServletRequest request) throws FSMsgException, SAMLException {
        FSNameRegistrationRequest retNameRegistrationRequest = new FSNameRegistrationRequest();
        try {
            FSUtils.debug.message("checking minor version");
            retNameRegistrationRequest.majorVersion = Integer.parseInt(request.getParameter("MajorVersion"));
            retNameRegistrationRequest.minorVersion = Integer.parseInt(request.getParameter("MinorVersion"));
        }
        catch (NumberFormatException ex) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseURLEncodedRequest: Invalid versions", ex);
            throw new FSMsgException("invalidNumber", null);
        }
        FSUtils.debug.message("checking RequestID");
        if (request.getParameter("RequestID") == null) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseURLEncodedRequest: RequestID not found");
            Object[] args = new String[]{"RequestID"};
            throw new FSMsgException("missingAttribute", args);
        }
        retNameRegistrationRequest.requestID = request.getParameter("RequestID");
        FSUtils.debug.message("checking instantString");
        String instantString = request.getParameter("IssueInstant");
        FSUtils.debug.message("instantString : " + instantString);
        if (instantString == null || instantString.length() == 0) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseURLEncodedRequest: IssueInstant not found");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            FSUtils.debug.message("calling : DateUtils.stringToDate.issueInstant");
            retNameRegistrationRequest.issueInstant = DateUtils.stringToDate(instantString);
        }
        catch (ParseException e) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseURLEncodedRequest: Can not parse IssueInstant", e);
            throw new FSMsgException("parseError", null);
        }
        if (request.getParameter("ProviderID") == null) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseURLEncodedRequest: Can not find ProviderID");
            throw new FSMsgException("missingElement", null);
        }
        retNameRegistrationRequest.providerId = request.getParameter("ProviderID");
        FSUtils.debug.message("start identifier processing");
        String spNameFormat = "";
        String spNameQualifier = "";
        String spName = "";
        if (request.getParameter("SPNameFormat") != null) {
            spNameFormat = request.getParameter("SPNameFormat");
        }
        if (request.getParameter("SPNameQualifier") != null) {
            spNameQualifier = request.getParameter("SPNameQualifier");
        }
        if (request.getParameter("SPProvidedNameIdentifier") != null) {
            spName = request.getParameter("SPProvidedNameIdentifier");
        }
        if (spName != null && spName.length() >= 1) {
            retNameRegistrationRequest.setSPProvidedNameIdentifier(new SPProvidedNameIdentifier(spName, spNameQualifier, spNameFormat));
        }
        String idpNameFormat = null;
        String idpNameQualifier = null;
        String idpName = null;
        if (request.getParameter("IDPNameFormat") != null) {
            idpNameFormat = request.getParameter("IDPNameFormat");
        }
        if (request.getParameter("IDPNameQualifier") != null) {
            idpNameQualifier = request.getParameter("IDPNameQualifier");
        }
        if (request.getParameter("IDPProvidedNameIdentifier") != null) {
            idpName = request.getParameter("IDPProvidedNameIdentifier");
        }
        if (idpName != null && idpName.length() >= 1) {
            retNameRegistrationRequest.idpProvidedNameIdentifier = new IDPProvidedNameIdentifier(idpName, idpNameQualifier, idpNameFormat);
        }
        String oldNameFormat = null;
        String oldNameQualifier = null;
        String oldName = null;
        if (request.getParameter("OldNameFormat") != null) {
            oldNameFormat = request.getParameter("OldNameFormat");
        }
        if (request.getParameter("OldNameQualifier") != null) {
            oldNameQualifier = request.getParameter("OldNameQualifier");
        }
        if (request.getParameter("OldProvidedNameIdentifier") != null) {
            oldName = request.getParameter("OldProvidedNameIdentifier");
        }
        if (oldName != null && oldName.length() >= 1) {
            retNameRegistrationRequest.oldProvidedNameIdentifier = new OldProvidedNameIdentifier(oldName, oldNameQualifier, oldNameFormat);
        }
        if (request.getParameter("RelayState") != null) {
            retNameRegistrationRequest.relayState = request.getParameter("RelayState");
        }
        return retNameRegistrationRequest;
    }
}

