/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSIDPList;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSAuthnRequestEnvelope {
    private String assertionConsumerServiceURL = null;
    private List otherElements = null;
    private FSAuthnRequest authnRequest = null;
    private FSIDPList idpList = null;
    private String providerID = null;
    private String providerName = null;
    private boolean isPassive = false;
    private int minorVersion = 0;

    public FSAuthnRequestEnvelope() {
    }

    public FSAuthnRequestEnvelope(FSAuthnRequest authnRequest, String providerID, String providerName, String assertionConsumerServiceURL, FSIDPList idpList, boolean isPassive) {
        this.authnRequest = authnRequest;
        this.providerID = providerID;
        this.providerName = providerName;
        this.assertionConsumerServiceURL = assertionConsumerServiceURL;
        this.idpList = idpList;
        this.isPassive = isPassive;
    }

    public FSAuthnRequestEnvelope(Element root) throws FSMsgException {
        if (root == null) {
            SAMLUtils.debug.message("FSAuthnRequestEnvelope.parseXML: null input.");
            throw new FSMsgException("nullInput", null);
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("AuthnRequestEnvelope")) {
            FSUtils.debug.message("FSAuthnRequestEnvelope.parseXML: wrong input.");
            throw new FSMsgException("wrongInput", null);
        }
        String ns = root.getNamespaceURI();
        if (ns == null) {
            FSUtils.debug.error("FSAuthnRequestEnvelope(Element): No namespace");
            throw new FSMsgException("wrongInput", null);
        }
        if (ns.equals("urn:liberty:iff:2003-08")) {
            this.minorVersion = 2;
        }
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("AssertionConsumerServiceURL")) {
                this.assertionConsumerServiceURL = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (childName.equals("IDPList")) {
                this.idpList = new FSIDPList((Element)child);
                continue;
            }
            if (childName.equals("AuthnRequest")) {
                this.authnRequest = new FSAuthnRequest((Element)child);
                continue;
            }
            if (childName.equals("ProviderID")) {
                this.providerID = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (childName.equals("ProviderName")) {
                this.providerName = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (!childName.equals("isPassive")) continue;
            String strIsPassive = XMLUtils.getElementValue((Element)child);
            boolean isPassive = false;
            if (strIsPassive == null || !strIsPassive.equals("true")) continue;
            isPassive = true;
        }
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\"").append(" ").append('?').append(">").append("\n");
        }
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "lib:";
        }
        if (declareNS) {
            uri = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        xml.append("<").append(prefix).append("AuthnRequestEnvelope").append(uri).append(">");
        if (this.authnRequest != null) {
            xml.append(this.authnRequest.toXMLString());
        }
        if (this.providerID != null && this.providerID.length() != 0) {
            xml.append("<").append(prefix).append("ProviderID").append(uri).append(">").append(this.providerID).append("</").append(prefix).append("ProviderID").append(">");
        }
        if (this.providerName != null && this.providerName.length() != 0) {
            xml.append("<").append(prefix).append("ProviderName").append(uri).append(">").append(this.providerName).append("</").append(prefix).append("ProviderName").append("ProviderName").append(">");
        }
        if (this.assertionConsumerServiceURL != null && this.assertionConsumerServiceURL.length() != 0) {
            xml.append("<").append(prefix).append("AssertionConsumerServiceURL").append(uri).append(">").append(this.assertionConsumerServiceURL).append("</").append(prefix).append("AssertionConsumerServiceURL").append(">");
        }
        if (this.idpList != null) {
            xml.append(this.idpList.toXMLString());
        }
        String strIsPassive = "false";
        if (this.isPassive) {
            strIsPassive = "true";
        }
        xml.append("<").append(prefix).append("isPassive").append(">").append(strIsPassive).append("</").append(prefix).append("isPassive").append(">");
        xml.append("</").append(prefix).append("AuthnRequestEnvelope").append(">");
        return xml.toString();
    }

    public static FSAuthnRequestEnvelope parseXML(String xml) throws FSMsgException {
        Document doc = XMLUtils.toDOMDocument(xml, FSUtils.debug);
        if (doc == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequestEnvelope.parseXML:Error while parsing input xml string");
            }
            throw new FSMsgException("parseError", null);
        }
        Element root = doc.getDocumentElement();
        return new FSAuthnRequestEnvelope(root);
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public void setAssertionConsumerServiceURL(String assertionConsumerURL) {
        this.assertionConsumerServiceURL = assertionConsumerURL;
    }

    public FSAuthnRequest getAuthnRequest() {
        return this.authnRequest;
    }

    public void setAuthnRequest(FSAuthnRequest authnRequest) {
        this.authnRequest = authnRequest;
    }

    public FSIDPList getIDPList() {
        return this.idpList;
    }

    public void setIDPList(FSIDPList idpList) {
        this.idpList = idpList;
    }

    public List getOtherElements() {
        return this.otherElements;
    }

    public void setOtherElements(List otherElements) {
        this.otherElements = otherElements;
    }

    public static FSAuthnRequestEnvelope parseBASE64EncodedString(String encodedReq) throws FSMsgException {
        if (encodedReq != null) {
            String decodedAuthnReq = new String(Base64.decode(encodedReq));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequestEnvelope.parseBASE64EncodedString: decoded input string: \n" + decodedAuthnReq);
            }
            return FSAuthnRequestEnvelope.parseXML(decodedAuthnReq);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnRequestEnvelope.parseBASE64EncodedString: null  String passed in as argument.");
        }
        throw new FSMsgException("nullInput", null);
    }

    public String toBASE64EncodedString() throws FSMsgException {
        if (this.assertionConsumerServiceURL == null || this.assertionConsumerServiceURL.length() == 0) {
            FSUtils.debug.error("FSAuthnRequestEnvelope.toBASE64EncodedString:assertionConsumerServiceURL is null in the FSAuthnRequestEnvelope");
            throw new FSMsgException("noAssertionConsumerServiceURLElement", null);
        }
        if (this.authnRequest == null) {
            FSUtils.debug.error("FSAuthnRequestEnvelope.toBASE64EncodedString:authnRequest is null in the FSAuthnRequestEnvelope");
            throw new FSMsgException("noAuthnRequestElement", null);
        }
        return Base64.encode(this.toXMLString().getBytes());
    }
}

