/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.configuration;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.shared.configuration.ISystemProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class FedLibSystemProperties
implements ISystemProperties {
    private static final String SYSTEM_CONFIG_PROPERTY_NAME = "FederationConfig";
    private static final String FEDLET_HOME_TAG = "@FEDLET_HOME@";
    private static final String FEDLET_HOME_DIR = "com.sun.identity.fedlet.home";
    protected static Properties systemConfigProps = null;

    public String get(String key) {
        return systemConfigProps.getProperty(key);
    }

    public void initializeProperties(Properties properties) {
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)systemConfigProps);
        newProps.putAll((Map<?, ?>)properties);
        systemConfigProps = newProps;
    }

    private static void initProperties() {
        systemConfigProps = new Properties();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(SYSTEM_CONFIG_PROPERTY_NAME);
            Enumeration<String> e = bundle.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                systemConfigProps.put(key, bundle.getString(key));
            }
        }
        catch (MissingResourceException mrex) {
            String fedletHomeDir = System.getProperty(FEDLET_HOME_DIR);
            if (fedletHomeDir == null || fedletHomeDir.trim().length() == 0) {
                fedletHomeDir = System.getProperty("user.home") + File.separator + "fedlet";
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(fedletHomeDir + File.separator + SYSTEM_CONFIG_PROPERTY_NAME + ".properties");
                Properties props = new Properties();
                props.load(fis);
                Iterator<Object> it = props.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = (String)props.get(key);
                    int loc = value.indexOf(FEDLET_HOME_TAG);
                    if (loc == 0) {
                        value = fedletHomeDir.trim() + value.substring(FEDLET_HOME_TAG.length());
                    } else if (loc != -1) {
                        value = value.substring(0, loc) + fedletHomeDir.trim() + value.substring(loc + FEDLET_HOME_TAG.length());
                    }
                    systemConfigProps.put(key, value);
                }
            }
            catch (MissingResourceException ex) {
            }
            catch (FileNotFoundException ffe) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Collection getServerList() throws Exception {
        return SystemConfigurationUtil.getServerList();
    }

    public URL getServiceURL(String serviceName, String protocol, String hostname, int port, String uri) throws Exception {
        return SystemConfigurationUtil.getServiceURL(serviceName, protocol, hostname, port, uri);
    }

    public void initializeProperties(String propertyName, String propertyValue) {
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)systemConfigProps);
        newProps.put(propertyName, propertyValue);
        systemConfigProps = newProps;
    }

    static {
        FedLibSystemProperties.initProperties();
    }
}

