/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.L10NMessageImpl;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class RequestUtils {
    private static final String debugName = "amRequestUtils";
    private static final String bundleName = "amCommonUtils";
    private static Debug debug;
    private static int maxContentLength;
    private static String rdProtocol;
    private static String rdHost;

    public static String getRedirectProtocol(String scheme, String host) {
        String protocol = scheme;
        if (rdHost != null && rdProtocol != null) {
            int idx = host.indexOf(58);
            if (idx == -1) {
                idx = host.indexOf(47);
            }
            if (idx != -1) {
                host = host.substring(0, idx);
            }
            if (rdHost.equalsIgnoreCase(host)) {
                protocol = rdProtocol;
            }
        }
        return protocol;
    }

    public static void checkContentLength(HttpServletRequest servletRequest) throws L10NMessageImpl {
        int length = servletRequest.getContentLength();
        if (length > maxContentLength) {
            Object[] args = new Object[]{new Integer(length), new Integer(maxContentLength)};
            throw new L10NMessageImpl(bundleName, "contentLengthTooLarge", args);
        }
    }

    private static int getMaxContentLength() {
        int maxContentLength;
        block2: {
            maxContentLength = 16384;
            String maxContentLengthProp = SystemProperties.get("com.iplanet.services.comm.server.pllrequest.maxContentLength");
            try {
                maxContentLength = Integer.parseInt(maxContentLengthProp);
            }
            catch (NumberFormatException ne) {
                if (!debug.messageEnabled()) break block2;
                debug.message("RequestUtils: invalid property for maxContentLength [" + maxContentLengthProp + "] property");
            }
        }
        return maxContentLength;
    }

    static {
        StringTokenizer tokenizer;
        debug = Debug.getInstance(debugName);
        maxContentLength = RequestUtils.getMaxContentLength();
        rdProtocol = null;
        rdHost = null;
        String redirect = SystemProperties.get("com.sun.identity.url.redirect", null);
        if (redirect != null && (tokenizer = new StringTokenizer(redirect, ",")).countTokens() == 2) {
            rdProtocol = tokenizer.nextToken().trim();
            rdHost = tokenizer.nextToken().trim();
        }
    }
}

