/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.util;

import com.iplanet.security.util.BigInt;
import com.iplanet.security.util.DerInputBuffer;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import sun.security.util.BitArray;

public class DerInputStream {
    DerInputBuffer buffer;

    public DerInputStream(byte[] data) {
        this.buffer = new DerInputBuffer(data);
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream(byte[] data, int offset, int len) {
        this.buffer = new DerInputBuffer(data, offset, len);
        this.buffer.mark(Integer.MAX_VALUE);
    }

    DerInputStream(DerInputBuffer buf) {
        this.buffer = buf;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream subStream(int len, boolean do_skip) throws IOException {
        DerInputBuffer newbuf = this.buffer.dup();
        newbuf.truncate(len);
        if (do_skip) {
            this.buffer.skip(len);
        }
        return new DerInputStream(newbuf);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public BigInt getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getUnsigned(DerInputStream.getLength(this.buffer));
    }

    public byte[] getBitString() throws IOException {
        byte[] retval;
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not an bit string");
        }
        int length = DerInputStream.getLength(this.buffer);
        if (this.buffer.read() != 0) {
            return null;
        }
        if (this.buffer.read(retval = new byte[--length]) != length) {
            throw new IOException("short read of DER bit string");
        }
        return retval;
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not a bit string");
        }
        int length = DerInputStream.getLength(this.buffer) - 1;
        int validBits = length * 8 - this.buffer.read();
        byte[] repn = new byte[length];
        if (this.buffer.read(repn) != length) {
            throw new IOException("short read of DER bit string");
        }
        return new BitArray(validBits, repn);
    }

    public byte[] getOctetString() throws IOException {
        if (this.buffer.read() != 4) {
            throw new IOException("DER input not an octet string");
        }
        int length = DerInputStream.getLength(this.buffer);
        byte[] retval = new byte[length];
        if (this.buffer.read(retval) != length) {
            throw new IOException("short read of DER octet string");
        }
        return retval;
    }

    public void getBytes(byte[] val) throws IOException {
        if (val.length != 0 && this.buffer.read(val) != val.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public DerValue[] getSequence(int startLen) throws IOException {
        if (this.buffer.read() != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(startLen);
    }

    public DerValue[] getSet(int startLen) throws IOException {
        if (this.buffer.read() != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(startLen);
    }

    public DerValue[] getSet(int startLen, boolean implicit) throws IOException {
        int tag = this.buffer.read();
        if (!implicit && tag != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(startLen);
    }

    protected DerValue[] readVector(int startLen) throws IOException {
        int len = DerInputStream.getLength(this.buffer);
        if (len == 0) {
            return new DerValue[0];
        }
        DerInputStream newstr = this.buffer.available() == len ? this : this.subStream(len, true);
        Vector<DerValue> vec = new Vector<DerValue>(startLen, 5);
        do {
            DerValue value = new DerValue(newstr.buffer);
            vec.addElement(value);
        } while (newstr.available() > 0);
        if (newstr.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int max = vec.size();
        DerValue[] retval = new DerValue[max];
        for (int i = 0; i < max; ++i) {
            retval[i] = (DerValue)vec.elementAt(i);
        }
        return retval;
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.buffer);
    }

    public String getPrintableString() throws IOException {
        return new DerValue(this.buffer).getPrintableString();
    }

    public String getT61String() throws IOException {
        return new DerValue(this.buffer).getT61String();
    }

    public String getIA5String() throws IOException {
        return new DerValue(this.buffer).getIA5String();
    }

    public String getBMPString() throws IOException {
        return new DerValue(this.buffer).getBMPString();
    }

    public String getUniversalString() throws IOException {
        return new DerValue(this.buffer).getUniversalString();
    }

    public Date getUTCTime() throws IOException {
        int second;
        if (this.buffer.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        if (this.buffer.available() < 11) {
            throw new IOException("DER input, UTCtime short input");
        }
        int len = DerInputStream.getLength(this.buffer);
        if (len < 11 || len > 17) {
            throw new IOException("DER getUTCTime length error");
        }
        int year = 10 * Character.digit((char)this.buffer.read(), 10);
        year = (year += Character.digit((char)this.buffer.read(), 10)) <= 50 ? (year += 2000) : (year += 1900);
        int month = 10 * Character.digit((char)this.buffer.read(), 10);
        month += Character.digit((char)this.buffer.read(), 10);
        --month;
        int day = 10 * Character.digit((char)this.buffer.read(), 10);
        day += Character.digit((char)this.buffer.read(), 10);
        int hour = 10 * Character.digit((char)this.buffer.read(), 10);
        hour += Character.digit((char)this.buffer.read(), 10);
        int minute = 10 * Character.digit((char)this.buffer.read(), 10);
        minute += Character.digit((char)this.buffer.read(), 10);
        if ((len -= 10) == 3 || len == 7) {
            second = 10 * Character.digit((char)this.buffer.read(), 10);
            second += Character.digit((char)this.buffer.read(), 10);
            len -= 2;
        } else {
            second = 0;
        }
        if (month < 0 || day <= 0 || month > 11 || day > 31 || hour >= 24 || minute >= 60 || second >= 60) {
            throw new IOException("Parse UTC time, invalid format");
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(year, month, day, hour, minute, second);
        cal.set(14, 0);
        cal.set(0, 1);
        Date readDate = cal.getTime();
        long utcTime = readDate.getTime();
        if (len != 1 && len != 5) {
            throw new IOException("Parse UTC time, invalid offset");
        }
        switch (this.buffer.read()) {
            case 43: {
                int Htmp = 10 * Character.digit((char)this.buffer.read(), 10);
                int Mtmp = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((Htmp += Character.digit((char)this.buffer.read(), 10)) >= 24 || (Mtmp += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, +hhmm");
                }
                utcTime += (long)((Htmp * 60 + Mtmp) * 60 * 1000);
                break;
            }
            case 45: {
                int Htmp = 10 * Character.digit((char)this.buffer.read(), 10);
                int Mtmp = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((Htmp += Character.digit((char)this.buffer.read(), 10)) >= 24 || (Mtmp += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, -hhmm");
                }
                utcTime -= (long)((Htmp * 60 + Mtmp) * 60 * 1000);
                break;
            }
            case 90: {
                break;
            }
            default: {
                throw new IOException("Parse UTCtime, garbage offset");
            }
        }
        readDate.setTime(utcTime);
        return readDate;
    }

    public Date getGeneralizedTime() throws IOException {
        int second;
        if (this.buffer.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        if (this.buffer.available() < 13) {
            throw new IOException("DER input, GeneralizedTime short input");
        }
        int len = DerInputStream.getLength(this.buffer);
        int year = 1000 * Character.digit((char)this.buffer.read(), 10);
        year += 100 * Character.digit((char)this.buffer.read(), 10);
        year += 10 * Character.digit((char)this.buffer.read(), 10);
        year += Character.digit((char)this.buffer.read(), 10);
        int month = 10 * Character.digit((char)this.buffer.read(), 10);
        month += Character.digit((char)this.buffer.read(), 10);
        --month;
        int day = 10 * Character.digit((char)this.buffer.read(), 10);
        day += Character.digit((char)this.buffer.read(), 10);
        int hour = 10 * Character.digit((char)this.buffer.read(), 10);
        hour += Character.digit((char)this.buffer.read(), 10);
        int minute = 10 * Character.digit((char)this.buffer.read(), 10);
        minute += Character.digit((char)this.buffer.read(), 10);
        if ((len -= 12) == 3 || len == 7) {
            second = 10 * Character.digit((char)this.buffer.read(), 10);
            second += Character.digit((char)this.buffer.read(), 10);
            len -= 2;
        } else {
            second = 0;
        }
        if (month < 0 || day <= 0 || month > 11 || day > 31 || hour >= 24 || minute >= 60 || second >= 60) {
            throw new IOException("Parse Generalized time, invalid format");
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(year, month, day, hour, minute, second);
        cal.set(14, 0);
        cal.set(0, 1);
        Date readDate = cal.getTime();
        long utcTime = readDate.getTime();
        if (len != 1 && len != 5) {
            throw new IOException("Parse Generalized time, invalid offset");
        }
        switch (this.buffer.read()) {
            case 43: {
                int Htmp = 10 * Character.digit((char)this.buffer.read(), 10);
                int Mtmp = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((Htmp += Character.digit((char)this.buffer.read(), 10)) >= 24 || (Mtmp += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, +hhmm");
                }
                utcTime += (long)((Htmp * 60 + Mtmp) * 60 * 1000);
                break;
            }
            case 45: {
                int Htmp = 10 * Character.digit((char)this.buffer.read(), 10);
                int Mtmp = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((Htmp += Character.digit((char)this.buffer.read(), 10)) >= 24 || (Mtmp += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, -hhmm");
                }
                utcTime -= (long)((Htmp * 60 + Mtmp) * 60 * 1000);
                break;
            }
            case 90: {
                break;
            }
            default: {
                throw new IOException("Parse GeneralizedTime, garbage offset");
            }
        }
        readDate.setTime(utcTime);
        return readDate;
    }

    int getByte() throws IOException {
        return 0xFF & this.buffer.read();
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(this.buffer);
    }

    static int getLength(InputStream in) throws IOException {
        int value;
        int tmp = in.read();
        if ((tmp & 0x80) == 0) {
            value = tmp;
        } else {
            if ((tmp &= 0x7F) <= 0 || tmp > 4) {
                throw new IOException("DerInput.getLength(): lengthTag=" + tmp + ", " + (tmp == 0 ? "Indefinite length encoding not supported or incorrect DER encoding." : "too big."));
            }
            value = 0;
            while (tmp > 0) {
                value <<= 8;
                value += 0xFF & in.read();
                --tmp;
            }
        }
        return value;
    }

    public void mark(int value) {
        this.buffer.mark(value);
    }

    public void reset() {
        this.buffer.reset();
    }

    public int available() {
        return this.buffer.available();
    }
}

