/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.sso.SSOToken;
import com.sun.identity.common.AttributeStruct;
import com.sun.identity.common.PropertiesFinder;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSEntry;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class SystemProperties {
    private static String instanceName;
    private static Map attributeMap;
    private static Properties props;
    private static long lastModified;
    private static String initError;
    private static String initSecondaryError;
    public static String iasGXId;
    private static final String SERVER_NAME_PROPERTY = "server.name";
    private static final String CONFIG_NAME_PROPERTY = "amconfig";
    private static final String AMCONFIG_FILE_NAME = "AMConfig";
    public static final String CONFIG_PATH = "com.iplanet.services.configpath";
    public static final String CONFIG_FILE_NAME = "serverconfig.xml";
    public static final String PROPERTIES = "properties";
    public static final String NEWCONFDIR = "NEW_CONF_DIR";
    private static Map mapTagswap;
    private static Map tagswapValues;
    private static Map cacheServerDefaults;
    private static Map cacheSiteDefaults;

    private static void initAttributeMapping() {
        ResourceBundle rb = ResourceBundle.getBundle("serverAttributeMap");
        Enumeration<String> e = rb.getKeys();
        while (e.hasMoreElements()) {
            String propertyName = e.nextElement();
            attributeMap.put(propertyName, new AttributeStruct(rb.getString(propertyName)));
        }
    }

    static void saveException(Exception ex) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(baos));
        initSecondaryError = baos.toString();
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String get(String key) {
        AttributeStruct ast;
        String answer = null;
        if (SystemProperties.isServerMode() && (ast = (AttributeStruct)attributeMap.get(key)) != null) {
            answer = PropertiesFinder.getProperty(key, ast);
        }
        if (answer == null && (answer = SystemProperties.getProp(key)) != null && tagswapValues != null) {
            HashSet set = new HashSet();
            set.addAll(tagswapValues.keySet());
            Iterator i = set.iterator();
            while (i.hasNext()) {
                String k = (String)i.next();
                String val = (String)tagswapValues.get(k);
                answer = answer.replaceAll(k, val);
            }
            if (answer.indexOf("%ROOT_SUFFIX%") != -1) {
                answer = answer.replaceAll("%ROOT_SUFFIX%", SMSEntry.getRootSuffix());
            }
        }
        return answer;
    }

    private static String getProp(String key, String def) {
        String value = SystemProperties.getProp(key);
        return value == null ? def : value;
    }

    private static String getProp(String key) {
        String answer = System.getProperty(key);
        if (answer == null) {
            answer = props.getProperty(key);
        }
        return answer;
    }

    public static String get(String key, String def) {
        String value = SystemProperties.get(key);
        return value == null ? def : value;
    }

    public static Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)props);
        return properties;
    }

    public static Properties getAll() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)props);
        Iterator<Map.Entry<Object, Object>> it = System.getProperties().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (key == null || key.length() <= 0) continue;
            properties.setProperty(key, val);
        }
        return properties;
    }

    public static Properties getPlatform() {
        return SystemProperties.getAll();
    }

    private static void updateTagswapMap(Properties properties) {
        tagswapValues = new HashMap();
        Iterator i = mapTagswap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String rgKey = (String)mapTagswap.get(key);
            String val = System.getProperty(rgKey);
            if (val == null) {
                val = (String)properties.get(rgKey);
            }
            tagswapValues.put(key, val);
        }
    }

    public static synchronized void initializeProperties(String file) throws MissingResourceException {
        ResourceBundle bundle = ResourceBundle.getBundle(file);
        Enumeration<String> e = bundle.getKeys();
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)props);
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            newProps.put(key, bundle.getString(key));
        }
        props = newProps;
        SystemProperties.updateTagswapMap(props);
        lastModified = System.currentTimeMillis();
    }

    public static synchronized void initializeProperties(Properties properties) {
        SystemProperties.initializeProperties(properties, false);
    }

    public static synchronized void initializeProperties(Properties properties, boolean reset) {
        SystemProperties.initializeProperties(properties, reset, false);
    }

    public static synchronized void initializeProperties(Properties properties, boolean reset, boolean withDefaults) {
        SSOToken appToken;
        Properties defaultProp;
        Properties newProps = new Properties();
        if (withDefaults && (defaultProp = ServerConfiguration.getDefaults(appToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()))) != null) {
            newProps.putAll((Map<?, ?>)defaultProp);
        }
        if (!reset) {
            newProps.putAll((Map<?, ?>)props);
        }
        newProps.putAll((Map<?, ?>)properties);
        props = newProps;
        SystemProperties.updateTagswapMap(props);
        lastModified = System.currentTimeMillis();
    }

    public static synchronized void initializeProperties(String propertyName, String propertyValue) {
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)props);
        newProps.put(propertyName, propertyValue);
        props = newProps;
        SystemProperties.updateTagswapMap(props);
        lastModified = System.currentTimeMillis();
    }

    public static long lastModified() {
        return lastModified;
    }

    public static String getInitializationError() {
        return initError;
    }

    public static String getSecondaryInitializationError() {
        return initSecondaryError;
    }

    public static void setServerInstanceName(String name) {
        instanceName = name;
    }

    public static String getServerInstanceName() {
        return instanceName;
    }

    public static boolean isServerMode() {
        return Boolean.valueOf(SystemProperties.getProp("com.iplanet.am.serverMode", "false"));
    }

    public static Map getAttributeMap() {
        return attributeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block16: {
            attributeMap = new HashMap();
            SystemProperties.initAttributeMapping();
            iasGXId = null;
            mapTagswap = new HashMap();
            mapTagswap.put("%SERVER_PORT%", "com.iplanet.am.server.port");
            mapTagswap.put("%SERVER_URI%", "com.iplanet.am.services.deploymentDescriptor");
            mapTagswap.put("%SERVER_HOST%", "com.iplanet.am.server.host");
            mapTagswap.put("%SERVER_PROTO%", "com.iplanet.am.server.protocol");
            mapTagswap.put("%BASE_DIR%", CONFIG_PATH);
            try {
                props = new Properties();
                String serverName = System.getProperty(SERVER_NAME_PROPERTY);
                String configName = System.getProperty(CONFIG_NAME_PROPERTY, AMCONFIG_FILE_NAME);
                String fname = null;
                FileInputStream fis = null;
                if (serverName != null) {
                    serverName = serverName.replace('.', '_');
                    fname = configName + "-" + serverName;
                } else {
                    fname = configName;
                }
                SystemProperties.initializeProperties(fname);
                try {
                    String newConfigFileLoc = props.getProperty("com.sun.identity.configFilePath");
                    if (newConfigFileLoc == null || newConfigFileLoc.length() <= 0 || newConfigFileLoc.equals(NEWCONFDIR)) break block16;
                    String hostName = InetAddress.getLocalHost().getHostName().toLowerCase();
                    String serverURI = props.getProperty("com.iplanet.am.services.deploymentDescriptor");
                    serverURI = serverURI.replace('/', '_').toLowerCase();
                    StringBuffer fileName = new StringBuffer();
                    fileName.append(newConfigFileLoc).append("/").append(AMCONFIG_FILE_NAME).append(serverURI).append(hostName).append(props.getProperty("com.iplanet.am.server.port")).append(".").append(PROPERTIES);
                    Properties modProp = new Properties();
                    try {
                        fis = new FileInputStream(fileName.toString());
                        modProp.load(fis);
                        props.putAll((Map<?, ?>)modProp);
                    }
                    catch (IOException ioe) {
                        StringBuffer fileNameOrig = new StringBuffer();
                        fileNameOrig.append(newConfigFileLoc).append("/").append(AMCONFIG_FILE_NAME).append(".").append(PROPERTIES);
                        try {
                            fis = new FileInputStream(fileNameOrig.toString());
                            modProp.load(fis);
                            props.putAll((Map<?, ?>)modProp);
                        }
                        catch (IOException ioexp) {
                            SystemProperties.saveException(ioexp);
                        }
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                }
                catch (Exception ex) {
                    SystemProperties.saveException(ex);
                }
            }
            catch (MissingResourceException e) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(baos));
                initError = baos.toString();
                try {
                    baos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

