/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.shared.debug.IDebug;
import com.sun.identity.shared.debug.IDebugProvider;
import com.sun.identity.shared.debug.impl.DebugProviderImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class Debug {
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int MESSAGE = 3;
    public static final int ON = 4;
    public static final String STR_OFF = "off";
    public static final String STR_ERROR = "error";
    public static final String STR_WARNING = "warning";
    public static final String STR_MESSAGE = "message";
    public static final String STR_ON = "on";
    private static Map debugMap = new HashMap();
    private static boolean serviceInitialized = false;
    private static IDebugProvider debugProvider;
    private static final String CONFIG_DEBUG_PROVIDER = "com.sun.identity.util.debug.provider";
    private IDebug debugServiceInstance;

    public static synchronized Debug getInstance(String debugName) {
        Debug debug = (Debug)Debug.getDebugMap().get(debugName);
        if (debug == null) {
            debug = new Debug(Debug.getDebugProvider().getInstance(debugName));
            Debug.getDebugMap().put(debugName, debug);
        }
        return debug;
    }

    public static Collection getInstances() {
        return Debug.getDebugMap().values();
    }

    private static Map getDebugMap() {
        return debugMap;
    }

    private static void setDebugProvider(IDebugProvider provider) {
        debugProvider = provider;
    }

    private static IDebugProvider getDebugProvider() {
        return debugProvider;
    }

    private static synchronized void initialize() {
        if (!serviceInitialized) {
            String providerName = SystemProperties.get(CONFIG_DEBUG_PROVIDER);
            IDebugProvider provider = null;
            boolean providerLoadFailed = false;
            if (providerName != null && providerName.trim().length() > 0) {
                try {
                    provider = (IDebugProvider)Class.forName(providerName).newInstance();
                }
                catch (ClassNotFoundException cnex) {
                    providerLoadFailed = true;
                }
                catch (InstantiationException iex) {
                    providerLoadFailed = true;
                }
                catch (IllegalAccessException iaex) {
                    providerLoadFailed = true;
                }
                catch (ClassCastException ccex) {
                    providerLoadFailed = true;
                }
            }
            if (provider == null) {
                if (providerLoadFailed) {
                    ResourceBundle bundle = Locale.getInstallResourceBundle("amUtilMsgs");
                    System.err.println(bundle.getString("com.iplanet.services.debug.invlaidprovider"));
                }
                provider = new DebugProviderImpl();
            }
            Debug.setDebugProvider(provider);
            serviceInitialized = true;
        }
    }

    public String getName() {
        return this.getDebugServiceInstance().getName();
    }

    public boolean messageEnabled() {
        return this.getDebugServiceInstance().messageEnabled();
    }

    public boolean warningEnabled() {
        return this.getDebugServiceInstance().warningEnabled();
    }

    public boolean errorEnabled() {
        return this.getDebugServiceInstance().errorEnabled();
    }

    public int getState() {
        return this.getDebugServiceInstance().getState();
    }

    public void message(String msg) {
        this.getDebugServiceInstance().message(msg, null);
    }

    public void message(String msg, Throwable t) {
        this.getDebugServiceInstance().message(msg, t);
    }

    public void warning(String msg) {
        this.getDebugServiceInstance().warning(msg, null);
    }

    public void warning(String msg, Throwable t) {
        this.getDebugServiceInstance().warning(msg, t);
    }

    public void error(String msg) {
        this.getDebugServiceInstance().error(msg, null);
    }

    public void error(String msg, Throwable t) {
        this.getDebugServiceInstance().error(msg, t);
    }

    public void setDebug(int debugType) {
        this.getDebugServiceInstance().setDebug(debugType);
    }

    public void setDebug(String debugType) {
        this.getDebugServiceInstance().setDebug(debugType);
    }

    public void destroy() {
    }

    private void setDebugServiceInstance(IDebug debugServiceInstance) {
        this.debugServiceInstance = debugServiceInstance;
    }

    private IDebug getDebugServiceInstance() {
        return this.debugServiceInstance;
    }

    private Debug(IDebug debugServiceInstance) {
        this.setDebugServiceInstance(debugServiceInstance);
    }

    static {
        Debug.initialize();
    }
}

