/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.TestCompileAndExecSupport;
import org.antlr.test.unit.TestSuite;

public class TestAutoAST
extends TestSuite {
    protected boolean debug = false;

    public void testTokenList() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : ID INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "abc 34", this.debug);
        String string3 = "abc 34\n";
        this.assertEqual(string2, string3);
    }

    public void testTokenListInSingleAltBlock() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : (ID INT) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "abc 34", this.debug);
        String string3 = "abc 34\n";
        this.assertEqual(string2, string3);
    }

    public void testSimpleRootAtOuterLevel() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : ID^ INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "abc 34", this.debug);
        String string3 = "(abc 34)\n";
        this.assertEqual(string2, string3);
    }

    public void testSimpleRootAtOuterLevelReverse() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : INT ID^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "34 abc", this.debug);
        String string3 = "(abc 34)\n";
        this.assertEqual(string2, string3);
    }

    public void testBang() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT! ID! INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34 dag 4532", this.debug);
        String string3 = "abc 4532\n";
        this.assertEqual(string2, string3);
    }

    public void testLoopRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ( ID^ INT )* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 1 b 2 c 3", this.debug);
        String string3 = "(a 1) (b 2) (c 3)\n";
        this.assertEqual(string2, string3);
    }

    public void testLoopRootReverse() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ( ID INT^ )* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 1 b 2 c 3", this.debug);
        String string3 = "(1 a) (2 b) (3 c)\n";
        this.assertEqual(string2, string3);
    }

    public void testPlusLoopRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ( ID^ INT )+ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 1 b 2 c 3", this.debug);
        String string3 = "(a 1) (b 2) (c 3)\n";
        this.assertEqual(string2, string3);
    }

    public void testPlusLoopRootReverse() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ( ID^ INT )+ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 1 b 2 c 3", this.debug);
        String string3 = "(a 1) (b 2) (c 3)\n";
        this.assertEqual(string2, string3);
    }

    public void testOptionalThenRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ( ID INT )? ID^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 1 b", this.debug);
        String string3 = "(b a 1)\n";
        this.assertEqual(string2, string3);
    }

    public void testLabeledStringRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : v='void'^ ID ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "void foo;", this.debug);
        String string3 = "(void foo ;)\n";
        this.assertEqual(string2, string3);
    }

    public void testWildcard() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : v='void'^ . ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "void foo;", this.debug);
        String string3 = "(void foo ;)\n";
        this.assertEqual(string2, string3);
    }

    public void testWildcardRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : v='void' .^ ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "void foo;", this.debug);
        String string3 = "(foo void ;)\n";
        this.assertEqual(string2, string3);
    }

    public void testRootRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID^ INT^ ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 34 c", this.debug);
        String string3 = "(34 a c)\n";
        this.assertEqual(string2, string3);
    }

    public void testRootRoot2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT^ ID^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 34 c", this.debug);
        String string3 = "(c (34 a))\n";
        this.assertEqual(string2, string3);
    }

    public void testNestedSubrule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'void' (({;}ID|INT) ID | 'null' ) ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "void a b;", this.debug);
        String string3 = "void a b ;\n";
        this.assertEqual(string2, string3);
    }

    public void testInvokeRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na  : type ID ;\ntype : {;}'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "int a", this.debug);
        String string3 = "int a\n";
        this.assertEqual(string2, string3);
    }

    public void testInvokeRuleAsRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na  : type^ ID ;\ntype : {;}'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "int a", this.debug);
        String string3 = "(int a)\n";
        this.assertEqual(string2, string3);
    }

    public void testRuleRootInLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ('+'^^ ID)* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a+b+c+d", this.debug);
        String string3 = "(+ (+ (+ a b) c) d)\n";
        this.assertEqual(string2, string3);
    }

    public void testRuleInvocationRuleRootInLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID (op^^ ID)* ;\nop : {;}'+' | '-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a+b+c-d", this.debug);
        String string3 = "(- (+ (+ a b) c) d)\n";
        this.assertEqual(string2, string3);
    }

    public void testTailRecursion() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ns : a ;\na : atom ('exp'^^ a)? ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "s", "3 exp 4 exp 5", this.debug);
        String string3 = "(exp 3 (exp 4 5))\n";
        this.assertEqual(string2, string3);
    }

    public void testSet() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID|INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc", this.debug);
        String string3 = "abc\n";
        this.assertEqual(string2, string3);
    }

    public void testSetRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ('+' | '-')^ ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "+abc", this.debug);
        String string3 = "(+ abc)\n";
        this.assertEqual(string2, string3);
    }

    public void testSetAsRuleRootInLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID (('+'|'-')^^ ID)* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a+b-c", this.debug);
        String string3 = "(- (+ a b) c)\n";
        this.assertEqual(string2, string3);
    }

    public void testNotSet() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ~ID '+' INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "34+2", this.debug);
        String string3 = "34 + 2\n";
        this.assertEqual(string2, string3);
    }

    public void testNotSetRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ~'+'^ INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "34 55", this.debug);
        String string3 = "(34 55)\n";
        this.assertEqual(string2, string3);
    }

    public void testNotSetRuleRootInLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : INT (~INT^^ INT)* ;\nblort : '+' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "3+4+5", this.debug);
        String string3 = "(+ (+ 3 4) 5)\n";
        this.assertEqual(string2, string3);
    }

    public void testTokenLabelReuse() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : id=ID id=ID {System.out.print(\"2nd id=\"+$id.text+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "2nd id=b;a b\n";
        this.assertEqual(string2, string3);
    }

    public void testTokenLabelReuse2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : id=ID id=ID^ {System.out.print(\"2nd id=\"+$id.text+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "2nd id=b;(b a)\n";
        this.assertEqual(string2, string3);
    }

    public void testTokenListLabelReuse() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ids+=ID ids+=ID {System.out.print(\"id list=\"+$ids+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "id list=[[@0,0:0='a',<4>,1:0], [@2,2:2='b',<4>,1:2]];a b\n";
        this.assertEqual(string2, string3);
    }

    public void testTokenListLabelReuse2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ids+=ID^ ids+=ID {System.out.print(\"id list=\"+$ids+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "id list=[[@0,0:0='a',<4>,1:0], [@2,2:2='b',<4>,1:2]];(a b)\n";
        this.assertEqual(string2, string3);
    }

    public void testTokenListLabelRuleRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : id+=ID^^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a", this.debug);
        String string3 = "a\n";
        this.assertEqual(string2, string3);
    }

    public void testTokenListLabelBang() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : id+=ID! ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a", this.debug);
        String string3 = "nil\n";
        this.assertEqual(string2, string3);
    }

    public void testRuleListLabel() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : x+=b x+=b {b_return ret=(b_return)$x.get(1);System.out.print(\"2nd x=\"+((CommonTree)ret.tree).toStringTree()+';');} ;\nb : ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "2nd x=b;a b\n";
        this.assertEqual(string2, string3);
    }

    public void testRuleListLabelRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ( x+=b^ )+ {b_return ret=(b_return)$x.get(1);System.out.print(\"x=\"+((CommonTree)ret.tree).toStringTree()+';');} ;\nb : ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "x=b;a b\n";
        this.assertEqual(string2, string3);
    }

    public void testRuleListLabelRuleRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ( x+=b^^ )+ {b_return ret=(b_return)$x.get(1);System.out.print(\"x=\"+((CommonTree)ret.tree).toStringTree()+';');} ;\nb : ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "x=(b a);(b a)\n";
        this.assertEqual(string2, string3);
    }

    public void testRuleListLabelBang() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : x+=b! x+=b {b_return ret=(b_return)$x.get(0);System.out.print(\"1st x=\"+((CommonTree)ret.tree).toStringTree()+';');} ;\nb : ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "1st x=a;b\n";
        this.assertEqual(string2, string3);
    }

    public void testComplicatedMelange() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : A b=B b=B c+=C c+=C D {$D.text;} ;\nA : 'a' ;\nB : 'b' ;\nC : 'c' ;\nD : 'd' ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b b c c d", this.debug);
        String string3 = "a b b c c d\n";
        this.assertEqual(string2, string3);
    }

    public void testReturnValueWithAST() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : ID b {System.out.println($b.i);} ;\nb returns [int i] : INT {$i=Integer.parseInt($INT.text);} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "abc 34", this.debug);
        String string3 = "34\nabc 34\n";
        this.assertEqual(string2, string3);
    }

    public void _test() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na :  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "\n";
        this.assertEqual(string2, string3);
    }
}

