/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.xmlsig;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.AMSignatureProvider;
import com.sun.identity.saml.xmlsig.OfflineResolver;
import com.sun.identity.saml.xmlsig.XMLSignatureException;
import com.sun.identity.wss.security.STRTransform;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.signature.XMLSignature;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.Constants;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSSSignatureProvider
extends AMSignatureProvider {
    public WSSSignatureProvider() {
        block2: {
            try {
                Transform.register("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", STRTransform.class.getName());
            }
            catch (Exception e) {
                if (!WSSUtils.debug.messageEnabled()) break block2;
                WSSUtils.debug.message("WSSSignatureProvider.constructor: STR Transform is already registered");
            }
        }
    }

    public Element signWithSAMLToken(Document doc, Certificate cert, String assertionID, String algorithm, List ids) throws XMLSignatureException {
        if (doc == null) {
            WSSUtils.debug.error("WSSSignatureProvider.signWithSAMLToken: document is null.");
            throw new XMLSignatureException(WSSUtils.bundle.getString("nullInput"));
        }
        boolean isSAML2Token = false;
        Element assertionElement = (Element)doc.getDocumentElement().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
        if (assertionElement != null) {
            isSAML2Token = true;
        }
        if (cert == null) {
            WSSUtils.debug.error("WSSSignatureProvider.signWithSAMLToken: Certificate is null");
            throw new XMLSignatureException(WSSUtils.bundle.getString("nullInput"));
        }
        if (assertionID == null) {
            WSSUtils.debug.error("WSSSignatureProvider.signWithSAMLToken: Certificate is null");
            throw new XMLSignatureException(WSSUtils.bundle.getString("nullInput"));
        }
        Element root = (Element)doc.getDocumentElement().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security").item(0);
        Element timeStamp = (Element)doc.getDocumentElement().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp").item(0);
        XMLSignature signature = null;
        try {
            Constants.setSignatureSpecNSprefix((String)"ds");
            String certAlias = this.keystore.getCertificateAlias(cert);
            PrivateKey privateKey = this.keystore.getPrivateKey(certAlias);
            if (privateKey == null) {
                WSSUtils.debug.error("WSSSignatureProvider.signWithSAMLToken:Private Key is null for " + certAlias);
                throw new XMLSignatureException(WSSUtils.bundle.getString("nullprivatekey"));
            }
            if (algorithm == null || algorithm.length() == 0) {
                algorithm = this.getPublicKey((X509Certificate)cert).getAlgorithm();
                algorithm = this.getAlgorithmURI(algorithm);
            }
            if (!this.isValidAlgorithm(algorithm)) {
                throw new XMLSignatureException(WSSUtils.bundle.getString("invalidalgorithm"));
            }
            Element wsucontext = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            NodeList wsuNodes = XPathAPI.selectNodeList(doc, "//*[@wsu:Id]", wsucontext);
            if (wsuNodes != null && wsuNodes.getLength() != 0) {
                for (int i = 0; i < wsuNodes.getLength(); ++i) {
                    Element elem = (Element)wsuNodes.item(i);
                    String id = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    if (id == null || id.length() == 0) continue;
                    IdResolver.registerElementById((Element)elem, (String)id);
                }
            }
            signature = new XMLSignature(doc, null, algorithm, "http://www.w3.org/2001/10/xml-exc-c14n#");
            Element sigEl = signature.getElement();
            doc.importNode(sigEl, true);
            sigEl.setPrefix("ds");
            root.insertBefore(sigEl, timeStamp);
            Text textNode = doc.createTextNode("\n");
            root.insertBefore(textNode, sigEl);
            Element transformParams = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:TransformationParameters");
            transformParams.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            Element canonElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
            canonElem.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
            transformParams.appendChild(canonElem);
            Element securityTokenRef = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
            securityTokenRef.setPrefix("wsse");
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse11", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
            String secRefId = SAMLUtils.generateID();
            securityTokenRef.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", secRefId);
            if (isSAML2Token) {
                securityTokenRef.setAttributeNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:TokenType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            } else {
                securityTokenRef.setAttributeNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:TokenType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            }
            signature.addKeyInfo((X509Certificate)cert);
            KeyInfo keyInfo = signature.getKeyInfo();
            keyInfo.addUnknownElement(securityTokenRef);
            IdResolver.registerElementById((Element)securityTokenRef, (String)secRefId);
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                Transforms transforms = new Transforms(doc);
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                String id = (String)ids.get(i);
                if (WSSUtils.debug.messageEnabled()) {
                    WSSUtils.debug.message("id = " + id);
                }
                signature.addDocument("#" + id, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            }
            Element keyIdentifier = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
            keyIdentifier.setPrefix("wsse");
            keyIdentifier.setAttribute("wsu:Id", SAMLUtils.generateID());
            Text value = doc.createTextNode(assertionID);
            keyIdentifier.appendChild(value);
            if (isSAML2Token) {
                keyIdentifier.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
            } else {
                keyIdentifier.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
            }
            securityTokenRef.appendChild(keyIdentifier);
            signature.sign(privateKey);
        }
        catch (Exception e) {
            WSSUtils.debug.error("WSSSignatureProvider.signWithSAMLToken Exception: ", (Throwable)e);
            throw new XMLSignatureException(e.getMessage());
        }
        if (WSSUtils.debug.messageEnabled()) {
            WSSUtils.debug.message("WSSSignatureProvider.signWithSAMLTokenSigned document" + com.sun.identity.shared.xml.XMLUtils.print((Node)doc.getDocumentElement()));
        }
        return signature.getElement();
    }

    public Element signWithUserNameToken(Document doc, Certificate cert, String algorithm, List ids) throws XMLSignatureException {
        return this.signWithBinarySecurityToken(doc, cert, algorithm, ids, "UsernameToken");
    }

    public Element signWithBinarySecurityToken(Document doc, Certificate cert, String algorithm, List ids) throws XMLSignatureException {
        return this.signWithBinarySecurityToken(doc, cert, algorithm, ids, "BinarySecurityToken");
    }

    private Element signWithBinarySecurityToken(Document doc, Certificate cert, String algorithm, List ids, String tokenType) throws XMLSignatureException {
        if (doc == null) {
            SAMLUtils.debug.error("WSSSignatureProvider.signWithBinarySecurityToken:: XML doc is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("WSSSignatureProvider.signWithWSSToken: Document to be signed : " + com.sun.identity.shared.xml.XMLUtils.print((Node)doc.getDocumentElement()));
        }
        Element root = (Element)doc.getDocumentElement().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security").item(0);
        XMLSignature signature = null;
        try {
            Constants.setSignatureSpecNSprefix((String)"ds");
            String certAlias = this.keystore.getCertificateAlias(cert);
            PrivateKey privateKey = this.keystore.getPrivateKey(certAlias);
            if (privateKey == null) {
                SAMLUtils.debug.error("WSSSignatureProvider.signWithWSSToken: private key is null");
                throw new XMLSignatureException(SAMLUtils.bundle.getString("nullprivatekey"));
            }
            if (algorithm == null || algorithm.length() == 0) {
                algorithm = this.getPublicKey((X509Certificate)cert).getAlgorithm();
                algorithm = this.getAlgorithmURI(algorithm);
            }
            if (!this.isValidAlgorithm(algorithm)) {
                throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidalgorithm"));
            }
            Element wsucontext = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            NodeList wsuNodes = XPathAPI.selectNodeList(doc, "//*[@wsu:Id]", wsucontext);
            if (wsuNodes != null && wsuNodes.getLength() != 0) {
                for (int i = 0; i < wsuNodes.getLength(); ++i) {
                    Element elem = (Element)wsuNodes.item(i);
                    String id = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    if (id == null || id.length() == 0) continue;
                    IdResolver.registerElementById((Element)elem, (String)id);
                }
            }
            signature = new XMLSignature(doc, "", algorithm, "http://www.w3.org/2001/10/xml-exc-c14n#");
            Element sigEl = signature.getElement();
            root.appendChild(sigEl);
            Element transformParams = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:TransformationParameters");
            transformParams.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            Element canonElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
            canonElem.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
            transformParams.appendChild(canonElem);
            Element securityTokenRef = null;
            String secRefId = null;
            securityTokenRef = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            secRefId = SAMLUtils.generateID();
            securityTokenRef.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", secRefId);
            KeyInfo keyInfo = signature.getKeyInfo();
            keyInfo.addUnknownElement(securityTokenRef);
            IdResolver.registerElementById((Element)securityTokenRef, (String)secRefId);
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                Transforms transforms = new Transforms(doc);
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                String id = (String)ids.get(i);
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("id = " + id);
                }
                signature.addDocument("#" + id, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            }
            Element reference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference");
            securityTokenRef.appendChild(reference);
            Element bsf = (Element)root.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", tokenType).item(0);
            if (bsf != null) {
                String certId = bsf.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                reference.setAttributeNS(null, "URI", "#" + certId);
            }
            if ("BinarySecurityToken".equals(tokenType)) {
                reference.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            } else if ("UsernameToken".equals(tokenType)) {
                reference.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
                signature.addKeyInfo((X509Certificate)cert);
            }
            signature.sign(privateKey);
        }
        catch (Exception e) {
            SAMLUtils.debug.error("WSSSignatureProvider: signWithBinaryTokenProfile Exception: ", (Throwable)e);
            throw new XMLSignatureException(e.getMessage());
        }
        return signature.getElement();
    }

    public boolean verifyWSSSignature(Document doc, String certAlias) throws XMLSignatureException {
        if (doc == null) {
            WSSUtils.debug.error("WSSSignatureProvider.verifyWSSSignature: document is null.");
            throw new XMLSignatureException(WSSUtils.bundle.getString("nullInput"));
        }
        try {
            NodeList aList;
            Element wsucontext = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            NodeList wsuNodes = XPathAPI.selectNodeList(doc, "//*[@wsu:Id]", wsucontext);
            if (wsuNodes != null && wsuNodes.getLength() != 0) {
                for (int i = 0; i < wsuNodes.getLength(); ++i) {
                    Element elem = (Element)wsuNodes.item(i);
                    String id = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    if (id == null || id.length() == 0) continue;
                    IdResolver.registerElementById((Element)elem, (String)id);
                }
            }
            if ((aList = XPathAPI.selectNodeList(doc, "//*[@AssertionID]")) != null && aList.getLength() != 0) {
                int len = aList.getLength();
                for (int i = 0; i < len; ++i) {
                    Element elem = (Element)aList.item(i);
                    String id = elem.getAttribute("AssertionID");
                    if (id == null || id.length() == 0) continue;
                    IdResolver.registerElementById((Element)elem, (String)id);
                }
            }
            Element nscontext = XMLUtils.createDSctx((Document)doc, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
            NodeList sigElements = XPathAPI.selectNodeList(doc, "//ds:Signature", nscontext);
            int sigElementsLength = sigElements.getLength();
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("WSSSignatureProvider.verifyWSSSignature: sigElements size = " + sigElements.getLength());
            }
            if (sigElementsLength == 0) {
                return false;
            }
            X509Certificate newcert = this.keystore.getX509Certificate(certAlias);
            PublicKey key = this.keystore.getPublicKey(certAlias);
            Element sigElement = null;
            for (int i = 0; i < sigElements.getLength(); ++i) {
                sigElement = (Element)sigElements.item(i);
                if (WSSUtils.debug.messageEnabled()) {
                    WSSUtils.debug.message("Sig(" + i + ") = " + com.sun.identity.shared.xml.XMLUtils.print((Node)sigElement));
                }
                XMLSignature signature = new XMLSignature(sigElement, "");
                signature.addResourceResolver((ResourceResolverSpi)new OfflineResolver());
                KeyInfo ki = signature.getKeyInfo();
                PublicKey pk = this.getX509PublicKey(doc, ki);
                if (pk != null) {
                    if (signature.checkSignatureValue(pk)) {
                        if (!WSSUtils.debug.messageEnabled()) continue;
                        WSSUtils.debug.message("verifyWSSSignature: Signature " + i + " verified");
                        continue;
                    }
                    if (WSSUtils.debug.messageEnabled()) {
                        WSSUtils.debug.message("verifyWSSSignature: Signature Verfication failed");
                    }
                    return false;
                }
                if (certAlias == null || certAlias.equals("")) {
                    if (WSSUtils.debug.messageEnabled()) {
                        WSSUtils.debug.message("verifyWSSSignature:Certificate Alias is null");
                    }
                    return false;
                }
                if (WSSUtils.debug.messageEnabled()) {
                    WSSUtils.debug.message("Could not find a KeyInfo, try to use certAlias");
                }
                if (newcert != null) {
                    if (signature.checkSignatureValue(newcert)) {
                        if (!WSSUtils.debug.messageEnabled()) continue;
                        WSSUtils.debug.message("verifyWSSSignature: Signature " + i + " verified");
                        continue;
                    }
                    return false;
                }
                if (key != null) {
                    if (signature.checkSignatureValue(key)) {
                        if (!WSSUtils.debug.messageEnabled()) continue;
                        WSSUtils.debug.message("verifyWSSSignature: Signature " + i + " verified");
                        continue;
                    }
                    return false;
                }
                WSSUtils.debug.error("Could not find public key based on certAlias to verify signature");
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            WSSUtils.debug.error("WSSSignatureProvider: verifyWSSSignature Exception: ", (Throwable)ex);
            throw new XMLSignatureException(ex.getMessage());
        }
    }

    private PublicKey getPublicKeyFromWSSToken(Document doc) {
        PublicKey pubKey = null;
        try {
            Element securityElement = (Element)doc.getDocumentElement().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security").item(0);
            if (securityElement == null) {
                return null;
            }
            Element nscontext = XMLUtils.createDSctx((Document)doc, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
            Element sigElement = (Element)XPathAPI.selectSingleNode(securityElement, "ds:Signature[1]", nscontext);
            Element keyinfo = (Element)sigElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0);
            Element str = (Element)keyinfo.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference").item(0);
            Element reference = (Element)keyinfo.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference").item(0);
            if (reference != null) {
                String id = reference.getAttribute("URI");
                id = id.substring(1);
                nscontext = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                Node n = XPathAPI.selectSingleNode(doc, "//*[@wsu:Id=\"" + id + "\"]", nscontext);
                if (n != null) {
                    SAMLUtils.debug.message("X509 Token");
                    String format = ((Element)n).getAttribute("ValueType");
                    NodeList children = n.getChildNodes();
                    n = children.item(0);
                    String certString = n.getNodeValue().trim();
                    pubKey = this.getPublicKey(this.getCertificate(certString, format));
                } else {
                    SAMLUtils.debug.message("SAML Token");
                    reference = (Element)XPathAPI.selectSingleNode(doc, "//*[@AssertionID=\"" + id + "\"]");
                    reference = (Element)reference.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0);
                    if (reference == null) {
                        throw new Exception(SAMLUtils.bundle.getString("nullKeyInfo"));
                    }
                    Element x509Data = (Element)reference.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Data").item(0);
                    if (x509Data != null) {
                        reference = (Element)x509Data.getChildNodes().item(0);
                        String certString = x509Data.getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("certString = " + certString);
                        }
                        return this.getPublicKey(this.getCertificate(certString, null));
                    }
                    pubKey = this.getPublicKeybyDSARSAkeyValue(doc, reference);
                }
            } else {
                SAMLUtils.debug.error("WSSSignatureProvider:getPublicKeyFromWSSToken: unknow Security Token Reference");
            }
        }
        catch (Exception e) {
            SAMLUtils.debug.error("WSSSignatureProvider:getPublicKeyFromWSSToken Exception: ", (Throwable)e);
        }
        return pubKey;
    }
}

