/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts.spi;

import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.xml.ws.api.security.trust.STSTokenProvider;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.saml.Advice;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.Attribute;
import com.sun.xml.wss.saml.AttributeStatement;
import com.sun.xml.wss.saml.AudienceRestriction;
import com.sun.xml.wss.saml.AudienceRestrictionCondition;
import com.sun.xml.wss.saml.AuthnContext;
import com.sun.xml.wss.saml.AuthnStatement;
import com.sun.xml.wss.saml.Conditions;
import com.sun.xml.wss.saml.KeyInfoConfirmationData;
import com.sun.xml.wss.saml.NameID;
import com.sun.xml.wss.saml.NameIdentifier;
import com.sun.xml.wss.saml.SAMLAssertionFactory;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.Subject;
import com.sun.xml.wss.saml.SubjectConfirmation;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAMSTSTokenProvider
implements STSTokenProvider {
    public void generateToken(IssuedTokenContext ctx) throws WSTrustException {
        STSUtils.debug.message("FAMSTSTokenProvider.generateToken called.");
        String issuer = ctx.getTokenIssuer();
        String appliesTo = ctx.getAppliesTo();
        String tokenType = ctx.getTokenType();
        String keyType = ctx.getKeyType();
        int tokenLifeSpan = (int)(ctx.getExpirationTime().getTime() - ctx.getCreationTime().getTime());
        String confirMethod = (String)ctx.getOtherProperties().get("samlConfirmationMethod");
        Map claimedAttrs = (Map)ctx.getOtherProperties().get("cliamedAttributes");
        WSTrustVersion wstVer = (WSTrustVersion)ctx.getOtherProperties().get("wstVersion");
        WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance((WSTrustVersion)wstVer);
        KeyInfo keyInfo = this.createKeyInfo(ctx);
        String assertionId = "uuid-" + UUID.randomUUID().toString();
        if (STSUtils.debug.messageEnabled()) {
            STSUtils.debug.message("FAMSTSTokenProvider.tokenType : " + tokenType);
        }
        Assertion assertion = null;
        if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            assertion = this.createSAML11Assertion(wstVer, tokenLifeSpan, confirMethod, assertionId, issuer, appliesTo, keyInfo, claimedAttrs, keyType);
        } else if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            String authnCtx = (String)ctx.getOtherProperties().get("authnContext");
            assertion = this.createSAML20Assertion(wstVer, tokenLifeSpan, confirMethod, assertionId, issuer, appliesTo, keyInfo, claimedAttrs, keyType, authnCtx);
        } else {
            STSUtils.debug.error("FAMSTSTokenProvider.generateToken ERROR : UNSUPPORTED_TOKEN_TYPE");
            throw new WSTrustException(LogStringsMessages.WST_0031_UNSUPPORTED_TOKEN_TYPE((Object)tokenType, (Object)appliesTo));
        }
        X509Certificate stsCert = (X509Certificate)ctx.getOtherProperties().get("stsCertificate");
        PrivateKey stsPrivKey = (PrivateKey)ctx.getOtherProperties().get("stsPrivateKey");
        Element signedAssertion = null;
        try {
            signedAssertion = assertion.sign(stsCert, stsPrivKey, true);
        }
        catch (SAMLException ex) {
            STSUtils.debug.error("FAMSTSTokenProvider.generateToken ERROR : ERROR_CREATING_SAML_ASSERTION : ", (Throwable)ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), (Throwable)ex);
        }
        if (STSUtils.debug.messageEnabled()) {
            STSUtils.debug.message("FAMSTSTokenProvider.signedAssertion : " + XMLUtils.print((Node)signedAssertion));
        }
        ctx.setSecurityToken((Token)new GenericToken(signedAssertion));
        String valueType = null;
        if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
        } else if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
        }
        SecurityTokenReference samlReference = WSTrustUtil.createSecurityTokenReference((String)assertionId, (String)valueType);
        RequestedAttachedReference raRef = eleFac.createRequestedAttachedReference(samlReference);
        RequestedUnattachedReference ruRef = eleFac.createRequestedUnattachedReference(samlReference);
        ctx.setAttachedSecurityTokenReference((Token)samlReference);
        ctx.setUnAttachedSecurityTokenReference((Token)samlReference);
    }

    public void isValideToken(IssuedTokenContext ctx) throws WSTrustException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void renewToken(IssuedTokenContext ctx) throws WSTrustException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void invalidateToken(IssuedTokenContext ctx) throws WSTrustException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Assertion createSAML11Assertion(WSTrustVersion wstVer, int lifeSpan, String confirMethod, String assertionId, String issuer, String appliesTo, KeyInfo keyInfo, Map<QName, List<String>> claimedAttrs, String keyType) throws WSTrustException {
        Assertion assertion = null;
        try {
            AttributeStatement statement;
            SAMLAssertionFactory samlFac = SAMLAssertionFactory.newInstance((String)"Saml1.1");
            TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
            GregorianCalendar issuerInst = new GregorianCalendar(utcTimeZone);
            GregorianCalendar notOnOrAfter = new GregorianCalendar(utcTimeZone);
            notOnOrAfter.add(14, lifeSpan);
            ArrayList<AudienceRestrictionCondition> arc = null;
            ArrayList<String> confirmMethods = new ArrayList<String>();
            if (confirMethod == null) {
                if (keyType.equals(wstVer.getBearerKeyTypeURI())) {
                    confirMethod = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
                    if (appliesTo != null) {
                        arc = new ArrayList<AudienceRestrictionCondition>();
                        ArrayList<String> au = new ArrayList<String>();
                        au.add(appliesTo);
                        arc.add(samlFac.createAudienceRestrictionCondition(au));
                    }
                } else {
                    confirMethod = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
                }
            }
            Element keyInfoEle = null;
            if (keyInfo != null && !wstVer.getBearerKeyTypeURI().equals(keyType)) {
                keyInfoEle = keyInfo.getElement();
            }
            confirmMethods.add(confirMethod);
            SubjectConfirmation subjectConfirm = samlFac.createSubjectConfirmation(confirmMethods, null, keyInfoEle);
            Conditions conditions = samlFac.createConditions(issuerInst, notOnOrAfter, null, arc, null);
            Advice advice = samlFac.createAdvice(null, null, null);
            Subject subj = null;
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            Set<Map.Entry<QName, List<String>>> entries = claimedAttrs.entrySet();
            for (Map.Entry<QName, List<String>> entry : entries) {
                QName attrKey = entry.getKey();
                List<String> values = entry.getValue();
                if (values == null || values.size() <= 0) continue;
                if ("NameID".equals(attrKey.getLocalPart()) && subj == null) {
                    NameIdentifier nameId = samlFac.createNameIdentifier(values.get(0), attrKey.getNamespaceURI(), null);
                    subj = samlFac.createSubject(nameId, subjectConfirm);
                    continue;
                }
                Attribute attr = samlFac.createAttribute(attrKey.getLocalPart(), attrKey.getNamespaceURI(), values);
                attrs.add(attr);
            }
            ArrayList<AttributeStatement> statements = new ArrayList<AttributeStatement>();
            if (attrs.isEmpty()) {
                statement = samlFac.createAuthenticationStatement(null, issuerInst, subj, null, null);
                statements.add(statement);
            } else {
                statement = samlFac.createAttributeStatement(subj, attrs);
                statements.add(statement);
            }
            assertion = samlFac.createAssertion(assertionId, issuer, issuerInst, conditions, advice, statements);
        }
        catch (SAMLException ex) {
            STSUtils.debug.error("FAMSTSTokenProvider.createSAML11Assertion : ERROR_CREATING_SAML_ASSERTION : ", (Throwable)ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), (Throwable)ex);
        }
        catch (XWSSecurityException ex) {
            STSUtils.debug.error("FAMSTSTokenProvider.createSAML11Assertion : ERROR_CREATING_SAML_ASSERTION : ", (Throwable)ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), (Throwable)ex);
        }
        return assertion;
    }

    protected Assertion createSAML20Assertion(WSTrustVersion wstVer, int lifeSpan, String confirMethod, String assertionId, String issuer, String appliesTo, KeyInfo keyInfo, Map<QName, List<String>> claimedAttrs, String keyType, String authnCtx) throws WSTrustException {
        Assertion assertion = null;
        try {
            SAMLAssertionFactory samlFac = SAMLAssertionFactory.newInstance((String)"Saml2.0");
            TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
            GregorianCalendar issueInst = new GregorianCalendar(utcTimeZone);
            GregorianCalendar notOnOrAfter = new GregorianCalendar(utcTimeZone);
            notOnOrAfter.add(14, lifeSpan);
            ArrayList<AudienceRestriction> arc = null;
            KeyInfoConfirmationData keyInfoConfData = null;
            if (confirMethod == null) {
                if (keyType.equals(wstVer.getBearerKeyTypeURI())) {
                    confirMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
                    if (appliesTo != null) {
                        arc = new ArrayList<AudienceRestriction>();
                        ArrayList<String> au = new ArrayList<String>();
                        au.add(appliesTo);
                        arc.add(samlFac.createAudienceRestriction(au));
                    }
                } else {
                    confirMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
                    if (keyInfo != null) {
                        keyInfoConfData = samlFac.createKeyInfoConfirmationData(keyInfo.getElement());
                    }
                }
            }
            Conditions conditions = samlFac.createConditions(issueInst, notOnOrAfter, null, arc, null, null);
            SubjectConfirmation subjectConfirm = samlFac.createSubjectConfirmation(null, keyInfoConfData, confirMethod);
            Subject subj = null;
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            Set<Map.Entry<QName, List<String>>> entries = claimedAttrs.entrySet();
            for (Map.Entry<QName, List<String>> entry : entries) {
                QName attrKey = entry.getKey();
                List<String> values = entry.getValue();
                if (values == null || values.size() <= 0) continue;
                if ("NameID".equals(attrKey.getLocalPart()) && subj == null) {
                    NameID nameId = samlFac.createNameID(values.get(0), attrKey.getNamespaceURI(), null);
                    subj = samlFac.createSubject(nameId, subjectConfirm);
                    continue;
                }
                Attribute attr = samlFac.createAttribute(attrKey.getLocalPart(), values);
                attrs.add(attr);
            }
            ArrayList<Object> statements = new ArrayList<Object>();
            if (attrs.isEmpty()) {
                AuthnContext ctx = samlFac.createAuthnContext(authnCtx, null);
                AuthnStatement statement = samlFac.createAuthnStatement(issueInst, null, ctx);
                statements.add(statement);
            } else {
                AttributeStatement statement = samlFac.createAttributeStatement(attrs);
                statements.add(statement);
            }
            NameID issuerID = samlFac.createNameID(issuer, null, null);
            assertion = samlFac.createAssertion(assertionId, issuerID, issueInst, conditions, null, subj, statements);
        }
        catch (SAMLException ex) {
            STSUtils.debug.error("FAMSTSTokenProvider.createSAML20Assertion  ERROR : ERROR_CREATING_SAML_ASSERTION : ", (Throwable)ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), (Throwable)ex);
        }
        catch (XWSSecurityException ex) {
            STSUtils.debug.error("FAMSTSTokenProvider.createSAML20Assertion  ERROR : ERROR_CREATING_SAML_ASSERTION : ", (Throwable)ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), (Throwable)ex);
        }
        return assertion;
    }

    private KeyInfo createKeyInfo(IssuedTokenContext ctx) throws WSTrustException {
        Element kiEle = (Element)ctx.getOtherProperties().get("ConfirmationKeyInfo");
        if (kiEle != null) {
            try {
                return new KeyInfo(kiEle, null);
            }
            catch (XMLSecurityException ex) {
                STSUtils.debug.error("FAMSTSTokenProvider.createKeyInfo : UNABLE_GET_CLIENT_CERT : ", (Throwable)ex);
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), (Throwable)ex);
            }
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            doc = docFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            STSUtils.debug.error("FAMSTSTokenProvider.createKeyInfo : ERROR_CREATING_DOCFACTORY : ", (Throwable)ex);
            throw new WSTrustException(LogStringsMessages.WST_0039_ERROR_CREATING_DOCFACTORY(), (Throwable)ex);
        }
        String appliesTo = ctx.getAppliesTo();
        KeyInfo keyInfo = new KeyInfo(doc);
        String keyType = ctx.getKeyType();
        WSTrustVersion wstVer = (WSTrustVersion)ctx.getOtherProperties().get("wstVersion");
        if (wstVer.getSymmetricKeyTypeURI().equals(keyType)) {
            byte[] key = ctx.getProofKey();
            try {
                EncryptedKey encKey = WSTrustUtil.encryptKey((Document)doc, (byte[])key, (X509Certificate)((X509Certificate)ctx.getOtherProperties().get("tagetedServiceCertificate")));
                keyInfo.add(encKey);
            }
            catch (Exception ex) {
                STSUtils.debug.error("FAMSTSTokenProvider.createKeyInfo : ERROR_ENCRYPT_PROOFKEY : ", (Throwable)ex);
                throw new WSTrustException(LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY((Object)appliesTo), (Throwable)ex);
            }
        }
        if (wstVer.getPublicKeyTypeURI().equals(keyType)) {
            X509Data x509data = new X509Data(doc);
            try {
                x509data.addCertificate(ctx.getRequestorCertificate());
            }
            catch (XMLSecurityException ex) {
                STSUtils.debug.error("FAMSTSTokenProvider.createKeyInfo : UNABLE_GET_CLIENT_CERT : ", (Throwable)ex);
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), (Throwable)ex);
            }
            keyInfo.add(x509data);
        }
        return keyInfo;
    }
}

