/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts.config;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.org.apache.xml.internal.security.Init;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;

public class FAMCallbackHandler
implements CallbackHandler {
    protected KeyProvider keystore = null;
    private String certAlias;

    public FAMCallbackHandler(String certAlias) {
        this.certAlias = certAlias;
    }

    public void handle(Callback[] callbacks) {
        try {
            String kprovider = SystemConfigurationUtil.getProperty((String)"com.sun.identity.saml.xmlsig.keyprovider.class", (String)"com.sun.identity.saml.xmlsig.JKSKeyProvider");
            this.keystore = (KeyProvider)Class.forName(kprovider).newInstance();
        }
        catch (Exception e) {
            STSUtils.debug.error("FAMCallbackHandler: get keystore error", (Throwable)e);
        }
        try {
            for (Callback cb : callbacks) {
                if (cb instanceof EncryptionKeyCallback) {
                    EncryptionKeyCallback eb = (EncryptionKeyCallback)cb;
                    EncryptionKeyCallback.AliasX509CertificateRequest x509Req = (EncryptionKeyCallback.AliasX509CertificateRequest)eb.getRequest();
                    String alias = x509Req.getAlias();
                    X509Certificate cert = this.keystore.getX509Certificate(alias);
                    x509Req.setX509Certificate(cert);
                    continue;
                }
                if (!(cb instanceof SignatureKeyCallback)) continue;
                SignatureKeyCallback sb = (SignatureKeyCallback)cb;
                SignatureKeyCallback.DefaultPrivKeyCertRequest privKey = (SignatureKeyCallback.DefaultPrivKeyCertRequest)sb.getRequest();
                privKey.setX509Certificate(this.keystore.getX509Certificate(this.certAlias));
                privKey.setPrivateKey(this.keystore.getPrivateKey(this.certAlias));
            }
        }
        catch (Exception ex) {
            STSUtils.debug.error("FAMCallbackHandler: handle callbacks error", (Throwable)ex);
        }
    }

    static {
        Init.init();
    }
}

