/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.AMTokenProvider;
import com.sun.identity.wss.security.BinarySecurityToken;
import com.sun.identity.wss.security.KeyIdentifier;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityTokenReference;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class STRTransform
extends TransformSpi {
    public static final String STR_TRANSFORM_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    private static String XMLNS = "xmlns=";
    private static Debug debug = WSSUtils.debug;

    protected String engineGetURI() {
        return STR_TRANSFORM_URI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        debug.message("STRTransform.enginePerformTransform:: Start");
        Document doc = this._transformObject.getDocument();
        Object str = null;
        if (!input.isElement()) {
            debug.error("STRTransform.enginePerformTransform:: Input is not  an element");
            throw new CanonicalizationException("inputNotAnElement");
        }
        Element element = (Element)input.getSubNode();
        if (!"SecurityTokenReference".equals(element.getLocalName())) {
            debug.error("STRTransform.enginePerformTransform:: input must be security token reference");
            throw new IOException("invalidInputElement");
        }
        Element dereferencedToken = null;
        SecurityTokenReference ref = null;
        try {
            ref = new SecurityTokenReference(element);
            dereferencedToken = this.dereferenceSTR(doc, ref);
        }
        catch (SecurityException se) {
            debug.error("STRTransform.enginePerformTransform:: error", (Throwable)se);
            throw new TransformationException("transformfailed");
        }
        String canonAlgo = this.getCanonicalizationAlgo();
        Canonicalizer canon = Canonicalizer.getInstance(canonAlgo);
        byte[] buf = canon.canonicalizeSubtree(dereferencedToken, "#default");
        StringBuffer bf = new StringBuffer(new String(buf));
        String bf1 = bf.toString();
        int lt = bf1.indexOf("<");
        int gt = bf1.indexOf(">");
        int idx = bf1.indexOf(XMLNS);
        if (idx < 0 || idx > gt) {
            idx = bf1.indexOf(" ");
            bf.insert(idx + 1, "xmlns=\"\" ");
            bf1 = bf.toString();
        }
        return new XMLSignatureInput(bf1.getBytes());
    }

    private Element dereferenceSTR(Document doc, SecurityTokenReference secRef) throws SecurityException {
        debug.message("STRTransform.deferenceSTR:: start");
        Element tokenElement = null;
        String refType = secRef.getReferenceType();
        if ("DirectReference".equals(refType)) {
            debug.message("STRTRansform.deferenceSTR:: Direct reference");
            tokenElement = secRef.getTokenElement(doc);
        } else if ("X509IssuerSerialRef".equals(refType)) {
            debug.message("STRTRansform.deferenceSTR:: X509 data reference");
            X509Data x509Data = secRef.getX509IssuerSerial();
            X509Certificate cert = AMTokenProvider.getX509Certificate(x509Data);
            tokenElement = this.createBinaryToken(doc, cert);
        } else if ("KeyIdentifierRef".equals(refType)) {
            debug.message("STRTRansform.deferenceSTR:: keyidentifier reference");
            KeyIdentifier keyIdentifier = secRef.getKeyIdentifier();
            String valueType = keyIdentifier.getValueType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType)) {
                tokenElement = keyIdentifier.getTokenElement(doc);
            } else {
                X509Certificate cert = keyIdentifier.getX509Certificate();
                tokenElement = this.createBinaryToken(doc, cert);
            }
        }
        return tokenElement;
    }

    private Element createBinaryToken(Document doc, X509Certificate cert) throws SecurityException {
        BinarySecurityToken token = new BinarySecurityToken(cert, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        Element tokenE = token.toDocumentElement();
        doc.importNode(tokenE, true);
        return tokenE;
    }

    private String getCanonicalizationAlgo() {
        String canonAlgo = null;
        if (this._transformObject.length("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "TransformationParameters") == 1) {
            Node tmpE = XMLUtils.getChildNode((Node)this._transformObject.getElement(), (String)"wsse:TransformationParameters");
            Element canonElem = (Element)WSSUtils.getDirectChild(tmpE, "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#");
            canonAlgo = canonElem.getAttribute("Algorithm");
        }
        return canonAlgo;
    }

    public boolean wantsOctetStream() {
        return true;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    static {
        try {
            Transform.register(STR_TRANSFORM_URI, STRTransform.class.getName());
        }
        catch (Exception e) {
            debug.message("STRTransform.static already registered");
        }
    }
}

