/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.SubjectConfirmation;
import com.sun.identity.wss.security.SAML2Token;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityPrincipal;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.WSSUtils;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.Subject;
import org.w3c.dom.Element;

public class SAML2TokenUtils {
    public static X509Certificate getCertificate(SecurityToken securityToken) throws SecurityException {
        SAML2Token saml2Token = (SAML2Token)securityToken;
        if (saml2Token.isSenderVouches()) {
            return null;
        }
        Assertion assertion = saml2Token.getAssertion();
        Element keyInfo = SAML2TokenUtils.getKeyInfo(assertion);
        return WSSUtils.getCertificate(keyInfo);
    }

    public static Element getKeyInfo(Assertion assertion) {
        try {
            com.sun.identity.saml2.assertion.Subject subj = assertion.getSubject();
            List list = subj.getSubjectConfirmation();
            SubjectConfirmation subjConfirmation = (SubjectConfirmation)list.get(0);
            List content = subjConfirmation.getSubjectConfirmationData().getContent();
            if (content == null || content.isEmpty()) {
                WSSUtils.debug.error("SAMLTokenUtils.getKeyInfo: KeyInfo not found");
                return null;
            }
            return (Element)content.get(0);
        }
        catch (Exception e) {
            WSSUtils.debug.error("SAML2TokenUtils.getKeyInfo Exception: ", (Throwable)e);
            return null;
        }
    }

    public static boolean validateAssertion(Assertion assertion, Subject subject) throws SecurityException {
        if (assertion.getConditions() != null && !assertion.getConditions().checkDateValidity(System.currentTimeMillis())) {
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("SAML2TokenUtils.validateAssertionToken:: assertion time is not valid");
            }
            return false;
        }
        com.sun.identity.saml2.assertion.Subject sub = assertion.getSubject();
        if (sub == null) {
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("SAML2TokenUtils.validateAssertio:: Assertion does not have subject");
            }
            return false;
        }
        NameID ni = sub.getNameID();
        if (ni == null) {
            return false;
        }
        SecurityPrincipal principal = new SecurityPrincipal(ni.getValue());
        subject.getPrincipals().add(principal);
        WSSUtils.setRoles(subject, ni.getValue());
        return true;
    }
}

