/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.enterprise.registration.RegistrationAccount;
import com.sun.enterprise.registration.RegistrationAccountConfig;
import com.sun.enterprise.registration.RegistrationAccountFactory;
import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.RegistrationService;
import com.sun.enterprise.registration.RegistrationServiceConfig;
import com.sun.enterprise.registration.RegistrationServiceFactory;
import com.sun.enterprise.util.RegistrationUtil;
import com.sun.identity.workflow.Task;
import com.sun.identity.workflow.WorkflowException;
import com.sun.scn.client.comm.RegistrationWrapper;
import com.sun.scn.client.util.InventoryEnvironmentTarget;
import com.sun.scn.dao.Domain;
import com.sun.scn.servicetags.AuthenticationCredential;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RegisterProduct
extends Task {
    public String execute(Locale locale, Map params) throws WorkflowException {
        this.validateParameters(params);
        String newAccount = this.getString(params, "newAccount");
        if (newAccount.equals("true")) {
            String userName = this.getString(params, "tfUserName");
            String emailAddr = this.getString(params, "tfEmailAddr");
            if (userName == null || userName.length() == 0) {
                userName = emailAddr;
            }
            String pswd = this.getString(params, "tfPswd");
            String confirmPswd = this.getString(params, "tfCfrmPswd");
            String proxyHost = this.getString(params, "tfProxyHost");
            String proxyPort = this.getString(params, "tfProxyPort");
            String firstName = this.getString(params, "tfFirstName");
            String lastName = this.getString(params, "tfLastName");
            String country = this.getString(params, "tfCountry");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("email", emailAddr);
            map.put("password", pswd);
            map.put("country", country);
            map.put("userID", userName);
            map.put("firstName", firstName);
            map.put("lastName", lastName);
            Object[] accountParams = new Object[]{map};
            try {
                RegistrationService regService = this.getRegServiceForRegister(proxyHost, proxyPort);
                if (regService == null) {
                    throw new WorkflowException("reg-no-service", null);
                }
                RegistrationAccountConfig accountConfig = new RegistrationAccountConfig("com.sun.enterprise.registration.SOAccount", accountParams);
                RegistrationAccount account = RegistrationAccountFactory.getInstance().getRegistrationAccount(accountConfig);
                regService.createRegistrationAccount(account);
                regService.register(account);
            }
            catch (RegistrationException re) {
                Object[] param = new Object[]{re.getMessage()};
                throw new WorkflowException("reg-create-soa-err", param);
            }
            catch (Exception ex) {
                Object[] param = new Object[]{ex.getMessage()};
                throw new WorkflowException("reg-process-exc", param);
            }
            return "localized msg1: new user account; product is registered.";
        }
        String userName = this.getString(params, "tfExistUserName");
        String pswd = this.getString(params, "tfExistPswd");
        String proxyHost = this.getString(params, "tfExistProxyHost");
        String proxyPort = this.getString(params, "tfExistProxyPort");
        String domain = this.getString(params, "tfDomain");
        if (domain != null && domain.length() > 0) {
            domain = domain.trim();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userID", userName);
        map.put("password", pswd);
        Object[] accountParams = new Object[]{map};
        StringBuffer domainStrb = new StringBuffer();
        List domains = null;
        RegistrationAccount account = null;
        RegistrationService regService = null;
        try {
            String REGISTRATOR_ID = "FederatedAccessManager";
            RegistrationWrapper regWrapper = new RegistrationWrapper(REGISTRATOR_ID);
            RegistrationAccountConfig accountConfig = new RegistrationAccountConfig("com.sun.enterprise.registration.SOAccount", accountParams);
            account = RegistrationAccountFactory.getInstance().getRegistrationAccount(accountConfig);
            regService = this.getRegServiceForRegister(proxyHost, proxyPort);
            if (regService == null) {
                throw new WorkflowException("reg-no-service-waccount");
            }
            regWrapper.setInventoryEnvironmentTarget(InventoryEnvironmentTarget.valueOf((String)"DEVALPHA22"));
            AuthenticationCredential ac = regService.getAuthCredential(account);
            domains = regWrapper.getDomains(ac);
        }
        catch (Exception ex) {
            Object[] param = new Object[]{ex.getMessage()};
            throw new WorkflowException("reg-execute-registration-exc", param);
        }
        if (domains == null || domains.isEmpty()) {
            throw new WorkflowException("reg-execute-no-domains");
        }
        if (domain != null && domain.length() > 0) {
            Domain dom = null;
            boolean foundDomain = false;
            if (domains != null && !domains.isEmpty()) {
                Iterator it = domains.iterator();
                while (it.hasNext()) {
                    dom = (Domain)it.next();
                    if (!domain.equals(dom.getDomainName())) continue;
                    foundDomain = true;
                    break;
                }
                if (foundDomain) {
                    try {
                        regService.register(account, dom);
                    }
                    catch (Exception ex) {
                        Object[] param = new Object[]{domain};
                        throw new WorkflowException("reg-to-domain-error", param);
                    }
                    return "localized msg2: Product has been registered to the Domain '" + domain + "'.";
                }
                Object[] param = new Object[]{domain};
                throw new WorkflowException("reg-domain-not-found", param);
            }
            throw new WorkflowException("reg-no-domains");
        }
        if (domains.size() == 1) {
            try {
                regService.register(account);
            }
            catch (Exception ex) {
                Object[] param = new Object[]{ex.getMessage()};
                throw new WorkflowException("reg-to-def-domain-error", param);
            }
            return "localized msg: the product is registered.";
        }
        Iterator it = domains.iterator();
        while (it.hasNext()) {
            Domain dom = (Domain)it.next();
            domainStrb.append(dom.getDomainName());
            if (!it.hasNext()) continue;
            domainStrb.append("|");
        }
        return "<selectdomain>" + domainStrb.toString();
    }

    private void validateParameters(Map params) throws WorkflowException {
        String newAccount = this.getString(params, "newAccount");
        if (newAccount.equals("false")) {
            String userName = this.getString(params, "tfExistUserName");
            String pswd = this.getString(params, "tfExistPswd");
            if (userName == null || userName.length() == 0 || pswd == null || pswd.length() == 0) {
                throw new WorkflowException("reg-usrname-pswd-rqd");
            }
        } else {
            String userName = this.getString(params, "tfUserName");
            String pswd = this.getString(params, "tfPswd");
            String emailAddr = this.getString(params, "tfEmailAddr");
            String confirmPswd = this.getString(params, "tfCfrmPswd");
            String country = this.getString(params, "tfCountry");
            if (!(userName != null && userName.length() != 0 || emailAddr != null && emailAddr.length() != 0)) {
                throw new WorkflowException("reg-emailadr-no-username");
            }
            if (pswd == null || pswd.length() == 0) {
                throw new WorkflowException("reg-pswd-req");
            }
            if (confirmPswd == null || confirmPswd.length() == 0) {
                throw new WorkflowException("reg-cfm-pswd-req");
            }
            if (!pswd.equals(confirmPswd)) {
                throw new WorkflowException("reg-pswd-no-match");
            }
        }
    }

    private RegistrationService getRegServiceForRegister(String proxy, String port) throws WorkflowException {
        if (proxy != null && proxy.length() > 0 && port != null && port.length() > 0) {
            return this.getRegistrationService(proxy, Integer.valueOf(port));
        }
        return this.getRegistrationService();
    }

    private RegistrationService getRegistrationService(String proxyHost, Integer proxyPort) throws WorkflowException {
        try {
            File registryFile = RegistrationUtil.getServiceTagRegistry();
            Object[] params = new Object[]{registryFile, proxyHost, proxyPort};
            RegistrationServiceConfig config = new RegistrationServiceConfig("com.sun.enterprise.registration.SysnetRegistrationService", params);
            RegistrationService registrationService = RegistrationServiceFactory.getInstance().getRegistrationService(config);
            return registrationService;
        }
        catch (Exception ex) {
            Object[] param = new Object[]{proxyHost, ex.getMessage()};
            throw new WorkflowException("reg-get-reg-svc-proxy-error", param);
        }
    }

    private RegistrationService getRegistrationService() throws WorkflowException {
        try {
            File registryFile = RegistrationUtil.getServiceTagRegistry();
            Object[] params = new Object[]{registryFile};
            RegistrationServiceConfig config = new RegistrationServiceConfig("com.sun.enterprise.registration.SysnetRegistrationService", params);
            RegistrationService registrationService = RegistrationServiceFactory.getInstance().getRegistrationService(config);
            return registrationService;
        }
        catch (Exception ex) {
            Object[] param = new Object[]{ex.getMessage()};
            throw new WorkflowException("reg-get-reg-svc-error", param);
        }
    }
}

