/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.cot.COTException;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.workflow.AddProviderToCOT;
import com.sun.identity.workflow.CreateSAML2HostedProviderTemplate;
import com.sun.identity.workflow.ImportSAML2MetaData;
import com.sun.identity.workflow.Task;
import com.sun.identity.workflow.WorkflowException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBException;

public class CreateRemoteSP
extends Task {
    public String execute(Locale locale, Map params) throws WorkflowException {
        this.validateParameters(params);
        String realm = this.getString(params, "realm");
        String metadataFile = this.getString(params, "metadata");
        String metadata = CreateRemoteSP.getContent(metadataFile, locale);
        String extendedMeta = null;
        List attrMapping = this.getAttributeMapping(params);
        if (!attrMapping.isEmpty()) {
            try {
                EntityDescriptorElement e = ImportSAML2MetaData.getEntityDescriptorElement(metadata);
                String eId = e.getEntityID();
                String metaAlias = CreateRemoteSP.generateMetaAliasForSP(realm);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("sp", metaAlias);
                extendedMeta = CreateSAML2HostedProviderTemplate.createExtendedDataTemplate(eId, map, null, false);
            }
            catch (SAML2MetaException ex) {
                throw new WorkflowException(ex.getMessage());
            }
            catch (JAXBException ex) {
                throw new WorkflowException(ex.getMessage());
            }
        }
        String[] results = ImportSAML2MetaData.importData(realm, metadata, extendedMeta);
        String entityId = results[1];
        String cot = this.getString(params, "cot");
        if (cot != null && cot.length() > 0) {
            try {
                AddProviderToCOT.addToCOT(realm, cot, entityId);
            }
            catch (COTException e) {
                throw new WorkflowException(e.getMessage());
            }
        }
        try {
            if (!attrMapping.isEmpty()) {
                SAML2MetaManager manager = new SAML2MetaManager();
                EntityConfigElement config = manager.getEntityConfig(realm, entityId);
                SPSSOConfigElement ssoConfig = manager.getSPSSOConfig(realm, entityId);
                Map attribConfig = SAML2MetaUtils.getAttributes((BaseConfigType)ssoConfig);
                List mappedAttributes = (List)attribConfig.get("attributeMap");
                mappedAttributes.addAll(attrMapping);
                manager.setEntityConfig(realm, config);
            }
        }
        catch (SAML2MetaException e) {
            throw new WorkflowException(e.getMessage());
        }
        return CreateRemoteSP.getMessage("sp.configured", locale);
    }

    private void validateParameters(Map params) throws WorkflowException {
        String metadata = this.getString(params, "metadata");
        if (metadata == null || metadata.trim().length() == 0) {
            throw new WorkflowException("meta-data-required", null);
        }
        String realm = this.getString(params, "realm");
        if (realm == null || realm.trim().length() == 0) {
            throw new WorkflowException("missing-realm", null);
        }
    }
}

