/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.cot.COTException;
import com.sun.identity.workflow.AddProviderToCOT;
import com.sun.identity.workflow.ImportSAML2MetaData;
import com.sun.identity.workflow.Task;
import com.sun.identity.workflow.WorkflowException;
import java.util.Locale;
import java.util.Map;

public class CreateRemoteIDP
extends Task {
    public String execute(Locale locale, Map params) throws WorkflowException {
        this.validateParameters(params);
        String realm = this.getString(params, "realm");
        String metadataFile = this.getString(params, "metadata");
        String metadata = CreateRemoteIDP.getContent(metadataFile, locale);
        String[] results = ImportSAML2MetaData.importData(realm, metadata, null);
        String cot = this.getString(params, "cot");
        if (cot != null && cot.length() > 0) {
            try {
                String entityId = results[1];
                AddProviderToCOT.addToCOT(realm, cot, entityId);
            }
            catch (COTException e) {
                throw new WorkflowException(e.getMessage());
            }
        }
        return CreateRemoteIDP.getMessage("idp.configured", locale);
    }

    private void validateParameters(Map params) throws WorkflowException {
        String metadata = this.getString(params, "metadata");
        if (metadata == null || metadata.trim().length() == 0) {
            throw new WorkflowException("meta-data-required", null);
        }
        String realm = this.getString(params, "realm");
        if (realm == null || realm.trim().length() == 0) {
            throw new WorkflowException("missing-realm", null);
        }
    }
}

