/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup.plugin;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.saml.common.SAMLSiteID;
import com.sun.identity.setup.ConfiguratorPlugin;
import com.sun.identity.setup.ServicesDefaultValues;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

public class FederationPlugin
implements ConfiguratorPlugin {
    private static final String ATTR_KEY_SAML_SITEID = "SAML_SITEID";

    public void reinitConfiguratioFile(String baseDir) {
    }

    public void doPostConfiguration(ServletContext servletCtx, SSOToken adminSSOToken) {
        this.setXSLFiles(servletCtx);
        this.setAuthModules(adminSSOToken);
        this.setSAMLSiteID(adminSSOToken);
    }

    private void setSAMLSiteID(SSOToken adminSSOToken) {
        try {
            String siteID;
            int idPos;
            ServiceSchemaManager mgr = new ServiceSchemaManager("iPlanetAMSAMLService", adminSSOToken);
            ServiceSchema ss = mgr.getSchema(SchemaType.GLOBAL);
            Map values = ss.getAttributeDefaults();
            Set siteIDs = (Set)values.get("iplanet-am-saml-siteid-issuername-list");
            if (siteIDs != null && !siteIDs.isEmpty() && (idPos = (siteID = (String)siteIDs.iterator().next()).indexOf("=SAML_SITEID|")) != -1) {
                Map defaults = ServicesDefaultValues.getDefaultValues();
                String protocol = (String)defaults.get("SERVER_PROTO");
                String hostname = (String)defaults.get("SERVER_HOST");
                String port = (String)defaults.get("SERVER_PORT");
                String encoded = SAMLSiteID.generateSourceID((String)(protocol + "://" + hostname + ":" + port));
                siteIDs.remove(siteID);
                siteID = siteID.substring(0, idPos + 1) + encoded + siteID.substring(idPos + ATTR_KEY_SAML_SITEID.length() + 1);
                siteIDs.add(siteID);
                ss.setAttributeDefaults(values);
            }
        }
        catch (SSOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void setAuthModules(SSOToken adminSSOToken) {
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager("iPlanetAMAuthService", adminSSOToken);
            ServiceSchema ss = mgr.getSchema(SchemaType.GLOBAL);
            Map values = ss.getAttributeDefaults();
            Set modules = (Set)values.get("iplanet-am-auth-authenticators");
            modules.add("com.sun.identity.authentication.modules.federation.Federation");
            modules.add("com.sun.identity.authentication.modules.sae.SAE");
            ss.setAttributeDefaults(values);
        }
        catch (SSOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void setXSLFiles(ServletContext servletCtx) {
        try {
            Map values = ServicesDefaultValues.getDefaultValues();
            String baseDir = (String)values.get("BASE_DIR");
            String deployURI = (String)values.get("SERVER_URI");
            String dir = baseDir + "/" + deployURI + "/lib";
            File file = new File(dir);
            file.mkdirs();
            this.writeToFile(dir + "/is-html.xsl", this.getWebResource("/WEB-INF/classes/is-html.xsl", servletCtx));
            this.writeToFile(dir + "/is-wml.xsl", this.getWebResource("/WEB-INF/classes/is-wml.xsl", servletCtx));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWebResource(String fileName, ServletContext servletCtx) throws IOException {
        InputStreamReader fin = new InputStreamReader(servletCtx.getResourceAsStream(fileName));
        StringBuffer sbuf = new StringBuffer();
        try {
            int len;
            char[] cbuf = new char[1024];
            while ((len = fin.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
            }
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception ex) {}
            }
        }
        return sbuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String fileName, String content) throws IOException {
        FileWriter fout = null;
        try {
            fout = new FileWriter(fileName);
            fout.write(content);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception ex) {}
            }
        }
    }
}

