/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.setup.ClientConfiguratorFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class SetupClientWARSamples {
    private static final String TAG_SERVER_PROTOCOL = "SERVER_PROTOCOL";
    private static final String TRUST_ALL_CERTS = "com.iplanet.am.jssproxy.trustAllServerCerts=true\n";
    ServletContext servletContext;

    public SetupClientWARSamples(ServletContext context) {
        this.servletContext = context;
    }

    public void createAMConfigProperties(String configFile, String templateFile, Properties properties) throws IOException {
        URL url;
        String content = this.getFileContent(templateFile);
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            String tag = (String)i.next();
            content = content.replaceAll("@" + tag + "@", (String)properties.get(tag));
        }
        String protocol = (String)properties.get(TAG_SERVER_PROTOCOL);
        if (protocol.equalsIgnoreCase("https")) {
            content = content + TRUST_ALL_CERTS;
        }
        if ((url = this.servletContext.getResource("/WEB-INF/lib/openssoclientsdk.jar")) != null) {
            String keystoreLocation = url.toString().substring(5);
            int index = keystoreLocation.indexOf("WEB-INF");
            keystoreLocation = keystoreLocation.substring(0, index - 1);
            content = content.replaceAll("@BASE_DIR@", keystoreLocation);
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(configFile));
        out.write(content);
        out.close();
    }

    private String getFileContent(String fileName) throws IOException {
        InputStream in = this.servletContext.getResourceAsStream(fileName);
        if (in == null) {
            throw new IOException("Unable to open " + fileName);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer buff = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            buff.append(line).append("\n");
            line = reader.readLine();
        }
        reader.close();
        return buff.toString();
    }

    public void setAMConfigProperties(String configFile) throws ServletException {
        block12: {
            FileInputStream fileStr = null;
            try {
                fileStr = new FileInputStream(configFile);
                if (fileStr != null) {
                    Properties props = new Properties();
                    props.load(fileStr);
                    SystemProperties.initializeProperties((Properties)props);
                    ClientConfiguratorFilter.isConfigured = true;
                    break block12;
                }
                throw new ServletException("Unable to open: " + configFile);
            }
            catch (FileNotFoundException fexp) {
                fexp.printStackTrace();
                throw new ServletException(fexp.getMessage());
            }
            catch (IOException ioexp) {
                ioexp.printStackTrace();
                throw new ServletException(ioexp.getMessage());
            }
            finally {
                if (fileStr != null) {
                    try {
                        fileStr.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    private void createKeystoreFile() throws IOException {
        String location = System.getProperty("user.home") + File.separator;
        InputStream in = this.servletContext.getResourceAsStream("/keystore.jks");
        byte[] b = new byte[2007];
        in.read(b);
        in.close();
        FileOutputStream fos = new FileOutputStream(location + "keystore.jks");
        fos.write(b);
        fos.flush();
        fos.close();
    }
}

