/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.sun.identity.security.EncodeAction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SetupClientSDKSamples {
    private Map properties = new HashMap();
    private Map labels = new HashMap();
    private static final String FILE_AMCONFIG_PROPERTIES_TEMPLATE = "resources/AMConfig.properties.template";
    private static final String FILE_AMCONFIG_PROPERTIES = "resources/AMConfig.properties";
    private static final String TAG_DEBUG_DIR = "DEBUG_DIR";
    private static final String TAG_APPLICATION_PASSWD = "ENCODED_APPLICATION_PASSWORD";
    private static final String TAG_NAMING_URL = "NAMING_URL";
    private static final String TAG_SERVER_PROTOCOL = "SERVER_PROTOCOL";
    private static final String TAG_SERVER_HOST = "SERVER_HOST";
    private static final String TAG_SERVER_PORT = "SERVER_PORT";
    private static final String TAG_DEPLOY_URI = "DEPLOY_URI";
    private static final String TAG_CLIENT_ENC_KEY = "ENCRYPTION_KEY_LOCAL";
    private static final String TAG_SESSION_PROVIDER_CLASS = "SESSION_PROVIDER_CLASS";
    private static final String SESSION_PROVIDER_CLASS = "com.sun.identity.plugin.session.impl.FMSessionProvider";
    private static final String TAG_CONFIGURATION_PROVIDER_CLASS = "CONFIGURATION_PROVIDER_CLASS";
    private static final String CONFIGURATION_PROVIDER_CLASS = "com.sun.identity.plugin.configuration.impl.ConfigurationInstanceImpl";
    private static final String TAG_DATASTORE_PROVIDER_CLASS = "DATASTORE_PROVIDER_CLASS";
    private static final String DATASTORE_PROVIDER_CLASS = "com.sun.identity.plugin.datastore.impl.IdRepoDataStoreProvider";
    private static final String TRUST_ALL_CERTS = "com.iplanet.am.jssproxy.trustAllServerCerts=true\n";
    private static final String CLIENT_ENC_KEY = "com.sun.identity.client.encryptionKey";
    private static final String AM_ENC_KEY = "am.encryption.pwd";
    private static List questions = new ArrayList();
    private static List clientQuestions = new ArrayList();

    public SetupClientSDKSamples() throws IOException, MissingResourceException {
        this.getDefaultValues();
        this.promptForServerAnswers();
        this.createPropertiesFile();
    }

    private void getDefaultValues() throws MissingResourceException {
        ResourceBundle rb = ResourceBundle.getBundle("clientDefault");
        Enumeration<String> e = rb.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = rb.getString(key);
            if (value.startsWith("[")) {
                this.labels.put(key, value.substring(1, value.length() - 1));
                continue;
            }
            this.properties.put(key, value);
        }
        this.properties.put(TAG_DATASTORE_PROVIDER_CLASS, DATASTORE_PROVIDER_CLASS);
        this.properties.put(TAG_CONFIGURATION_PROVIDER_CLASS, CONFIGURATION_PROVIDER_CLASS);
        this.properties.put(TAG_SESSION_PROVIDER_CLASS, SESSION_PROVIDER_CLASS);
        System.setProperty(CLIENT_ENC_KEY, (String)this.properties.get(TAG_CLIENT_ENC_KEY));
        System.setProperty(AM_ENC_KEY, (String)this.properties.get(TAG_CLIENT_ENC_KEY));
    }

    private void promptForServerAnswers() throws IOException {
        Iterator i = questions.iterator();
        while (i.hasNext()) {
            String q = (String)i.next();
            String value = "";
            while (value.length() == 0) {
                String defaultValue = null;
                if (q.equals(TAG_NAMING_URL)) {
                    defaultValue = this.properties.get(TAG_SERVER_PROTOCOL) + "://" + this.properties.get(TAG_SERVER_HOST) + ":" + this.properties.get(TAG_SERVER_PORT) + "/" + this.properties.get(TAG_DEPLOY_URI) + "/namingservice";
                }
                String label = (String)this.labels.get(q);
                if (defaultValue != null) {
                    label = label + " (hit enter to accept default value, " + defaultValue + ")";
                }
                System.out.print(label + ": ");
                value = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if ((value = value.trim()).length() != 0 || defaultValue == null) continue;
                value = defaultValue;
            }
            if (q.equals(TAG_APPLICATION_PASSWD)) {
                this.properties.put(q, (String)AccessController.doPrivileged(new EncodeAction(value)));
                continue;
            }
            this.properties.put(q, value);
        }
    }

    private void createPropertiesFile() throws IOException {
        String content = this.getFileContent(FILE_AMCONFIG_PROPERTIES_TEMPLATE);
        Iterator i = this.properties.keySet().iterator();
        while (i.hasNext()) {
            String tag = (String)i.next();
            content = content.replaceAll("@" + tag + "@", (String)this.properties.get(tag));
        }
        String protocol = (String)this.properties.get(TAG_SERVER_PROTOCOL);
        if (protocol.equalsIgnoreCase("https")) {
            content = content + TRUST_ALL_CERTS;
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(FILE_AMCONFIG_PROPERTIES));
        out.write(content);
        out.close();
    }

    private String getFileContent(String fileName) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        StringBuffer buff = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            buff.append(line).append("\n");
            line = reader.readLine();
        }
        reader.close();
        return buff.toString();
    }

    public static void main(String[] args) {
        try {
            SetupClientSDKSamples main = new SetupClientSDKSamples();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
    }

    static {
        questions.add(TAG_DEBUG_DIR);
        questions.add(TAG_APPLICATION_PASSWD);
        questions.add(TAG_SERVER_PROTOCOL);
        questions.add(TAG_SERVER_HOST);
        questions.add(TAG_SERVER_PORT);
        questions.add(TAG_DEPLOY_URI);
        questions.add(TAG_NAMING_URL);
    }
}

