/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.security.x509.CertUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.shared.debug.Debug;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class WebServicesClients
implements Subject {
    private Set selectedWebServicesClients = Collections.EMPTY_SET;
    private static Debug debug = Debug.getInstance((String)"fmWebServicesClients");
    private static final String RESOURCE_BUNDLE = "fmWebServicesClients";

    public void WebServicesClients() {
    }

    public void initialize(Map configParams) {
    }

    public Syntax getValueSyntax(SSOToken token) {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken token) throws SSOException, PolicyException {
        return this.getValidValues(token, "*");
    }

    public ValidValues getValidValues(SSOToken token, String pattern) throws SSOException, PolicyException {
        HashSet<String> subjects = new HashSet<String>();
        try {
            JKSKeyProvider jkskp = new JKSKeyProvider();
            KeyStore ks = jkskp.getKeyStore();
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (debug.messageEnabled()) {
                    debug.message("WSClient.getValidValues: alias=" + alias);
                }
                if (ks.isCertificateEntry(alias)) {
                    debug.message("WSClient.getValidValues: alias is trusted.");
                    X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
                    if (cert != null) {
                        debug.message("WSClient.getValidValues:cert not null");
                        String name = CertUtils.getSubjectName((X509Certificate)cert);
                        if (name == null || name.length() == 0) continue;
                        subjects.add(name);
                        continue;
                    }
                    debug.message("WSClient.getValidValues: cert is null");
                    continue;
                }
                debug.message("WSClient.getValidValues:alias not trusted.");
            }
        }
        catch (KeyStoreException kse) {
            if (debug.warningEnabled()) {
                debug.warning("WebServicesClients: couldn't get subjects", (Throwable)kse);
            }
            Object[] objs = new String[]{kse.getMessage()};
            throw new PolicyException("amPolicy", "can_not_get_subject_values", objs, (Throwable)kse);
        }
        return new ValidValues(0, subjects);
    }

    public String getDisplayNameForValue(String value, Locale locale) {
        return value;
    }

    public Set getValues() {
        return this.selectedWebServicesClients;
    }

    public void setValues(Set names) throws InvalidNameException {
        if (names == null) {
            debug.error("WebServicesClients.setValues(): Invalid names");
            throw new InvalidNameException(RESOURCE_BUNDLE, "webservicesclients_subject_invalid_user_names", null, "null", 5);
        }
        this.selectedWebServicesClients = new HashSet();
        this.selectedWebServicesClients.addAll(names);
        if (debug.messageEnabled()) {
            debug.message("WebServicesClients.setValues(): selected web service clients names=" + this.selectedWebServicesClients);
        }
    }

    public boolean isMember(SSOToken token) throws SSOException, PolicyException {
        Principal principal = token.getPrincipal();
        String name = principal.getName();
        if (this.selectedWebServicesClients.contains(name)) {
            debug.message("WebServicesClients.isMemeber():principal is member");
            return true;
        }
        String principals = token.getProperty("Principals");
        HashSet requestPrincipals = new HashSet();
        if (principals != null && principals.length() != 0) {
            StringTokenizer st = new StringTokenizer(principals, "|");
            while (st.hasMoreTokens()) {
                if (!this.selectedWebServicesClients.contains(st.nextToken())) continue;
                if (debug.messageEnabled()) {
                    debug.message("WebServicesClients.isMemeber(): principals is member.");
                }
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof WebServicesClients) {
            WebServicesClients client = (WebServicesClients)o;
            if (this.selectedWebServicesClients != null && client.selectedWebServicesClients != null && ((Object)this.selectedWebServicesClients).equals(client.selectedWebServicesClients)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        WebServicesClients theClone = null;
        try {
            theClone = (WebServicesClients)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.selectedWebServicesClients != null) {
            theClone.selectedWebServicesClients = new HashSet();
            theClone.selectedWebServicesClients.addAll(this.selectedWebServicesClients);
        }
        return theClone;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

