/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.iplanet.am.util.Cache;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.security.x509.CertUtils;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.WebServiceAuthenticator;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

class WebServiceAuthenticatorImpl
implements WebServiceAuthenticator {
    private static final String PRINCIPAL_PROP = "Principal";
    private static final String PRINCIPALS_PROP = "Principals";
    private static final String AUTH_TYPE_PROP = "AuthType";
    private static final String AUTH_INSTANT_PROP = "authInstant";
    private static final String ANONYMOUS_PRINCIPAL = "anonymous";
    private static final String SESSION_SERVICE_NAME = "iPlanetAMSessionService";
    private static final String MAX_SESSION_TIME = "iplanet-am-session-max-session-time";
    private static final String IDLE_TIME = "iplanet-am-session-max-idle-time";
    private static final String CACHE_TIME = "iplanet-am-session-max-caching-time";
    private static final int DEFAULT_MAX_SESSION_TIME = 120;
    private static final int DEFAULT_IDLE_TIME = 30;
    private static final int DEFAULT_CACHE_TIME = 3;
    private static Cache ssoTokenCache = new Cache(1000);
    private static SSOTokenManager ssoTokenManager = null;
    private static ServiceSchema sessionSchema = null;
    private static String rootSuffix = SystemPropertiesManager.get((String)"com.iplanet.am.rootsuffix");
    private static Debug debug = Debug.getInstance((String)"fmSOAPBinding");

    WebServiceAuthenticatorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object authenticate(Message message, Subject subject, Map state, HttpServletRequest request) {
        String subjectDN;
        X509Certificate messageCert;
        ArrayList<X509Certificate> certs = null;
        X509Certificate clientCert = message.getPeerCertificate();
        if (clientCert != null) {
            certs = new ArrayList<X509Certificate>(2);
            certs.add(clientCert);
        }
        if ((messageCert = message.getMessageCertificate()) != null) {
            if (certs == null) {
                certs = new ArrayList(1);
            }
            certs.add(messageCert);
        }
        String principal = null;
        StringBuffer principalsSB = null;
        if (certs == null) {
            principal = ANONYMOUS_PRINCIPAL;
        } else {
            HashSet<String> principalsSet = new HashSet<String>(6);
            Iterator iter = certs.iterator();
            while (iter.hasNext()) {
                X509Certificate cert = (X509Certificate)iter.next();
                if (debug.messageEnabled()) {
                    debug.message("WebServiceAuthenticatorImpl.authenticate: cert = " + cert);
                }
                subjectDN = CertUtils.getSubjectName((X509Certificate)cert);
                if (principal == null) {
                    principal = subjectDN;
                } else if (!principal.equals(subjectDN)) {
                    principalsSet.add(subjectDN);
                }
                String issuerDN = CertUtils.getIssuerName((X509Certificate)cert);
                principalsSet.add(issuerDN);
            }
            principalsSB = new StringBuffer(50);
            iter = principalsSet.iterator();
            while (iter.hasNext()) {
                String str = (String)iter.next();
                if (principalsSB.length() == 0) {
                    principalsSB.append(str);
                    continue;
                }
                principalsSB.append("|").append(str);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("WebServiceAuthenticatorImpl.authenticate: principal = " + principal + ", principals = " + principalsSB);
        }
        String authMech = message.getAuthenticationMechanism();
        String cacheKey = authMech + " " + principal;
        if (debug.messageEnabled()) {
            debug.message("WebServiceAuthenticatorImpl.authenticate: cacheKey = " + cacheKey);
        }
        SSOToken ssoToken = null;
        ssoToken = (SSOToken)ssoTokenCache.get((Object)cacheKey);
        if (ssoToken != null) {
            if (ssoTokenManager.isValidToken(ssoToken)) {
                if (debug.messageEnabled()) {
                    debug.message("WebServiceAuthenticatorImpl.authenticate: found ssoToken in cache");
                }
                return ssoToken;
            }
            if (debug.messageEnabled()) {
                debug.message("WebServiceAuthenticatorImpl.authenticate: ssoToken in cache expired");
            }
            subjectDN = ssoTokenCache;
            synchronized (subjectDN) {
                ssoTokenCache.remove((Object)cacheKey);
            }
            ssoToken = null;
        }
        String authInstant = null;
        try {
            InternalSession is = SessionService.getSessionService().newInternalSession(null, null);
            is.activate("");
            Map attrs = sessionSchema.getAttributeDefaults();
            is.setMaxSessionTime((long)CollectionHelper.getIntMapAttr((Map)attrs, (String)MAX_SESSION_TIME, (int)120, (Debug)debug));
            is.setMaxIdleTime((long)CollectionHelper.getIntMapAttr((Map)attrs, (String)IDLE_TIME, (int)30, (Debug)debug));
            is.setMaxCachingTime((long)CollectionHelper.getIntMapAttr((Map)attrs, (String)CACHE_TIME, (int)3, (Debug)debug));
            is.putProperty(AUTH_TYPE_PROP, message.getAuthenticationMechanism());
            authInstant = DateUtils.toUTCDateFormat((Date)new Date());
            is.putProperty(AUTH_INSTANT_PROP, authInstant);
            ssoToken = SSOTokenManager.getInstance().createSSOToken(is.getID().toString());
        }
        catch (Exception ex) {
            debug.error("WebServiceAuthenticatorImpl.authenticate: Unable to get SSOToken", (Throwable)ex);
        }
        if (ssoToken == null) {
            return null;
        }
        try {
            ssoToken.setProperty(PRINCIPAL_PROP, principal);
            if (principalsSB != null) {
                ssoToken.setProperty(PRINCIPALS_PROP, principalsSB.toString());
            }
            if (authInstant != null) {
                ssoToken.setProperty(AUTH_INSTANT_PROP, authInstant);
            }
            ssoToken.setProperty(AUTH_TYPE_PROP, message.getAuthenticationMechanism());
            SSOTokenManager.getInstance().refreshSession(ssoToken);
            ssoTokenCache.put((Object)cacheKey, (Object)ssoToken);
        }
        catch (Exception ex) {
            debug.error("WebServiceAuthenticatorImpl.authenticate: Unable to set SSOToken property", (Throwable)ex);
            return null;
        }
        return ssoToken;
    }

    static {
        try {
            ssoTokenManager = SSOTokenManager.getInstance();
        }
        catch (Exception ex) {
            debug.error("WebServiceAuthenticatorImpl.static: unable to get SSOTokenManager", (Throwable)ex);
        }
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceSchemaManager scm = new ServiceSchemaManager(SESSION_SERVICE_NAME, adminToken);
            sessionSchema = scm.getDynamicSchema();
        }
        catch (Exception ex) {
            debug.error("WebServiceAuthenticatorImpl.static: unable to get session schema", (Throwable)ex);
        }
    }
}

