/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.iplanet.sso.SSOToken;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb.ServiceInstanceType;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.policy.PolicyEvaluator;
import java.util.Map;

public class DefaultDiscoAuthorizer
implements Authorizer {
    public static final String RESOURCE_SEPERATOR = ";";
    PolicyEvaluator pe = null;

    public DefaultDiscoAuthorizer() {
        DiscoUtils.debug.message("in DefaultDiscoAuthorizer.constructor");
        try {
            this.pe = new PolicyEvaluator("sunIdentityServerDiscoveryService");
        }
        catch (Exception e) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.constructor: Exception obtaining PolicyEvaluator: ", (Throwable)e);
        }
    }

    public boolean isAuthorized(Object credential, String action, Object data, Map env) {
        DiscoUtils.debug.message("DefaultDiscoAuthorizer.isAuthorized.");
        if (this.pe == null) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.isAuthorized: null Policy Evaluator.");
            return false;
        }
        if (!this.checkInput(credential, action, data, env)) {
            return false;
        }
        String resource = null;
        try {
            ServiceInstanceType instance = ((ResourceOfferingType)data).getServiceInstance();
            resource = instance.getServiceType() + RESOURCE_SEPERATOR + instance.getProviderID();
        }
        catch (Exception e) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.isAuthorized: Exception occured when constucting policy resource:", (Throwable)e);
            return false;
        }
        boolean result = false;
        try {
            result = this.pe.isAllowed((SSOToken)credential, resource, action, env);
        }
        catch (Exception e) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.isAuthorized: Exception occured during policy evaluation: ", (Throwable)e);
            result = false;
        }
        return result;
    }

    private boolean checkInput(Object credential, String action, Object data, Map env) {
        if (credential == null || !(credential instanceof SSOToken)) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.checkInput: null or wrong credential.");
            return false;
        }
        if (action == null || !action.equals("LOOKUP") && !action.equals("UPDATE")) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.checkInput: null or wrong action.");
            return false;
        }
        if (data == null || !(data instanceof ResourceOfferingType)) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.checkInput: null or wrong data.");
            return false;
        }
        if (!(env != null && env.containsKey("userID") && env.containsKey("authType") && env.containsKey("message"))) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.checkInput: null or missing env data.");
            return false;
        }
        return true;
    }

    public Object getAuthorizationDecision(Object credential, String action, Object data, Map env) throws Exception {
        return null;
    }
}

