/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.COTUtils;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.shared.debug.Debug;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;

public class ListCircleOfTrusts
extends AuthenticatedCommand {
    private static Debug debug = COTUtils.debug;
    private String realm;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.realm = this.getStringOptionValue("realm", "/");
        IOutput outputWriter = this.getOutputWriter();
        try {
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            Set members = cotManager.getAllCirclesOfTrust(this.realm);
            if (members == null || members.isEmpty()) {
                Object[] obj = new Object[]{this.realm};
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-circles-of-trust-no-members"), obj));
            } else {
                Object[] obj = new Object[]{this.realm};
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-circles-of-trust-members"), obj));
                Iterator i = members.iterator();
                while (i.hasNext()) {
                    String cot = (String)i.next();
                    outputWriter.printlnMessage("  " + cot);
                }
            }
        }
        catch (COTException e) {
            debug.warning("ListCircleOfTrusts.handleRequest", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

