/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.sae;

import com.sun.identity.authentication.modules.sae.SAEPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.sae.api.SecureAttrs;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.servlet.http.HttpServletRequest;

public class SAE
extends AMLoginModule {
    private static final int DEFAULT_AUTH_LEVEL = 0;
    private String userTokenId;
    private SAEPrincipal userPrincipal;
    private static final String customModule = "SAE";
    private static Debug debug = null;

    public void init(Subject subject, Map sharedState, Map options) {
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        debug.message("SAE AuthModule.process...");
        HttpServletRequest req = this.getHttpServletRequest();
        if (req == null) {
            debug.error("SAE AuthModule.process: httprequest is null.");
            throw new AuthLoginException("HttpServletRequest is null");
        }
        String encodedString = req.getParameter("sun.data");
        if (debug.messageEnabled()) {
            debug.message("SAE AuthModule.process+encodedStr=" + encodedString);
        }
        String realm = req.getParameter("realm");
        String idpEntityId = req.getParameter("idpEntityID");
        String idpAppUrl = req.getParameter("idpAppUrl");
        debug.message("SAE AuthModule.SAML2Utils.getSAEAttrs");
        Map saeattrs = SAML2Utils.getSAEAttrs((String)realm, (String)idpEntityId, (String)"IDPRole", (String)idpAppUrl);
        if (saeattrs == null) {
            debug.error("SAE AuthModule.process:get SAE Attrs failed:null.");
            throw new AuthLoginException("SAE config Attributes are null");
        }
        String cryptoType = (String)saeattrs.get("type");
        String saekey = null;
        if ("symmetric".equals(cryptoType)) {
            saekey = (String)saeattrs.get("secret");
        } else if ("asymmetric".equals(cryptoType)) {
            saekey = (String)saeattrs.get("pubkeyalias");
        }
        if (debug.messageEnabled()) {
            debug.message("SAE AuthModule: realm=" + realm + ", idpEntityID=" + idpEntityId + ", idpAppUrl=" + idpAppUrl + ", cryptoType=" + cryptoType + ", key=" + saekey);
        }
        Map attrs = null;
        try {
            attrs = SecureAttrs.getInstance((String)cryptoType).verifyEncodedString(encodedString, saekey);
            if (debug.messageEnabled()) {
                debug.message("SAE AuthModule.: SAE attrs:" + attrs);
            }
        }
        catch (Exception ex) {
            debug.error("SAE AuthModule.process: verification failed.", (Throwable)ex);
            throw new AuthLoginException("verify failed");
        }
        if (attrs == null) {
            debug.error("SAE AuthModule.process:verification failed:attrs null.");
            throw new AuthLoginException("Attributes are null");
        }
        this.userTokenId = (String)attrs.get("sun.userid");
        Iterator iter = attrs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.equals("sun.userid")) continue;
            if (debug.messageEnabled()) {
                debug.message("Session Property set: " + key + "= " + value);
            }
            this.setUserSessionProperty(key, value);
        }
        String authLevel = (String)attrs.get("sun.authlevel");
        int authLevelInt = 0;
        if (authLevel != null && authLevel.length() != 0) {
            try {
                authLevelInt = Integer.parseInt(authLevel);
            }
            catch (Exception e) {
                debug.error("Unable to parse auth level " + authLevel + ". Using default.", (Throwable)e);
                authLevelInt = 0;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SAE AuthModule: auth level = " + authLevelInt);
        }
        this.setAuthLevel(authLevelInt);
        debug.message("SAE AuthModule:return SUCCESS");
        return -1;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal == null && this.userTokenId != null) {
            this.userPrincipal = new SAEPrincipal(this.userTokenId);
        }
        return this.userPrincipal;
    }

    public void destroyModuleState() {
        this.userPrincipal = null;
        this.userTokenId = null;
    }

    static {
        debug = Debug.getInstance((String)customModule);
    }
}

