/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.support.ExtensionFileFilter;
import com.eviware.x.dialogs.XFileDialogs;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;

public class SwingFileDialogs
implements XFileDialogs {
    private Component parent;
    private static Map<Object, JFileChooser> choosers = new HashMap<Object, JFileChooser>();

    public SwingFileDialogs(Component parent) {
        this.parent = parent;
    }

    public synchronized JFileChooser getChooser(Object action) {
        action = null;
        JFileChooser chooser = choosers.get(action);
        if (chooser == null) {
            chooser = new JFileChooser();
            choosers.put(action, chooser);
        }
        return chooser;
    }

    public Component getParent() {
        return this.parent;
    }

    public File saveAs(Object action, String title) {
        return this.saveAs(action, title, null, null, null);
    }

    public File saveAs(Object action, String title, String extension, String fileType, File defaultFile) {
        JFileChooser chooser = this.getChooser(action);
        chooser.setDialogTitle(title);
        chooser.setAcceptAllFileFilterUsed(true);
        if (extension != null && fileType != null) {
            chooser.setFileFilter(new ExtensionFileFilter(extension, fileType));
        }
        if (defaultFile != null) {
            chooser.setSelectedFile(defaultFile);
        }
        if (chooser.showSaveDialog(this.getParent()) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public File open(Object action, String title, String extension, String fileType) {
        JFileChooser chooser = this.getChooser(action);
        chooser.setDialogTitle(title);
        chooser.setAcceptAllFileFilterUsed(true);
        if (extension != null && fileType != null) {
            chooser.setFileFilter(new ExtensionFileFilter(extension, fileType));
        }
        if (chooser.showOpenDialog(this.getParent()) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public File openXML(Object action, String title) {
        return this.open(action, title, ".xml", "XML Files (*.xml)");
    }

    public File openDirectory(Object action, String title, File defaultDirectory) {
        JFileChooser chooser = this.getChooser(action);
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(1);
        if (defaultDirectory != null) {
            chooser.setCurrentDirectory(defaultDirectory);
        }
        if (chooser.showOpenDialog(this.getParent()) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }
}

