/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.support;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelItemDesktopPanel<T extends ModelItem>
extends JPanel
implements DesktopPanel {
    private PropertyChangeSupport propertyChangeSupport;
    private final T modelItem;
    private InternalPropertyChangeListener propertyChangeListener;

    public ModelItemDesktopPanel(T modelItem) {
        super(new BorderLayout());
        this.modelItem = modelItem;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.propertyChangeListener = new InternalPropertyChangeListener();
        modelItem.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected boolean release() {
        this.modelItem.removePropertyChangeListener(this.propertyChangeListener);
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public final T getModelItem() {
        return this.modelItem;
    }

    @Override
    public Icon getIcon() {
        return this.modelItem.getIcon();
    }

    @Override
    public abstract boolean dependsOn(ModelItem var1);

    @Override
    public String getTitle() {
        return this.modelItem.getName();
    }

    @Override
    public String getDescription() {
        return this.modelItem.getDescription();
    }

    protected JButton createActionButton(Action action, boolean enabled) {
        JButton button = UISupport.createToolbarButton(action, enabled);
        action.putValue("Name", null);
        return button;
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void notifyPropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private class InternalPropertyChangeListener
    implements PropertyChangeListener {
        private InternalPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(ModelItem.NAME_PROPERTY)) {
                ModelItemDesktopPanel.this.notifyPropertyChange(DesktopPanel.TITLE_PROPERTY, null, ModelItemDesktopPanel.this.getTitle());
            }
            if (evt.getPropertyName().equals(ModelItem.ICON_PROPERTY)) {
                ModelItemDesktopPanel.this.notifyPropertyChange(DesktopPanel.ICON_PROPERTY, null, ModelItemDesktopPanel.this.getIcon());
            }
        }
    }
}

