/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunListener;
import com.eviware.soapui.model.mock.MockRunner;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

public class SoapUIMockServiceRunner {
    private static final Logger log = Logger.getLogger(SoapUIMockServiceRunner.class);
    private String projectFile;
    private String mockService;
    private String port;
    private String path;
    public static String TITLE = "soapUI 1.7.1 MockService Runner";

    public static void main(String[] args) throws Exception {
        System.out.println(TITLE);
        SoapUI.initSoapUILog();
        SoapUIMockServiceRunner runner = new SoapUIMockServiceRunner();
        Options options = new Options();
        options.addOption("m", true, "Sets the MockService");
        options.addOption("p", true, "Sets the local port to listen on");
        options.addOption("a", true, "Sets the url path to listen on");
        options.addOption("s", false, "Sets the soapui-settings.xml file to use");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        String[] args2 = cmd.getArgs();
        if (args2.length != 1 || !cmd.hasOption("m")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("mockservicerunner [options] <soapui-project-file>", options);
            System.err.println("Missing soapUI project file and/or MockService..");
            return;
        }
        runner.setProjectFile(args2[0]);
        runner.setMockService(cmd.getOptionValue("m"));
        if (cmd.hasOption("a")) {
            runner.setPath(cmd.getOptionValue("a"));
        }
        if (cmd.hasOption("p")) {
            runner.setPort(cmd.getOptionValue("p"));
        }
        if (cmd.hasOption("s")) {
            SoapUI.initSettings(cmd.getOptionValue("s"));
        }
        try {
            SoapUI.loadExtLibs();
            runner.run();
            System.exit(0);
        }
        catch (Exception e) {
            log.error((Object)e.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void setProjectFile(String projectFile) {
        this.projectFile = projectFile;
    }

    public void setMockService(String mockService) {
        this.mockService = mockService;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void run() throws Exception {
        if (!new File(this.projectFile).exists()) {
            throw new Exception("soapUI project file [" + this.projectFile + "] not found");
        }
        WsdlProject project = new WsdlProject(this.projectFile, null);
        log.info((Object)("Running MockService [" + this.mockService + "] in project [" + project.getName() + "]"));
        log.info((Object)"Press any key to terminate");
        long startTime = System.nanoTime();
        for (int c = 0; c < project.getMockServiceCount(); ++c) {
            WsdlMockService ms = project.getMockServiceAt(c);
            if (!ms.getName().equals(this.mockService)) continue;
            this.runMockService(ms);
        }
        long timeTaken = (System.nanoTime() - startTime) / 1000000L;
        log.info((Object)("time taken: " + timeTaken + "ms"));
    }

    public void runMockService(WsdlMockService mockService) {
        try {
            if (this.path != null) {
                mockService.setPath(this.path);
            }
            if (this.port != null) {
                mockService.setPort(Integer.parseInt(this.port));
            }
            mockService.addMockRunListener(new LogListener());
            WsdlMockRunner runner = mockService.start();
            System.in.read();
            runner.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void log(String msg) {
        System.out.print(msg);
    }

    public void logError(String msg) {
        System.err.println(msg);
    }

    public class LogListener
    implements MockRunListener {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        private int responseCount;

        public void onMockRunnerStart(MockRunner mockRunner) {
            log.info((Object)("MockService started on port " + mockRunner.getMockService().getPort() + " at path [" + mockRunner.getMockService().getPath() + "]"));
        }

        public void onMockRunnerStop(MockRunner mockRunner) {
            log.info((Object)("MockService stopped, handled " + this.responseCount + " requests"));
        }

        public void onMockResult(MockResult result) {
            ++this.responseCount;
            log.info((Object)("Handled request " + this.responseCount + "; [" + result.getMockResponse().getMockOperation().getName() + "] with [" + result.getMockResponse().getName() + "] in [" + result.getTimeTaken() + "ms] at [" + this.dateFormat.format(new Date(result.getTimestamp())) + "]"));
        }

        public void onMockRequest(MockRunner runner, HttpServletRequest request, HttpServletResponse response) {
        }
    }
}

