/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.action;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingActionDelegate<T>
extends AbstractAction
implements PropertyChangeListener {
    private final SoapUIAction<T> action;
    private final T target;

    public SwingActionDelegate(SoapUIAction<T> action, T target) {
        this(action, target, null, null);
    }

    public SwingActionDelegate(SoapUIAction<T> action, T target, String keyStroke) {
        this(action, target, null, keyStroke);
    }

    public SwingActionDelegate(SoapUIAction<T> action, T target, Icon icon) {
        this(action, target, icon, null);
    }

    public SwingActionDelegate(SoapUIAction<T> action, T target, Icon icon, String keyStroke) {
        super(action.getName());
        this.action = action;
        this.target = target;
        if (action.getDescription() != null) {
            this.putValue("ShortDescription", action.getDescription());
        }
        if (icon != null) {
            this.putValue("SmallIcon", icon);
        }
        if (keyStroke != null) {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke(keyStroke));
        }
        this.setEnabled(action.isEnabled());
        action.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.action.perform(this.target);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(SoapUIAction.ENABLED_PROPERTY)) {
            this.setEnabled((Boolean)evt.getNewValue());
        }
    }

    public SoapUIAction<T> getAction() {
        return this.action;
    }

    public T getTarget() {
        return this.target;
    }
}

