/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.testsuite.TestSuiteListener;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.TestCaseTreeNode;
import com.eviware.soapui.settings.UISettings;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteTreeNode
extends AbstractModelItemTreeNode<TestSuite> {
    private InternalTestSuiteListener internalTestSuiteListener = new InternalTestSuiteListener();
    private AbstractModelItemTreeNode.ReorderPropertyChangeListener propertyChangeListener = new AbstractModelItemTreeNode.ReorderPropertyChangeListener();
    private List<TestCaseTreeNode> testCaseNodes = new ArrayList<TestCaseTreeNode>();

    public TestSuiteTreeNode(TestSuite testSuite, SoapUITreeModel treeModel) {
        super(testSuite, testSuite.getProject(), treeModel);
        testSuite.addTestSuiteListener(this.internalTestSuiteListener);
        for (int c = 0; c < testSuite.getTestCaseCount(); ++c) {
            TestCase testCase = testSuite.getTestCaseAt(c);
            testCase.addPropertyChangeListener(TestCase.NAME_PROPERTY, this.propertyChangeListener);
            this.testCaseNodes.add(new TestCaseTreeNode(testCase, this.getTreeModel()));
        }
        this.initOrdering(this.testCaseNodes, UISettings.ORDER_TESTCASES);
        this.getTreeModel().mapModelItems(this.testCaseNodes);
    }

    @Override
    public void release() {
        super.release();
        this.getTestSuite().removeTestSuiteListener(this.internalTestSuiteListener);
        for (TestCaseTreeNode treeNode : this.testCaseNodes) {
            treeNode.release();
        }
    }

    public TestSuite getTestSuite() {
        return (TestSuite)this.getModelItem();
    }

    private class InternalTestSuiteListener
    implements TestSuiteListener {
        private InternalTestSuiteListener() {
        }

        public void testCaseAdded(TestCase testCase) {
            TestCaseTreeNode testCaseTreeNode = new TestCaseTreeNode(testCase, TestSuiteTreeNode.this.getTreeModel());
            TestSuiteTreeNode.this.testCaseNodes.add(testCaseTreeNode);
            TestSuiteTreeNode.this.reorder(false);
            testCase.addPropertyChangeListener(TestCase.NAME_PROPERTY, TestSuiteTreeNode.this.propertyChangeListener);
            TestSuiteTreeNode.this.getTreeModel().notifyNodeInserted(testCaseTreeNode);
        }

        public void testCaseRemoved(TestCase testCase) {
            SoapUITreeNode treeNode = TestSuiteTreeNode.this.getTreeModel().getTreeNode(testCase);
            if (!TestSuiteTreeNode.this.testCaseNodes.contains(treeNode)) {
                throw new RuntimeException("Removing unknown TestCase");
            }
            TestSuiteTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
            TestSuiteTreeNode.this.testCaseNodes.remove(treeNode);
            testCase.removePropertyChangeListener(TestSuiteTreeNode.this.propertyChangeListener);
        }

        public void testStepAdded(TestStep testStep, int index) {
            TestCaseTreeNode testCaseTreeNode = (TestCaseTreeNode)TestSuiteTreeNode.this.getTreeModel().getTreeNode(testStep.getTestCase());
            testCaseTreeNode.testStepInserted(testStep, index);
        }

        public void testStepRemoved(TestStep testStep, int index) {
            TestCaseTreeNode testCaseTreeNode = (TestCaseTreeNode)TestSuiteTreeNode.this.getTreeModel().getTreeNode(testStep.getTestCase());
            testCaseTreeNode.testStepRemoved(testStep, index);
        }

        public void loadTestAdded(LoadTest loadTest) {
            TestCaseTreeNode testCaseTreeNode = (TestCaseTreeNode)TestSuiteTreeNode.this.getTreeModel().getTreeNode(loadTest.getTestCase());
            testCaseTreeNode.loadTestInserted(loadTest);
        }

        public void loadTestRemoved(LoadTest loadTest) {
            TestCaseTreeNode testCaseTreeNode = (TestCaseTreeNode)TestSuiteTreeNode.this.getTreeModel().getTreeNode(loadTest.getTestCase());
            testCaseTreeNode.loadTestRemoved(loadTest);
        }

        public void testStepMoved(TestStep testStep, int fromIndex, int offset) {
            TestCaseTreeNode testCaseTreeNode = (TestCaseTreeNode)TestSuiteTreeNode.this.getTreeModel().getTreeNode(testStep.getTestCase());
            testCaseTreeNode.testStepMoved(testStep, fromIndex, offset);
        }
    }
}

