/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions;

import com.eviware.soapui.config.RequestAssertionConfig;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionError;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionException;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.RequestAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.ResponseAssertion;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.ActionSupport;
import com.eviware.soapui.support.action.DefaultActionList;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.soapui.support.xml.XmlUtils;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.custommonkey.xmlunit.XMLAssert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathContainsAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion {
    private static final Logger log = Logger.getLogger(XPathContainsAssertion.class);
    private String expectedContent;
    private String path;
    private JDialog configurationDialog;
    private JTextArea pathArea;
    private JTextArea contentArea;
    public boolean configureResult;
    public static final String ID = "XPath Match";
    public static final String LABEL = "XPath Match";

    public XPathContainsAssertion(RequestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.path = reader.readString("path", null);
        this.expectedContent = reader.readString("content", null);
    }

    public String getExpectedContent() {
        return this.expectedContent;
    }

    public void setContent(String content) {
        this.expectedContent = content;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected String internalAssertResponse(WsdlMessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return this.assertContent(messageExchange.getResponseContent(), context, "Response");
    }

    public String assertContent(String response, SubmitContext context, String type) throws AssertionException {
        try {
            if (this.path == null) {
                return "Missing path for XPath assertion";
            }
            if (this.expectedContent == null) {
                return "Missing content for XPath assertion";
            }
            XmlObject xml = XmlObject.Factory.parse((String)response);
            String expandedPath = PropertyExpansionRequestFilter.expandProperties(context, this.path);
            XmlObject[] items = xml.selectPath(expandedPath);
            XmlObject contentObj = null;
            try {
                contentObj = XmlObject.Factory.parse((String)this.expectedContent);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (items.length == 0) {
                throw new Exception("Missing content for xpath [" + this.path + "] in " + type);
            }
            XmlOptions options = new XmlOptions();
            options.setSavePrettyPrint();
            options.setSaveOuter();
            for (int c = 0; c < items.length; ++c) {
                try {
                    if (contentObj == null) {
                        String expandedContent = PropertyExpansionRequestFilter.expandProperties(context, this.expectedContent);
                        if (items[c] instanceof XmlAnySimpleType) {
                            String value = ((XmlAnySimpleType)items[c]).getStringValue();
                            String expandedValue = PropertyExpansionRequestFilter.expandProperties(context, value);
                            XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                        } else {
                            Node domNode = items[c].getDomNode();
                            if (domNode.getNodeType() == 1) {
                                String expandedValue = PropertyExpansionRequestFilter.expandProperties(context, XmlUtils.getElementText((Element)domNode));
                                XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                            } else {
                                String expandedValue = PropertyExpansionRequestFilter.expandProperties(context, domNode.getNodeValue());
                                XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                            }
                        }
                    } else {
                        XMLAssert.assertXMLEqual((String)contentObj.xmlText(options), (String)items[c].xmlText(options));
                    }
                    break;
                }
                catch (Throwable e) {
                    if (c != items.length - 1) continue;
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            String msg = "XPathContains assertion failed for path [" + this.path + "] : " + e.getClass().getSimpleName() + ":" + e.getMessage();
            throw new AssertionException(new AssertionError(msg));
        }
        return type + " matches content for [" + this.path + "]";
    }

    public boolean configure() {
        if (this.configurationDialog == null) {
            this.buildConfigurationDialog();
        }
        this.pathArea.setText(this.path);
        this.contentArea.setText(this.expectedContent);
        UISupport.showDialog(this.configurationDialog);
        return this.configureResult;
    }

    protected void buildConfigurationDialog() {
        this.configurationDialog = new JDialog(UISupport.getMainFrame());
        this.configurationDialog.setTitle("XPath Match configuration");
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add(UISupport.buildDescription("Specify xpath expression and matching content", "declare namespaces with <code>declare namespace &lt;prefix&gt;='&lt;namespace&gt;';</code>", null), "North");
        JSplitPane splitPane = UISupport.createVerticalSplit();
        this.pathArea = new JUndoableTextArea();
        this.pathArea.setToolTipText("Specifies the XPath expression to select from the message for validation");
        splitPane.setTopComponent(UISupport.addTitledBorder(new JScrollPane(this.pathArea), "XPath Expression"));
        this.contentArea = new JUndoableTextArea();
        this.contentArea.setToolTipText("Specifies the expected result of the XPath expression");
        splitPane.setBottomComponent(UISupport.addTitledBorder(new JScrollPane(this.contentArea), "Expected Result"));
        splitPane.setDividerLocation(100);
        splitPane.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        contentPanel.add((Component)splitPane, "Center");
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/response-assertions.html#XPath_Match")));
        builder.addGlue();
        ActionList actionList = this.getEditorActions();
        ActionSupport.addActions(actionList, builder);
        builder.setBorder(BorderFactory.createEmptyBorder(1, 5, 5, 5));
        contentPanel.add((Component)builder.getPanel(), "South");
        this.configurationDialog.setContentPane(contentPanel);
        this.configurationDialog.setSize(500, 400);
        this.configurationDialog.setModal(true);
    }

    protected ActionList getEditorActions() {
        DefaultActionList actionList = new DefaultActionList();
        actionList.addAction(new SelectFromCurrentAction());
        actionList.addAction(new TestPathAction());
        actionList.addAction(new DeclareNamespacesFromCurrentAction());
        actionList.addAction(new OkAction());
        actionList.addAction(new CancelAction());
        return actionList;
    }

    public XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("path", this.path);
        builder.add("content", this.expectedContent);
        return builder.finish();
    }

    public boolean isConfigurable() {
        return true;
    }

    public void selectFromCurrent() {
        try {
            String txt;
            XmlOptions options = new XmlOptions();
            options.setSavePrettyPrint();
            options.setSaveOuter();
            options.setSaveAggressiveNamespaces();
            XmlObject xml = XmlObject.Factory.parse((String)this.getAssertable().getAssertableContent());
            String string = txt = this.pathArea == null || !this.pathArea.isVisible() ? this.getPath() : this.pathArea.getSelectedText();
            if (txt == null) {
                txt = this.pathArea == null ? "" : this.pathArea.getText();
            }
            WsdlTestRunContext context = new WsdlTestRunContext(this.getAssertable().getTestStep());
            XmlObject[] items = xml.selectPath(PropertyExpansionRequestFilter.expandProperties(context, txt.trim()));
            if (this.contentArea != null && this.contentArea.isVisible()) {
                this.contentArea.setText("");
            }
            if (items.length == 0) {
                UISupport.showErrorMessage("No match in current response");
            } else if (items.length > 1) {
                UISupport.showErrorMessage("More than one match in current response");
            } else {
                Node domNode;
                String stringValue = null;
                stringValue = items[0] instanceof XmlAnySimpleType ? ((XmlAnySimpleType)items[0]).getStringValue() : ((domNode = items[0].getDomNode()).getNodeType() == 1 ? items[0].xmlText(options) : domNode.getNodeValue());
                if (this.contentArea != null && this.contentArea.isVisible()) {
                    this.contentArea.setText(stringValue);
                } else {
                    this.setContent(stringValue);
                }
            }
        }
        catch (Throwable e) {
            UISupport.showErrorMessage(e.toString());
            e.printStackTrace();
        }
    }

    protected String internalAssertRequest(WsdlMessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!messageExchange.hasRequest(true)) {
            return "Missing Request";
        }
        return this.assertContent(messageExchange.getRequestContent(), context, "Request");
    }

    public JTextArea getContentArea() {
        return this.contentArea;
    }

    public JTextArea getPathArea() {
        return this.pathArea;
    }

    public class SelectFromCurrentAction
    extends AbstractAction {
        public SelectFromCurrentAction() {
            super("Select from current");
            this.putValue("ShortDescription", "Selects the XPath expression from the current message into the Expected Content field");
        }

        public void actionPerformed(ActionEvent arg0) {
            XPathContainsAssertion.this.selectFromCurrent();
        }
    }

    public class TestPathAction
    extends AbstractAction {
        public TestPathAction() {
            super("Test");
            this.putValue("ShortDescription", "Tests the XPath expression for the current message against the Expected Content field");
        }

        public void actionPerformed(ActionEvent arg0) {
            String oldPath = XPathContainsAssertion.this.getPath();
            String oldContent = XPathContainsAssertion.this.getExpectedContent();
            XPathContainsAssertion.this.setPath(XPathContainsAssertion.this.pathArea.getText().trim());
            XPathContainsAssertion.this.setContent(XPathContainsAssertion.this.contentArea.getText());
            try {
                String msg = XPathContainsAssertion.this.assertContent(XPathContainsAssertion.this.getAssertable().getAssertableContent(), new WsdlSubmitContext(XPathContainsAssertion.this.getAssertable().getTestStep()), "Response");
                UISupport.showInfoMessage(msg, "Success");
            }
            catch (AssertionException e) {
                UISupport.showErrorMessage(e.getMessage());
            }
            XPathContainsAssertion.this.setPath(oldPath);
            XPathContainsAssertion.this.setContent(oldContent);
        }
    }

    public class DeclareNamespacesFromCurrentAction
    extends AbstractAction {
        public DeclareNamespacesFromCurrentAction() {
            super("Declare");
            this.putValue("ShortDescription", "Add namespace declaration from current message to XPath expression");
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                String content = XPathContainsAssertion.this.getAssertable().getAssertableContent();
                if (content != null && content.trim().length() > 0) {
                    XPathContainsAssertion.this.pathArea.setText(XmlUtils.declareXPathNamespaces(content) + XPathContainsAssertion.this.pathArea.getText());
                } else if (UISupport.confirm("Declare namespaces from schema instead?", "Missing Response")) {
                    XPathContainsAssertion.this.pathArea.setText(XmlUtils.declareXPathNamespaces(XPathContainsAssertion.this.getAssertable().getInterface()) + XPathContainsAssertion.this.pathArea.getText());
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    public class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent arg0) {
            XPathContainsAssertion.this.configureResult = false;
            XPathContainsAssertion.this.configurationDialog.setVisible(false);
        }
    }

    public class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Save");
        }

        public void actionPerformed(ActionEvent arg0) {
            XPathContainsAssertion.this.setPath(XPathContainsAssertion.this.pathArea.getText().trim());
            XPathContainsAssertion.this.setContent(XPathContainsAssertion.this.contentArea.getText());
            XPathContainsAssertion.this.setConfiguration(XPathContainsAssertion.this.createConfiguration());
            XPathContainsAssertion.this.configureResult = true;
            XPathContainsAssertion.this.configurationDialog.setVisible(false);
        }
    }
}

