/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions;

import com.eviware.soapui.config.RequestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionError;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionException;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.RequestAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.ResponseAssertion;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import org.apache.xmlbeans.XmlObject;

public class SimpleContainsAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion {
    private String token;
    private XFormDialog dialog;
    private boolean ignoreCase;
    public static final String ID = "Simple Contains";
    private static final String CONTENT = "Content";
    private static final String IGNORE_CASE = "Ignore Case";

    public SimpleContainsAssertion(RequestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.token = reader.readString("token", null);
        this.ignoreCase = reader.readBoolean("ignoreCase", false);
    }

    public String internalAssertResponse(WsdlMessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return this.assertContent(context, messageExchange.getResponseContent(), "Response");
    }

    private String assertContent(SubmitContext context, String content, String type) throws AssertionException {
        String replToken;
        if (this.token == null) {
            this.token = "";
        }
        if ((replToken = PropertyExpansionRequestFilter.expandProperties(context, this.token)).length() > 0) {
            int ix;
            int n = ix = this.ignoreCase ? content.toUpperCase().indexOf(replToken.toUpperCase()) : content.indexOf(replToken);
            if (ix == -1) {
                throw new AssertionException(new AssertionError("Missing token [" + replToken + "] in " + type));
            }
        }
        return "Response contains token [" + replToken + "]";
    }

    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(CONTENT, this.token);
        values.put(IGNORE_CASE, this.ignoreCase);
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            this.token = (String)values.get(CONTENT);
            this.ignoreCase = values.getBoolean(IGNORE_CASE);
        }
        this.setConfiguration(this.createConfiguration());
        return true;
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("token", this.token);
        builder.add("ignoreCase", this.ignoreCase);
        return builder.finish();
    }

    public boolean isConfigurable() {
        return true;
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Simple Contains Assertion");
        XForm mainForm = builder.createForm("Basic");
        mainForm.addTextField(CONTENT, "Content to check for", XForm.FieldType.TEXT).setWidth(20);
        mainForm.addCheckBox(IGNORE_CASE, "Ignore case in comparison");
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/userguide/functional/response-assertions.html#Simple_Contains"), "Specify options", UISupport.OPTIONS_ICON);
    }

    protected String internalAssertRequest(WsdlMessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return this.assertContent(context, messageExchange.getRequestContent(), "Request");
    }
}

