/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.PropertiesStepConfig;
import com.eviware.soapui.config.PropertyConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.actions.CloneTestStepAction;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepProperty;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;

public class WsdlPropertiesTestStep
extends WsdlTestStep {
    private PropertiesStepConfig propertiesStepConfig;
    private List<StepProperty> properties = new ArrayList<StepProperty>();
    private ImageIcon okIcon = UISupport.createImageIcon("/properties_step.gif");
    private ImageIcon failedIcon = UISupport.createImageIcon("/properties_step_failed.gif");

    public WsdlPropertiesTestStep(WsdlTestCase testCase, TestStepConfig config) {
        super(testCase, config, true);
        this.setIcon(this.okIcon);
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new CloneTestStepAction(this, "PropertiesStep"));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/propertytransfers.html"));
        if (config.getConfig() == null) {
            this.propertiesStepConfig = (PropertiesStepConfig)config.addNewConfig().changeType(PropertiesStepConfig.type);
            this.propertiesStepConfig.addNewProperties();
            this.propertiesStepConfig.setCreateMissingOnLoad(true);
        } else {
            this.propertiesStepConfig = (PropertiesStepConfig)config.getConfig().changeType(PropertiesStepConfig.type);
            if (this.propertiesStepConfig.isSetProperties()) {
                PropertiesStepConfig.Properties props = this.propertiesStepConfig.getProperties();
                for (int c = 0; c < props.sizeOfPropertyArray(); ++c) {
                    StepProperty stepProperty = new StepProperty(props.getPropertyArray(c));
                    this.properties.add(stepProperty);
                    this.addProperty(stepProperty);
                }
            } else {
                this.propertiesStepConfig.addNewProperties();
            }
            if (!this.propertiesStepConfig.isSetSaveFirst()) {
                this.propertiesStepConfig.setSaveFirst(true);
            }
        }
    }

    public TestStepResult run(TestRunner testRunner, TestRunContext testRunContext) {
        WsdlTestStepResult result;
        boolean hasRunningLoadTest;
        block6: {
            String source;
            TestMonitor testMonitor = SoapUI.getTestMonitor();
            hasRunningLoadTest = testMonitor == null ? false : testMonitor.hasRunningLoadTest(this.getTestCase());
            result = new WsdlTestStepResult(this);
            if (!hasRunningLoadTest) {
                this.setIcon(this.okIcon);
            }
            result.setStatus(TestStepResult.TestStepStatus.OK);
            result.startTimer();
            if (this.isSaveFirst()) {
                this.saveDuringRun(hasRunningLoadTest, result);
            }
            if ((source = this.getSource()) != null && source.trim().length() > 0) {
                try {
                    int cnt = this.loadProperties(source, this.isCreateMissingOnLoad());
                    result.setStatus(TestStepResult.TestStepStatus.OK);
                    result.addMessage("Loaded " + cnt + " properties from [" + source + "]");
                }
                catch (IOException e) {
                    result.stopTimer();
                    result.addMessage("Failed to load properties from [" + source + "]");
                    result.setStatus(TestStepResult.TestStepStatus.FAILED);
                    result.setError(e);
                    if (hasRunningLoadTest) break block6;
                    this.setIcon(this.failedIcon);
                }
            }
        }
        if (!this.isSaveFirst()) {
            this.saveDuringRun(hasRunningLoadTest, result);
        }
        result.stopTimer();
        return result;
    }

    private boolean saveDuringRun(boolean hasRunningLoadTest, WsdlTestStepResult result) {
        String target = this.getTarget();
        if (target != null && target.trim().length() > 0) {
            try {
                int cnt = this.saveProperties(target);
                result.setStatus(TestStepResult.TestStepStatus.OK);
                result.addMessage("Saved " + cnt + " properties to [" + target + "]");
            }
            catch (IOException e) {
                result.stopTimer();
                result.addMessage("Failed to save properties to [" + target + "]");
                result.setStatus(TestStepResult.TestStepStatus.FAILED);
                result.setError(e);
                if (!hasRunningLoadTest) {
                    this.setIcon(this.failedIcon);
                }
                return false;
            }
        }
        return true;
    }

    private int saveProperties(String target) throws IOException {
        Properties props = new Properties();
        int cnt = 0;
        for (StepProperty p : this.properties) {
            String name = p.getName();
            props.setProperty(name, p.getValue());
            ++cnt;
        }
        props.store(this.getPropertiesOutputStream(target), "TestStep [" + this.getName() + "] properties");
        return cnt;
    }

    private FileOutputStream getPropertiesOutputStream(String target) throws FileNotFoundException {
        String fileProperty = System.getProperty(target);
        if (fileProperty != null) {
            target = fileProperty;
        }
        return new FileOutputStream(target);
    }

    private int loadProperties(String source, boolean createMissing) throws IOException {
        Properties props = new Properties();
        props.load(this.getPropertiesInputStream(source));
        int cnt = 0;
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            TestStepProperty property = this.getProperty(name);
            if (property != null) {
                property.setValue(props.get(name).toString());
                ++cnt;
                continue;
            }
            if (!createMissing) continue;
            this.addProperty(name).setValue(props.get(name).toString());
            ++cnt;
        }
        return cnt;
    }

    private InputStream getPropertiesInputStream(String source) throws IOException {
        String fileProperty = System.getProperty(source);
        if (fileProperty != null) {
            source = fileProperty;
        }
        URL url = null;
        try {
            url = new URL(source);
        }
        catch (MalformedURLException e) {
            url = new URL("file:" + source);
        }
        return url.openStream();
    }

    public StepProperty getTestStepPropertyAt(int index) {
        return this.properties.get(index);
    }

    public int getStepPropertyCount() {
        return this.properties.size();
    }

    public String getSource() {
        return this.propertiesStepConfig.getSource();
    }

    public void setSource(String source) {
        this.propertiesStepConfig.setSource(source);
    }

    public String getTarget() {
        return this.propertiesStepConfig.getTarget();
    }

    public void setTarget(String target) {
        this.propertiesStepConfig.setTarget(target);
    }

    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.propertiesStepConfig = (PropertiesStepConfig)config.getConfig().changeType(PropertiesStepConfig.type);
        for (int c = 0; c < this.propertiesStepConfig.getProperties().sizeOfPropertyArray(); ++c) {
            this.properties.get(c).setConfig(this.propertiesStepConfig.getProperties().getPropertyArray(c));
        }
    }

    public StepProperty addProperty(String name) {
        PropertyConfig property = this.propertiesStepConfig.getProperties().addNewProperty();
        property.setName(name);
        StepProperty stepProperty = new StepProperty(property);
        this.properties.add(stepProperty);
        this.addProperty(stepProperty);
        this.firePropertyAdded(name);
        return stepProperty;
    }

    public void removeProperty(String name) {
        for (int c = 0; c < this.properties.size(); ++c) {
            if (!this.properties.get(c).getName().equalsIgnoreCase(name)) continue;
            this.removePropertyAt(c);
            return;
        }
    }

    public void removePropertyAt(int index) {
        String name = this.properties.get(index).getName();
        this.properties.remove(index);
        this.deleteProperty(name);
        this.firePropertyRemoved(name);
        this.propertiesStepConfig.getProperties().removeProperty(index);
    }

    public int loadProperties(boolean createMissing) throws IOException {
        return this.loadProperties(this.getSource(), createMissing);
    }

    public int saveProperties() throws IOException {
        return this.saveProperties(this.getTarget());
    }

    public boolean isCreateMissingOnLoad() {
        return this.propertiesStepConfig.getCreateMissingOnLoad();
    }

    public void setCreateMissingOnLoad(boolean b) {
        this.propertiesStepConfig.setCreateMissingOnLoad(b);
    }

    public boolean isSaveFirst() {
        return this.propertiesStepConfig.getSaveFirst();
    }

    public void setSaveFirst(boolean b) {
        this.propertiesStepConfig.setSaveFirst(b);
    }

    public class StepProperty
    implements TestStepProperty {
        private PropertyConfig propertyConfig;

        public StepProperty(PropertyConfig propertyConfig) {
            this.propertyConfig = propertyConfig;
        }

        public void setConfig(PropertyConfig propertyConfig) {
            this.propertyConfig = propertyConfig;
        }

        public String getName() {
            return this.propertyConfig.getName();
        }

        public void setName(String name) {
            String oldName = this.getName();
            this.propertyConfig.setName(name);
            WsdlPropertiesTestStep.this.propertyRenamed(oldName);
        }

        public String getDescription() {
            return null;
        }

        public String getValue() {
            return this.propertyConfig.getValue();
        }

        public void setValue(String value) {
            String oldValue = this.getValue();
            this.propertyConfig.setValue(value);
            WsdlPropertiesTestStep.this.firePropertyValueChanged(this.getName(), oldValue, value);
        }

        public boolean isReadOnly() {
            return false;
        }

        public TestStep getTestStep() {
            return WsdlPropertiesTestStep.this;
        }
    }
}

