/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.GotoConditionConfig;
import com.eviware.soapui.config.GotoConditionTypeConfig;
import com.eviware.soapui.config.GotoStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.actions.CloneTestStepAction;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlObject;

public class WsdlGotoTestStep
extends WsdlTestStep {
    private GotoStepConfig gotoStepConfig;
    private List<GotoCondition> conditions = new ArrayList<GotoCondition>();
    private boolean canceled;
    private static final Logger log = Logger.getLogger(WsdlGotoTestStep.class);

    public WsdlGotoTestStep(WsdlTestCase testCase, TestStepConfig config) {
        super(testCase, config, true);
        this.setIcon(UISupport.createImageIcon("/goto.gif"));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new CloneTestStepAction(this, "GotoStep"));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/gotostep.html"));
    }

    public void postInit(TestStepConfig config) {
        if (config.getConfig() == null) {
            this.gotoStepConfig = (GotoStepConfig)config.addNewConfig().changeType(GotoStepConfig.type);
        } else {
            this.gotoStepConfig = (GotoStepConfig)config.getConfig().changeType(GotoStepConfig.type);
            for (int c = 0; c < this.gotoStepConfig.sizeOfConditionArray(); ++c) {
                this.conditions.add(new GotoCondition(this.gotoStepConfig.getConditionArray(c)));
            }
        }
    }

    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.gotoStepConfig = (GotoStepConfig)config.getConfig().changeType(GotoStepConfig.type);
        for (int c = 0; c < this.gotoStepConfig.sizeOfConditionArray(); ++c) {
            this.conditions.get(c).setConfig(this.gotoStepConfig.getConditionArray(c));
        }
    }

    public TestStepResult run(TestRunner runner, TestRunContext context) {
        WsdlTestStepResult result = new WsdlTestStepResult(this);
        this.canceled = false;
        result.startTimer();
        WsdlTestRequestStep previousStep = (WsdlTestRequestStep)this.getTestCase().findPreviousStepOfType((TestStep)this, WsdlTestRequestStep.class);
        if (previousStep == null) {
            result.stopTimer();
            result.addMessage("Failed to find previous request step from [" + this.getName() + "]");
            result.setStatus(TestStepResult.TestStepStatus.FAILED);
            return result;
        }
        GotoCondition target = this.runConditions(previousStep);
        if (target == null) {
            result.addMessage("Missing matching condition, moving on.");
        } else {
            String targetStepName = target.getTargetStep();
            result.addMessage("Matched condition [" + targetStepName + "]");
            runner.gotoStep(runner.getTestCase().getTestStepIndexByName(targetStepName));
        }
        result.stopTimer();
        result.setStatus(TestStepResult.TestStepStatus.OK);
        return result;
    }

    public GotoCondition runConditions(WsdlTestRequestStep previousStep) {
        for (GotoCondition condition : this.conditions) {
            if (this.canceled) break;
            try {
                if (!condition.evaluate(previousStep)) continue;
                return condition;
            }
            catch (Exception e) {
                log.error((Object)("Error making condition " + condition.getName() + "; " + e));
            }
        }
        return null;
    }

    public boolean cancel() {
        this.canceled = true;
        return this.canceled;
    }

    public int getConditionCount() {
        return this.conditions.size();
    }

    public GotoCondition getConditionAt(int index) {
        return this.conditions.get(index);
    }

    public GotoCondition addCondition(String name) {
        GotoCondition condition = new GotoCondition(this.gotoStepConfig.addNewCondition());
        condition.setName(name);
        condition.setType(GotoConditionTypeConfig.XPATH.toString());
        this.conditions.add(condition);
        return condition;
    }

    public void removeConditionAt(int index) {
        this.conditions.remove(index);
        this.gotoStepConfig.removeCondition(index);
    }

    public void release() {
        super.release();
        for (GotoCondition condition : this.conditions) {
            condition.release();
        }
    }

    public class GotoCondition
    implements PropertyChangeListener {
        public static final String TARGET_STEP_PROPERTY = "target_step";
        private GotoConditionConfig conditionConfig;
        private TestStep currentStep;
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public GotoCondition(GotoConditionConfig conditionConfig) {
            this.conditionConfig = conditionConfig;
            this.initListeners();
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        private void initListeners() {
            int index;
            this.release();
            if (this.getTargetStep() != null && (index = WsdlGotoTestStep.this.getTestCase().getTestStepIndexByName(this.getTargetStep())) != -1) {
                this.currentStep = WsdlGotoTestStep.this.getTestCase().getTestStepAt(index);
                this.currentStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, this);
            }
        }

        public void release() {
            if (this.currentStep != null) {
                this.currentStep.removePropertyChangeListener(this);
            }
        }

        public boolean evaluate(WsdlTestRequestStep previousStep) throws Exception {
            if (this.getExpression() == null || this.getExpression().trim().length() == 0) {
                throw new Exception("Missing expression in condition [" + this.getName() + "]");
            }
            if (this.getTargetStep() == null || this.getTargetStep().trim().length() == 0) {
                throw new Exception("Missing target step in condition [" + this.getName() + "]");
            }
            if (this.getType().equals(GotoConditionTypeConfig.XPATH.toString())) {
                XmlObject xmlObject = XmlObject.Factory.parse((String)previousStep.getTestRequest().getResponse().getContentAsString());
                XmlObject[] selectPath = xmlObject.selectPath(this.getExpression());
                if (selectPath.length == 1 && selectPath[0] instanceof XmlBoolean && ((XmlBoolean)selectPath[0]).getBooleanValue()) {
                    return true;
                }
            } else {
                log.error((Object)("Unkown condition type: " + this.getType()));
            }
            return false;
        }

        protected void setConfig(GotoConditionConfig conditionConfig) {
            this.conditionConfig = conditionConfig;
        }

        public String getType() {
            return this.conditionConfig.getType();
        }

        public String getName() {
            return this.conditionConfig.getName();
        }

        public String getExpression() {
            return this.conditionConfig.getExpression();
        }

        public String getTargetStep() {
            return this.conditionConfig.getTargetStep();
        }

        public void setType(String type) {
            this.conditionConfig.setType(type);
        }

        public void setName(String name) {
            this.conditionConfig.setName(name);
        }

        public void setExpression(String expression) {
            this.conditionConfig.setExpression(expression);
        }

        public void setTargetStep(String targetStep) {
            String oldStep = this.getTargetStep();
            this.conditionConfig.setTargetStep(targetStep);
            this.initListeners();
            this.propertyChangeSupport.firePropertyChange(TARGET_STEP_PROPERTY, oldStep, targetStep);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.conditionConfig.setTargetStep(evt.getNewValue().toString());
            this.propertyChangeSupport.firePropertyChange(TARGET_STEP_PROPERTY, evt.getOldValue(), evt.getNewValue());
        }
    }
}

