/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.TimeablePostMethod;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.settings.HttpSettings;
import org.apache.commons.httpclient.URI;

public class SoapHeadersRequestFilter
implements RequestFilter {
    public void filterRequest(SubmitContext context, WsdlRequest wsdlRequest) {
        TimeablePostMethod postMethod = (TimeablePostMethod)((Object)context.getProperty("postMethod"));
        WsdlInterface wsdlInterface = wsdlRequest.getOperation().getInterface();
        String strURL = wsdlInterface.getEndpointURL(wsdlRequest.getEndpoint());
        strURL = PropertyExpansionRequestFilter.expandProperties(context, strURL);
        try {
            postMethod.setURI(new URI(strURL, wsdlRequest.getSettings().getBoolean(HttpSettings.ENCODED_URLS)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String encoding = wsdlRequest.getEncoding();
        SoapVersion soapVersion = wsdlInterface.getSoapVersion();
        postMethod.setRequestHeader("Content-Type", soapVersion.getContentTypeHttpHeader(encoding));
        String soapAction = wsdlRequest.getOperation().getAction();
        soapAction = soapAction == null || soapAction.length() == 0 ? "\"\"" : "\"" + soapAction + "\"";
        postMethod.setRequestHeader("SOAPAction", soapAction);
    }
}

