/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.panels.request.AbstractWsdlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.panels.request.components.SoapMessageXmlEditor;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.panels.teststeps.AssertionsPanel;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.actions.AddAssertionAction;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionError;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.log.JLogList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestRequestDesktopPanel
extends AbstractWsdlRequestDesktopPanel<WsdlTestRequestStep, WsdlTestRequest> {
    private JLogList logArea;
    private InternalTestMonitorListener testMonitorListener = new InternalTestMonitorListener();
    private JButton addAssertionButton;
    protected boolean updatingRequest;
    private InternalSubmitListener submitListener;
    private AssertionsPanel assertionsPanel;
    private JSplitPane outerSplit;

    public WsdlTestRequestDesktopPanel(WsdlTestRequestStep requestStep) {
        super(requestStep);
        this.init(requestStep.getTestRequest());
        SoapUI.getTestMonitor().addTestMonitorListener(this.testMonitorListener);
        this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(requestStep.getTestCase()));
    }

    private Component buildLogPanel() {
        JTabbedPane tabbedPane = new JTabbedPane(4);
        tabbedPane.setTabLayoutPolicy(1);
        this.logArea = new JLogList("Request Log");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.logArea, "Center");
        tabbedPane.addTab("Assertions", this.buildAssertionsPanel());
        tabbedPane.addTab("Request Log", panel);
        return UISupport.createTabPanel(tabbedPane, true);
    }

    private Component buildAssertionsPanel() {
        this.assertionsPanel = new AssertionsPanel((Assertable)this.getRequest()){

            protected void selectError(AssertionError error) {
                SoapMessageXmlEditor editor = WsdlTestRequestDesktopPanel.this.getResponseEditor();
                editor.requestFocus();
            }
        };
        return this.assertionsPanel;
    }

    @Override
    public void setContent(JComponent content) {
        this.outerSplit.setTopComponent(content);
    }

    @Override
    public void removeContent(JComponent content) {
        this.outerSplit.setTopComponent(null);
    }

    @Override
    protected String getHelpUrl() {
        return "http://www.soapui.org/userguide/functional/testrequests.html#The_TestRequest_Editor";
    }

    @Override
    protected JComponent buildContent() {
        JComponent component = super.buildContent();
        this.outerSplit = UISupport.createVerticalSplit();
        this.outerSplit.setTopComponent(component);
        this.outerSplit.setBottomComponent(this.buildLogPanel());
        this.outerSplit.setDividerLocation(350);
        this.outerSplit.setResizeWeight(0.9);
        this.outerSplit.setBorder(null);
        return this.outerSplit;
    }

    @Override
    protected SoapMessageXmlEditor buildRequestEditor() {
        SoapMessageXmlEditor editor = super.buildRequestEditor();
        return editor;
    }

    @Override
    protected SoapMessageXmlEditor buildResponseEditor() {
        SoapMessageXmlEditor editor = super.buildResponseEditor();
        return editor;
    }

    @Override
    protected JComponent buildToolbar() {
        this.addAssertionButton = this.createActionButton(new AddAssertionAction((Assertable)this.getRequest()), true);
        return super.buildToolbar();
    }

    @Override
    protected void insertButtons(JToolBar toolbar) {
        toolbar.add(this.addAssertionButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            enabled = !SoapUI.getTestMonitor().hasRunningLoadTest(((WsdlTestRequestStep)this.getModelItem()).getTestCase());
        }
        super.setEnabled(enabled);
        this.addAssertionButton.setEnabled(enabled);
        this.assertionsPanel.setEnabled(enabled);
        if (SoapUI.getTestMonitor().hasRunningLoadTest(((WsdlTestRequest)this.getRequest()).getTestCase())) {
            ((WsdlTestRequest)this.getRequest()).removeSubmitListener(this.submitListener);
        } else {
            ((WsdlTestRequest)this.getRequest()).addSubmitListener(this.submitListener);
        }
    }

    @Override
    protected Submit doSubmit() throws Request.SubmitException {
        return ((WsdlTestRequest)this.getRequest()).submit(new WsdlTestRunContext((TestStep)this.getModelItem()), true);
    }

    @Override
    protected InternalSubmitListener createSubmitListener() {
        this.submitListener = new InternalSubmitListener();
        return this.submitListener;
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (super.onClose(canCancel)) {
            this.assertionsPanel.release();
            SoapUI.getTestMonitor().removeTestMonitorListener(this.testMonitorListener);
            return true;
        }
        return false;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getRequest() || modelItem == this.getModelItem() || modelItem == ((WsdlTestRequest)this.getRequest()).getOperation() || modelItem == ((WsdlTestRequest)this.getRequest()).getOperation().getInterface() || modelItem == ((WsdlTestRequest)this.getRequest()).getOperation().getInterface().getProject() || modelItem == ((WsdlTestRequestStep)this.getModelItem()).getTestCase() || modelItem == ((WsdlTestRequestStep)this.getModelItem()).getTestCase().getTestSuite();
    }

    @Override
    public String getDescription() {
        return "TestRequest: [" + ((WsdlTestRequestStep)this.getModelItem()).getName() + "] - " + ((WsdlTestRequestStep)this.getModelItem()).getTestStepTitle();
    }

    @Override
    public String getTitle() {
        return ((WsdlTestRequestStep)this.getModelItem()).getTestCase().getName() + " - " + ((WsdlTestRequestStep)this.getModelItem()).getName() + " (" + ((WsdlTestRequestStep)this.getModelItem()).getTestRequest().getOperation().getName() + ")";
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        public void loadTestFinished(LoadTestRunner runner) {
            WsdlTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((WsdlTestRequestStep)WsdlTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        public void loadTestStarted(LoadTestRunner runner) {
            if (runner.getLoadTest().getTestCase() == ((WsdlTestRequestStep)WsdlTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                WsdlTestRequestDesktopPanel.this.setEnabled(false);
            }
        }

        public void testCaseFinished(TestRunner runner) {
            WsdlTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((WsdlTestRequestStep)WsdlTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        public void testCaseStarted(TestRunner runner) {
            if (runner.getTestCase() == ((WsdlTestRequestStep)WsdlTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                WsdlTestRequestDesktopPanel.this.setEnabled(false);
            }
        }
    }

    private class InternalSubmitListener
    extends AbstractWsdlRequestDesktopPanel.InternalSubmitListener {
        private long startTime;
        private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private InternalSubmitListener() {
        }

        public boolean beforeSubmit(Submit submit, SubmitContext context) {
            boolean result = super.beforeSubmit(submit, context);
            this.startTime = System.currentTimeMillis();
            return result;
        }

        protected void logMessages(String message, String infoMessage) {
            super.logMessages(message, infoMessage);
            WsdlTestRequestDesktopPanel.this.logArea.addLine(this.sdf.format(new Date(this.startTime)) + " - " + message);
        }
    }
}

