/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.support.TestRunComponentEnabler;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransfer;
import com.eviware.soapui.impl.wsdl.teststeps.TransferResponseValuesTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepListener;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepProperty;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class TransferResponseValuesDesktopPanel
extends JPanel
implements DesktopPanel {
    private final TransferResponseValuesTestStep transferStep;
    private DefaultListModel listModel;
    private JList transferList;
    private JTextArea sourceArea;
    private JTextArea targetArea;
    private JButton copyButton;
    private JButton deleteButton;
    private JButton declareButton;
    private JComboBox sourcePropertyCombo;
    private JComboBox targetPropertyCombo;
    private JComboBox sourceStepCombo;
    private JComboBox targetStepCombo;
    private DefaultComboBoxModel sourceStepModel;
    private DefaultComboBoxModel targetStepModel;
    private TestStepNameListener sourceTestStepNameListener;
    private TestStepNameListener targetStepNameListener;
    private TestStepPropertiesListener sourceStepPropertiesListener;
    private TestStepPropertiesListener targetStepPropertiesListener;
    private TransferPropertyChangeListener transferPropertyChangeListener = new TransferPropertyChangeListener();
    private boolean selecting;
    private InternalTestSuiteListener testSuiteListener;
    private TestRunComponentEnabler componentEnabler;
    private JCheckBox failTransferCheckBox;
    private JButton runButton;
    private JButton renameButton;
    private JCheckBox setNullCheckBox;
    private JCheckBox transferTextContentCheckBox;
    private JCheckBox ignoreEmptyCheckBox;
    private JCheckBox transferAllCheckBox;

    public TransferResponseValuesDesktopPanel(TransferResponseValuesTestStep testStep) {
        super(new BorderLayout());
        this.transferStep = testStep;
        this.componentEnabler = new TestRunComponentEnabler(testStep.getTestCase());
        this.buildUI();
        this.testSuiteListener = new InternalTestSuiteListener();
        this.transferStep.getTestCase().getTestSuite().addTestSuiteListener(this.testSuiteListener);
    }

    protected void buildUI() {
        JSplitPane splitPane = UISupport.createHorizontalSplit();
        this.listModel = new DefaultListModel();
        for (int c = 0; c < this.transferStep.getTransferCount(); ++c) {
            this.listModel.addElement(this.transferStep.getTransferAt(c).getName());
        }
        this.transferList = new JList(this.listModel);
        this.transferList.setSelectionMode(0);
        this.transferList.addListSelectionListener(new TransferListSelectionListener());
        this.componentEnabler.add(this.transferList);
        JScrollPane listScrollPane = new JScrollPane(this.transferList);
        listScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Transfers"), BorderFactory.createEmptyBorder()));
        splitPane.setLeftComponent(listScrollPane);
        JSplitPane innerSplit = UISupport.createVerticalSplit();
        innerSplit.setBorder(null);
        this.sourceArea = new JUndoableTextArea();
        this.sourceArea.setToolTipText("XPath selection from source property");
        this.sourceArea.setEnabled(false);
        this.sourceArea.getDocument().addDocumentListener(new SourceAreaDocumentListener());
        this.componentEnabler.add(this.sourceArea);
        this.targetArea = new JUndoableTextArea();
        this.targetArea.setToolTipText("XPath target in target property");
        this.targetArea.setEnabled(false);
        this.targetArea.getDocument().addDocumentListener(new TargetAreaDocumentListener());
        this.componentEnabler.add(this.targetArea);
        JPanel sourcePanel = new JPanel(new BorderLayout());
        sourcePanel.add((Component)new JScrollPane(this.sourceArea), "Center");
        JXToolBar toolbar = this.createSourceToolbar();
        sourcePanel.add((Component)toolbar, "North");
        sourcePanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        innerSplit.setTopComponent(sourcePanel);
        JPanel targetPanel = new JPanel(new BorderLayout());
        targetPanel.add((Component)new JScrollPane(this.targetArea), "Center");
        toolbar = this.createTargetToolbar();
        targetPanel.add((Component)toolbar, "North");
        targetPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        innerSplit.setBottomComponent(targetPanel);
        innerSplit.setResizeWeight(0.5);
        innerSplit.setDividerLocation(0.5);
        JPanel panel = this.createTransferOptions();
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add((Component)innerSplit, "Center");
        innerPanel.add((Component)panel, "South");
        splitPane.setRightComponent(innerPanel);
        splitPane.setResizeWeight(0.1);
        splitPane.setDividerLocation(120);
        this.add((Component)splitPane, "Center");
        ButtonBarBuilder builder = this.createButtonBar();
        this.add((Component)builder.getPanel(), "South");
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setPreferredSize(new Dimension(550, 400));
        if (this.listModel.getSize() > 0) {
            this.transferList.setSelectedIndex(0);
        }
        this.componentEnabler.add(this.deleteButton);
        this.componentEnabler.add(this.declareButton);
        this.componentEnabler.add(this.runButton);
        this.componentEnabler.add(this.copyButton);
        this.componentEnabler.add(this.renameButton);
        this.componentEnabler.add(this.failTransferCheckBox);
        this.componentEnabler.add(this.setNullCheckBox);
        this.componentEnabler.add(this.transferTextContentCheckBox);
        this.componentEnabler.add(this.ignoreEmptyCheckBox);
        this.componentEnabler.add(this.transferAllCheckBox);
    }

    protected ButtonBarBuilder createButtonBar() {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JButton(new AddAction()));
        builder.addRelatedGap();
        this.copyButton = new JButton(new CopyAction());
        this.copyButton.setEnabled(false);
        builder.addFixed((JComponent)this.copyButton);
        builder.addRelatedGap();
        this.renameButton = new JButton(new RenameAction());
        this.renameButton.setEnabled(false);
        builder.addFixed((JComponent)this.renameButton);
        builder.addRelatedGap();
        this.deleteButton = new JButton(new DeleteAction());
        this.deleteButton.setEnabled(false);
        builder.addFixed((JComponent)this.deleteButton);
        builder.addRelatedGap();
        this.declareButton = new JButton(new DeclareNamespacesAction());
        this.declareButton.setEnabled(false);
        builder.addFixed((JComponent)this.declareButton);
        builder.addRelatedGap();
        this.runButton = new JButton(new RunAction());
        this.runButton.setEnabled(this.transferStep.getTransferCount() > 0);
        builder.addFixed((JComponent)this.runButton);
        builder.addGlue();
        JButton closeButton = new JButton(new CloseAction());
        builder.addFixed((JComponent)closeButton);
        builder.addRelatedGap();
        builder.addFixed((JComponent)UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/propertytransfers.html#The_PropertyTransfer_Editor")));
        builder.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createMatteBorder(1, 0, 0, 0, Color.WHITE)), BorderFactory.createEmptyBorder(3, 0, 0, 0)));
        return builder;
    }

    protected JPanel createTransferOptions() {
        JPanel panel = new JPanel(new GridLayout(3, 2));
        this.failTransferCheckBox = new JCheckBox("Fail transfer on error", false);
        this.failTransferCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = TransferResponseValuesDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setFailOnError(TransferResponseValuesDesktopPanel.this.failTransferCheckBox.isSelected());
                }
            }
        });
        this.setNullCheckBox = new JCheckBox("Set null on missing source", false);
        this.setNullCheckBox.setToolTipText("Will set target to null if source is missing or null");
        this.setNullCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = TransferResponseValuesDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setSetNullOnMissingSource(TransferResponseValuesDesktopPanel.this.setNullCheckBox.isSelected());
                }
            }
        });
        this.transferTextContentCheckBox = new JCheckBox("Transfer text content", false);
        this.transferTextContentCheckBox.setToolTipText("Will only transfer text content of source/target elements");
        this.transferTextContentCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = TransferResponseValuesDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setTransferTextContent(TransferResponseValuesDesktopPanel.this.transferTextContentCheckBox.isSelected());
                }
            }
        });
        this.ignoreEmptyCheckBox = new JCheckBox("Ignore empty/missing values", false);
        this.ignoreEmptyCheckBox.setToolTipText("Will not transfer empty or missing values");
        this.ignoreEmptyCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = TransferResponseValuesDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setIgnoreEmpty(TransferResponseValuesDesktopPanel.this.ignoreEmptyCheckBox.isSelected());
                }
            }
        });
        this.transferAllCheckBox = new JCheckBox("Transfer to all", false);
        this.transferAllCheckBox.setToolTipText("Will transfer to all matching target selections");
        this.transferAllCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertyTransfer currentTransfer = TransferResponseValuesDesktopPanel.this.getCurrentTransfer();
                if (currentTransfer != null) {
                    currentTransfer.setTransferToAll(TransferResponseValuesDesktopPanel.this.transferAllCheckBox.isSelected());
                }
            }
        });
        panel.add(this.failTransferCheckBox);
        panel.add(this.setNullCheckBox);
        panel.add(this.transferTextContentCheckBox);
        panel.add(this.ignoreEmptyCheckBox);
        panel.add(this.transferAllCheckBox);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return panel;
    }

    protected JXToolBar createTargetToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        toolbar.addFixed(new JLabel("<html><b>Target:</b></html>"));
        toolbar.addGlue();
        this.targetStepCombo.setSelectedItem(null);
        this.targetStepCombo.setToolTipText("The step the value will be transferred to");
        this.targetStepCombo.setEnabled(false);
        this.targetStepCombo.addItemListener(new StepComboItemListener(this.targetPropertyCombo, this.targetStepPropertiesListener));
        this.targetStepCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !TransferResponseValuesDesktopPanel.this.selecting) {
                    String targetStep = (String)TransferResponseValuesDesktopPanel.this.targetStepCombo.getSelectedItem();
                    PropertyTransfer valueTransfer = TransferResponseValuesDesktopPanel.this.getCurrentTransfer();
                    if (valueTransfer != null) {
                        valueTransfer.setTargetStepName(targetStep);
                    }
                }
            }
        });
        toolbar.addFixed(new JLabel("Step:"));
        toolbar.addRelatedGap();
        toolbar.add(this.targetStepCombo);
        toolbar.addRelatedGap();
        toolbar.addFixed(new JLabel("Property:"));
        toolbar.addRelatedGap();
        this.targetPropertyCombo.setToolTipText("The property the value will be transferred to");
        this.targetPropertyCombo.setEnabled(false);
        this.targetPropertyCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !TransferResponseValuesDesktopPanel.this.selecting) {
                    String targetProperty = (String)TransferResponseValuesDesktopPanel.this.targetPropertyCombo.getSelectedItem();
                    PropertyTransfer valueTransfer = TransferResponseValuesDesktopPanel.this.getCurrentTransfer();
                    if (valueTransfer != null) {
                        valueTransfer.setTargetPropertyName(targetProperty);
                    }
                }
            }
        });
        toolbar.add(this.targetPropertyCombo);
        return toolbar;
    }

    protected JXToolBar createSourceToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        toolbar.addFixed(new JLabel("<html><b>Source:</b></html>"));
        toolbar.addGlue();
        this.sourcePropertyCombo = new JComboBox();
        this.sourceStepModel = new DefaultComboBoxModel();
        this.sourceStepCombo = new JComboBox(this.sourceStepModel);
        this.sourceTestStepNameListener = new TestStepNameListener(this.sourceStepModel);
        this.componentEnabler.add(this.sourcePropertyCombo);
        this.componentEnabler.add(this.sourceStepCombo);
        this.targetPropertyCombo = new JComboBox();
        this.targetStepModel = new DefaultComboBoxModel();
        this.targetStepCombo = new JComboBox(this.targetStepModel);
        this.targetStepNameListener = new TestStepNameListener(this.targetStepModel);
        this.componentEnabler.add(this.targetPropertyCombo);
        this.componentEnabler.add(this.targetStepCombo);
        this.sourceStepPropertiesListener = new TestStepPropertiesListener(this.sourcePropertyCombo);
        this.targetStepPropertiesListener = new TestStepPropertiesListener(this.targetPropertyCombo);
        for (int c = 0; c < this.transferStep.getTestCase().getTestStepCount(); ++c) {
            WsdlTestStep testStep = this.transferStep.getTestCase().getTestStepAt(c);
            if (testStep == this.transferStep) continue;
            testStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, this.sourceTestStepNameListener);
            testStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, this.targetStepNameListener);
            String nm = testStep.getName();
            this.sourceStepModel.addElement(nm);
            this.targetStepModel.addElement(nm);
        }
        this.sourceStepCombo.setSelectedItem(null);
        this.sourceStepCombo.setToolTipText("The step the value will be transferred from");
        this.sourceStepCombo.setEnabled(false);
        this.sourceStepCombo.addItemListener(new StepComboItemListener(this.sourcePropertyCombo, this.sourceStepPropertiesListener));
        this.sourceStepCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !TransferResponseValuesDesktopPanel.this.selecting) {
                    String sourceStep = (String)TransferResponseValuesDesktopPanel.this.sourceStepCombo.getSelectedItem();
                    PropertyTransfer valueTransfer = TransferResponseValuesDesktopPanel.this.getCurrentTransfer();
                    if (valueTransfer != null) {
                        valueTransfer.setSourceStepName(sourceStep);
                    }
                }
            }
        });
        toolbar.addFixed(new JLabel("Step:"));
        toolbar.addRelatedGap();
        toolbar.add(this.sourceStepCombo);
        toolbar.addRelatedGap();
        toolbar.addFixed(new JLabel("Property:"));
        toolbar.addRelatedGap();
        this.sourcePropertyCombo.setToolTipText("The property the value will be transferred from");
        this.sourcePropertyCombo.setEnabled(false);
        this.sourcePropertyCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !TransferResponseValuesDesktopPanel.this.selecting) {
                    String sourceProperty = (String)TransferResponseValuesDesktopPanel.this.sourcePropertyCombo.getSelectedItem();
                    PropertyTransfer valueTransfer = TransferResponseValuesDesktopPanel.this.getCurrentTransfer();
                    if (valueTransfer != null) {
                        valueTransfer.setSourcePropertyName(sourceProperty);
                    }
                }
            }
        });
        toolbar.add(this.sourcePropertyCombo);
        return toolbar;
    }

    public PropertyTransfer getCurrentTransfer() {
        int ix = this.transferList.getSelectedIndex();
        return ix == -1 ? null : this.transferStep.getTransferAt(ix);
    }

    public ModelItem getModelItem() {
        return this.transferStep;
    }

    public boolean onClose(boolean canCancel) {
        WsdlTestStep step;
        this.transferStep.getTestCase().getTestSuite().removeTestSuiteListener(this.testSuiteListener);
        PropertyTransfer transfer = this.getCurrentTransfer();
        if (transfer != null) {
            transfer.removePropertyChangeListener(this.transferPropertyChangeListener);
        }
        for (int c = 0; c < this.transferStep.getTestCase().getTestStepCount(); ++c) {
            WsdlTestStep testStep = this.transferStep.getTestCase().getTestStepAt(c);
            testStep.removePropertyChangeListener(TestStep.NAME_PROPERTY, this.sourceTestStepNameListener);
            testStep.removePropertyChangeListener(TestStep.NAME_PROPERTY, this.targetStepNameListener);
        }
        Object item = this.sourceStepCombo.getSelectedItem();
        if (item != null && (step = this.transferStep.getTestCase().getTestStepByName((String)item)) != null) {
            step.removeTestStepListener(this.sourceStepPropertiesListener);
        }
        if ((item = this.targetStepCombo.getSelectedItem()) != null && (step = this.transferStep.getTestCase().getTestStepByName((String)item)) != null) {
            step.removeTestStepListener(this.targetStepPropertiesListener);
        }
        this.componentEnabler.release();
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.transferStep || modelItem == this.transferStep.getTestCase() || modelItem == this.transferStep.getTestCase().getTestSuite() || modelItem == this.transferStep.getTestCase().getTestSuite().getProject();
    }

    public String getTitle() {
        return this.transferStep.getTestCase().getName() + " - " + this.transferStep.getName();
    }

    public String getDescription() {
        return "Property Transfer: [" + this.transferStep.getName() + "] - " + this.transferStep.getTestStepTitle();
    }

    public Icon getIcon() {
        return this.getModelItem().getIcon();
    }

    public boolean selectTransfer(PropertyTransfer transfer) {
        for (int c = 0; c < this.transferStep.getTransferCount(); ++c) {
            if (this.transferStep.getTransferAt(c) != transfer) continue;
            this.transferList.setSelectedIndex(c);
            return true;
        }
        return false;
    }

    private final class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.getDesktop().closeDesktopPanel(TransferResponseValuesDesktopPanel.this.transferStep);
        }
    }

    private final class RunAction
    extends AbstractAction {
        public RunAction() {
            super("Run");
        }

        public void actionPerformed(ActionEvent e) {
            if (TransferResponseValuesDesktopPanel.this.listModel.getSize() == 0) {
                UISupport.showErrorMessage("Missing transfers!");
                return;
            }
            WsdlTestRunContext context = new WsdlTestRunContext(TransferResponseValuesDesktopPanel.this.transferStep);
            TransferResponseValuesTestStep.ValueTransferResult result = (TransferResponseValuesTestStep.ValueTransferResult)TransferResponseValuesDesktopPanel.this.transferStep.run(null, context);
            if (result.getStatus() == TestStepResult.TestStepStatus.FAILED) {
                StringBuffer msg = new StringBuffer();
                String[] messages = result.getMessages();
                for (int c = 0; c < result.getTransferCount() && c < messages.length; ++c) {
                    msg.append(messages[c]).append(':').append(Arrays.toString(result.getTransferredValuesAt(c))).append("\r\n");
                }
                UISupport.showErrorMessage(msg.toString());
            } else {
                UISupport.showInfoMessage("Transfers completed with status " + (Object)((Object)result.getStatus()));
            }
        }
    }

    private final class DeclareNamespacesAction
    extends AbstractAction {
        public DeclareNamespacesAction() {
            super("Declare");
            this.putValue("ShortDescription", "Declare available response/request namespaces in source/target expressions");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TestStep previousStep = TransferResponseValuesDesktopPanel.this.getCurrentTransfer().getSourceStep();
                if (previousStep instanceof WsdlTestRequestStep) {
                    WsdlTestRequest testRequest = ((WsdlTestRequestStep)previousStep).getTestRequest();
                    TransferResponseValuesDesktopPanel.this.sourceArea.setText(XmlUtils.declareXPathNamespaces(testRequest.getOperation().getInterface()) + TransferResponseValuesDesktopPanel.this.sourceArea.getText());
                } else {
                    UISupport.showErrorMessage("Source step is not a request");
                }
                TestStep nextStep = TransferResponseValuesDesktopPanel.this.getCurrentTransfer().getTargetStep();
                if (nextStep instanceof WsdlTestRequestStep) {
                    WsdlTestRequest testRequest = ((WsdlTestRequestStep)nextStep).getTestRequest();
                    TransferResponseValuesDesktopPanel.this.targetArea.setText(XmlUtils.declareXPathNamespaces(testRequest.getOperation().getInterface()) + TransferResponseValuesDesktopPanel.this.targetArea.getText());
                } else {
                    UISupport.showErrorMessage("Target step is not a request");
                }
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
                e1.printStackTrace();
            }
        }
    }

    private final class RenameAction
    extends AbstractAction {
        public RenameAction() {
            super("Rename");
        }

        public void actionPerformed(ActionEvent e) {
            PropertyTransfer transfer = TransferResponseValuesDesktopPanel.this.getCurrentTransfer();
            String newName = UISupport.prompt("Specify new name for transfer", "Rename Transfer", transfer.getName());
            if (!transfer.getName().equals(newName)) {
                TransferResponseValuesDesktopPanel.this.listModel.setElementAt(newName, TransferResponseValuesDesktopPanel.this.transferList.getSelectedIndex());
                transfer.setName(newName);
            }
        }
    }

    private final class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("Delete");
        }

        public void actionPerformed(ActionEvent e) {
            if (UISupport.confirm("Delete selected transfer", "Delete Transfer")) {
                TransferResponseValuesDesktopPanel.this.transferList.setSelectedIndex(-1);
                int ix = TransferResponseValuesDesktopPanel.this.transferList.getSelectedIndex();
                TransferResponseValuesDesktopPanel.this.transferStep.removeTransferAt(ix);
                TransferResponseValuesDesktopPanel.this.listModel.remove(ix);
                if (TransferResponseValuesDesktopPanel.this.listModel.getSize() > 0) {
                    TransferResponseValuesDesktopPanel.this.transferList.setSelectedIndex(ix > TransferResponseValuesDesktopPanel.this.listModel.getSize() - 1 ? TransferResponseValuesDesktopPanel.this.listModel.getSize() - 1 : ix);
                }
            }
        }
    }

    private final class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
        }

        public void actionPerformed(ActionEvent e) {
            int ix = TransferResponseValuesDesktopPanel.this.transferList.getSelectedIndex();
            PropertyTransfer config = TransferResponseValuesDesktopPanel.this.transferStep.getTransferAt(ix);
            String name = UISupport.prompt("Specify name for value transfer", "Copy Transfer", config.getName());
            if (name == null || name.trim().length() == 0) {
                return;
            }
            PropertyTransfer transfer = TransferResponseValuesDesktopPanel.this.transferStep.addTransfer(name);
            transfer.setSourceStepName(config.getSourceStepName());
            transfer.setSourcePropertyName(config.getSourcePropertyName());
            transfer.setSourcePath(config.getSourcePath());
            transfer.setTargetStepName(config.getTargetStepName());
            transfer.setTargetPropertyName(config.getTargetPropertyName());
            transfer.setTargetPath(config.getTargetPath());
            TransferResponseValuesDesktopPanel.this.listModel.addElement(name);
            TransferResponseValuesDesktopPanel.this.transferList.setSelectedIndex(TransferResponseValuesDesktopPanel.this.listModel.getSize() - 1);
        }
    }

    private final class AddAction
    extends AbstractAction {
        public AddAction() {
            super("Add");
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify name for value transfer", "Add Transfer", "");
            if (name == null || name.trim().length() == 0) {
                return;
            }
            TransferResponseValuesDesktopPanel.this.transferStep.addTransfer(name);
            TransferResponseValuesDesktopPanel.this.listModel.addElement(name);
            TransferResponseValuesDesktopPanel.this.transferList.setSelectedIndex(TransferResponseValuesDesktopPanel.this.listModel.getSize() - 1);
        }
    }

    private class TransferPropertyChangeListener
    implements PropertyChangeListener {
        private TransferPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object selectedItem;
            Object newValue = evt.getNewValue();
            if (evt.getPropertyName().equals(PropertyTransfer.SOURCE_PATH_PROPERTY)) {
                if (!TransferResponseValuesDesktopPanel.this.sourceArea.getText().equals(newValue)) {
                    TransferResponseValuesDesktopPanel.this.sourceArea.setText((String)newValue);
                }
            } else if (evt.getPropertyName().equals(PropertyTransfer.TARGET_PATH_PROPERTY)) {
                if (!TransferResponseValuesDesktopPanel.this.targetArea.getText().equals(newValue)) {
                    TransferResponseValuesDesktopPanel.this.targetArea.setText((String)newValue);
                }
            } else if (evt.getPropertyName().equals(PropertyTransfer.SOURCE_STEP_PROPERTY)) {
                Object selectedItem2 = TransferResponseValuesDesktopPanel.this.sourceStepCombo.getSelectedItem();
                if (newValue == null || selectedItem2 == null || !selectedItem2.equals(newValue)) {
                    TransferResponseValuesDesktopPanel.this.selecting = true;
                    TransferResponseValuesDesktopPanel.this.sourceStepCombo.setSelectedItem(newValue);
                    TransferResponseValuesDesktopPanel.this.selecting = false;
                }
            } else if (evt.getPropertyName().equals(PropertyTransfer.TARGET_STEP_PROPERTY)) {
                Object selectedItem3 = TransferResponseValuesDesktopPanel.this.targetStepCombo.getSelectedItem();
                if (newValue == null || selectedItem3 == null || !selectedItem3.equals(newValue)) {
                    TransferResponseValuesDesktopPanel.this.selecting = true;
                    TransferResponseValuesDesktopPanel.this.targetStepCombo.setSelectedItem(newValue);
                    TransferResponseValuesDesktopPanel.this.selecting = false;
                }
            } else if (evt.getPropertyName().equals(PropertyTransfer.SOURCE_TYPE_PROPERTY)) {
                Object selectedItem4 = TransferResponseValuesDesktopPanel.this.sourcePropertyCombo.getSelectedItem();
                if (selectedItem4 == null || !selectedItem4.equals(newValue)) {
                    TransferResponseValuesDesktopPanel.this.sourcePropertyCombo.setSelectedItem(newValue);
                }
            } else if (evt.getPropertyName().equals(PropertyTransfer.TARGET_TYPE_PROPERTY) && ((selectedItem = TransferResponseValuesDesktopPanel.this.targetPropertyCombo.getSelectedItem()) == null || !selectedItem.equals(newValue))) {
                TransferResponseValuesDesktopPanel.this.targetPropertyCombo.setSelectedItem(newValue);
            }
        }
    }

    private final class TransferListSelectionListener
    implements ListSelectionListener {
        private PropertyTransfer transfer;

        private TransferListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            TransferResponseValuesDesktopPanel.this.selecting = true;
            if (this.transfer != null) {
                this.transfer.removePropertyChangeListener(TransferResponseValuesDesktopPanel.this.transferPropertyChangeListener);
            }
            this.transfer = TransferResponseValuesDesktopPanel.this.getCurrentTransfer();
            if (this.transfer == null) {
                TransferResponseValuesDesktopPanel.this.sourceArea.setText("");
                TransferResponseValuesDesktopPanel.this.targetArea.setText("");
                TransferResponseValuesDesktopPanel.this.sourcePropertyCombo.removeAllItems();
                TransferResponseValuesDesktopPanel.this.targetPropertyCombo.removeAllItems();
                TransferResponseValuesDesktopPanel.this.sourceStepCombo.setSelectedIndex(-1);
                TransferResponseValuesDesktopPanel.this.targetStepCombo.setSelectedIndex(-1);
            } else {
                this.transfer.addPropertyChangeListener(TransferResponseValuesDesktopPanel.this.transferPropertyChangeListener);
                TransferResponseValuesDesktopPanel.this.sourceArea.setText(this.transfer.getSourcePath());
                TransferResponseValuesDesktopPanel.this.targetArea.setText(this.transfer.getTargetPath());
                TransferResponseValuesDesktopPanel.this.sourceStepCombo.setSelectedItem(this.transfer.getSourceStepName());
                TransferResponseValuesDesktopPanel.this.sourcePropertyCombo.setSelectedItem(this.transfer.getSourcePropertyName());
                TransferResponseValuesDesktopPanel.this.targetStepCombo.setSelectedItem(this.transfer.getTargetStepName());
                TransferResponseValuesDesktopPanel.this.targetPropertyCombo.setSelectedItem(this.transfer.getTargetPropertyName());
                TransferResponseValuesDesktopPanel.this.failTransferCheckBox.setSelected(this.transfer.getFailOnError());
                TransferResponseValuesDesktopPanel.this.setNullCheckBox.setSelected(this.transfer.getSetNullOnMissingSource());
                TransferResponseValuesDesktopPanel.this.transferTextContentCheckBox.setSelected(this.transfer.getTransferTextContent());
                TransferResponseValuesDesktopPanel.this.ignoreEmptyCheckBox.setSelected(this.transfer.getIgnoreEmpty());
                TransferResponseValuesDesktopPanel.this.transferAllCheckBox.setSelected(this.transfer.getTransferToAll());
            }
            TransferResponseValuesDesktopPanel.this.copyButton.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.renameButton.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.deleteButton.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.declareButton.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.sourceStepCombo.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.targetStepCombo.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.sourceArea.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.targetArea.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.failTransferCheckBox.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.setNullCheckBox.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.transferTextContentCheckBox.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.ignoreEmptyCheckBox.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.transferAllCheckBox.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.runButton.setEnabled(TransferResponseValuesDesktopPanel.this.transferList.getModel().getSize() > 0);
            TransferResponseValuesDesktopPanel.this.sourcePropertyCombo.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.targetPropertyCombo.setEnabled(this.transfer != null);
            TransferResponseValuesDesktopPanel.this.selecting = false;
        }
    }

    private final class TargetAreaDocumentListener
    extends DocumentListenerAdapter {
        private TargetAreaDocumentListener() {
        }

        public void update(Document document) {
            int ix = TransferResponseValuesDesktopPanel.this.transferList.getSelectedIndex();
            if (ix != -1) {
                TransferResponseValuesDesktopPanel.this.transferStep.getTransferAt(ix).setTargetPath(TransferResponseValuesDesktopPanel.this.targetArea.getText());
            }
        }
    }

    private final class SourceAreaDocumentListener
    extends DocumentListenerAdapter {
        private SourceAreaDocumentListener() {
        }

        public void update(Document document) {
            int ix = TransferResponseValuesDesktopPanel.this.transferList.getSelectedIndex();
            if (ix != -1) {
                TransferResponseValuesDesktopPanel.this.transferStep.getTransferAt(ix).setSourcePath(TransferResponseValuesDesktopPanel.this.sourceArea.getText());
            }
        }
    }

    private final class StepComboItemListener
    implements ItemListener {
        private final JComboBox propertyCombo;
        private final TestStepPropertiesListener testStepPropertiesListener;

        public StepComboItemListener(JComboBox propertyCombo, TestStepPropertiesListener testStepPropertiesListener) {
            this.propertyCombo = propertyCombo;
            this.testStepPropertiesListener = testStepPropertiesListener;
        }

        public void itemStateChanged(ItemEvent e) {
            WsdlTestStep step;
            if (e.getStateChange() == 2 && (step = TransferResponseValuesDesktopPanel.this.transferStep.getTestCase().getTestStepByName((String)e.getItem())) != null) {
                step.removeTestStepListener(this.testStepPropertiesListener);
            }
            if (e.getStateChange() == 1) {
                String[] propertyNames;
                String selectedItem = (String)e.getItem();
                WsdlTestStep step2 = TransferResponseValuesDesktopPanel.this.transferStep.getTestCase().getTestStepByName(selectedItem);
                String[] stringArray = propertyNames = step2 == null ? new String[]{} : step2.getPropertyNames();
                if (this.propertyCombo == TransferResponseValuesDesktopPanel.this.targetPropertyCombo) {
                    ArrayList<String> names = new ArrayList<String>();
                    for (String name : propertyNames) {
                        TestStepProperty property = step2.getProperty(name);
                        if (property.isReadOnly()) continue;
                        names.add(property.getName());
                    }
                    propertyNames = names.toArray(new String[names.size()]);
                }
                this.propertyCombo.setModel(new DefaultComboBoxModel<String>(propertyNames));
                this.propertyCombo.setEnabled(propertyNames.length > 0);
                if (this.propertyCombo == TransferResponseValuesDesktopPanel.this.targetPropertyCombo) {
                    this.propertyCombo.setSelectedItem(TransferResponseValuesDesktopPanel.this.getCurrentTransfer().getTargetPropertyName());
                } else {
                    this.propertyCombo.setSelectedItem(TransferResponseValuesDesktopPanel.this.getCurrentTransfer().getSourcePropertyName());
                }
                step2.addTestStepListener(this.testStepPropertiesListener);
            } else {
                this.propertyCombo.removeAllItems();
                this.propertyCombo.setEnabled(false);
            }
        }
    }

    private final class TestStepNameListener
    implements PropertyChangeListener {
        private final DefaultComboBoxModel model;

        public TestStepNameListener(DefaultComboBoxModel model) {
            this.model = model;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object oldItem = evt.getOldValue();
            int stepIndex = this.model.getIndexOf(oldItem);
            if (stepIndex != -1) {
                Object selectedItem = this.model.getSelectedItem();
                Object newItem = evt.getNewValue();
                TransferResponseValuesDesktopPanel.this.selecting = true;
                this.model.removeElementAt(stepIndex);
                this.model.insertElementAt(newItem, stepIndex);
                TransferResponseValuesDesktopPanel.this.selecting = false;
                if (selectedItem.equals(oldItem)) {
                    this.model.setSelectedItem(newItem);
                }
            }
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testStepAdded(TestStep testStep, int index) {
            if (testStep.getTestCase() == TransferResponseValuesDesktopPanel.this.transferStep.getTestCase()) {
                TransferResponseValuesDesktopPanel.this.sourceStepModel.addElement(testStep.getName());
                TransferResponseValuesDesktopPanel.this.targetStepModel.addElement(testStep.getName());
                testStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, TransferResponseValuesDesktopPanel.this.sourceTestStepNameListener);
                testStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, TransferResponseValuesDesktopPanel.this.targetStepNameListener);
            }
        }

        public void testStepMoved(TestStep testStep, int fromIndex, int offset) {
            if (testStep.getTestCase() == TransferResponseValuesDesktopPanel.this.transferStep.getTestCase()) {
                String testStepName = testStep.getName();
                if (TransferResponseValuesDesktopPanel.this.sourceStepModel.getIndexOf(testStepName) == fromIndex) {
                    String sourceStep = (String)TransferResponseValuesDesktopPanel.this.sourceStepCombo.getSelectedItem();
                    String sourceProperty = (String)TransferResponseValuesDesktopPanel.this.sourcePropertyCombo.getSelectedItem();
                    TransferResponseValuesDesktopPanel.this.sourceStepModel.removeElementAt(fromIndex);
                    if (fromIndex + offset > TransferResponseValuesDesktopPanel.this.sourceStepModel.getSize()) {
                        TransferResponseValuesDesktopPanel.this.sourceStepModel.addElement(testStepName);
                    } else {
                        TransferResponseValuesDesktopPanel.this.sourceStepModel.insertElementAt(testStepName, fromIndex + offset);
                    }
                    TransferResponseValuesDesktopPanel.this.sourceStepCombo.setSelectedItem(sourceStep);
                    TransferResponseValuesDesktopPanel.this.sourcePropertyCombo.setSelectedItem(sourceProperty);
                }
                if (TransferResponseValuesDesktopPanel.this.targetStepModel.getIndexOf(testStepName) == fromIndex) {
                    String targetStep = (String)TransferResponseValuesDesktopPanel.this.targetStepCombo.getSelectedItem();
                    String targetProperty = (String)TransferResponseValuesDesktopPanel.this.targetPropertyCombo.getSelectedItem();
                    TransferResponseValuesDesktopPanel.this.targetStepModel.removeElementAt(fromIndex);
                    if (fromIndex + offset > TransferResponseValuesDesktopPanel.this.targetStepModel.getSize()) {
                        TransferResponseValuesDesktopPanel.this.targetStepModel.addElement(testStepName);
                    } else {
                        TransferResponseValuesDesktopPanel.this.targetStepModel.insertElementAt(testStepName, fromIndex + offset);
                    }
                    TransferResponseValuesDesktopPanel.this.targetStepCombo.setSelectedItem(targetStep);
                    TransferResponseValuesDesktopPanel.this.targetPropertyCombo.setSelectedItem(targetProperty);
                }
            }
        }

        public void testStepRemoved(TestStep testStep, int index) {
            if (testStep.getTestCase() == TransferResponseValuesDesktopPanel.this.transferStep.getTestCase()) {
                TransferResponseValuesDesktopPanel.this.sourceStepModel.removeElement(testStep.getName());
                TransferResponseValuesDesktopPanel.this.targetStepModel.removeElement(testStep.getName());
                testStep.removePropertyChangeListener(TestStep.NAME_PROPERTY, TransferResponseValuesDesktopPanel.this.sourceTestStepNameListener);
                testStep.removePropertyChangeListener(TestStep.NAME_PROPERTY, TransferResponseValuesDesktopPanel.this.targetStepNameListener);
            }
        }
    }

    private static final class TestStepPropertiesListener
    implements WsdlTestStepListener {
        private final JComboBox combo;

        public TestStepPropertiesListener(JComboBox combo) {
            this.combo = combo;
        }

        public void propertyAdded(String name) {
            this.combo.addItem(name);
            this.combo.setEnabled(true);
        }

        public void propertyRemoved(String name) {
            if (this.combo.getSelectedItem().equals(name)) {
                this.combo.setSelectedItem(null);
            }
            this.combo.removeItem(name);
            this.combo.setEnabled(this.combo.getItemCount() > 0);
        }

        public void propertyRenamed(String oldName, String newName) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.combo.getModel();
            int stepIndex = model.getIndexOf(oldName);
            if (stepIndex != -1) {
                Object selectedItem = model.getSelectedItem();
                model.removeElementAt(stepIndex);
                model.insertElementAt(newName, stepIndex);
                if (selectedItem.equals(oldName)) {
                    model.setSelectedItem(newName);
                }
            }
        }

        public void propertyValueChanged(String name, String oldValue, String newValue) {
        }
    }
}

