/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.support.MockTestRunContext;
import com.eviware.soapui.impl.wsdl.panels.support.MockTestRunner;
import com.eviware.soapui.impl.wsdl.panels.support.TestRunComponentEnabler;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlGroovyScriptTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JEditorStatusBarWithProgress;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.log.JLogList;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;

public class GroovyScriptStepDesktopPanel
extends JPanel
implements DesktopPanel {
    private final WsdlGroovyScriptTestStep groovyStep;
    private GroovyEditor editor;
    private JSplitPane mainSplit;
    private JLogList logArea;
    private Logger logger;
    private TestRunComponentEnabler componentEnabler;
    private RunAction runAction = new RunAction();
    private JEditorStatusBarWithProgress statusBar;
    private SettingsListener settingsListener;

    public GroovyScriptStepDesktopPanel(WsdlGroovyScriptTestStep groovyStep) {
        super(new BorderLayout());
        this.groovyStep = groovyStep;
        this.componentEnabler = new TestRunComponentEnabler(groovyStep.getTestCase());
        this.buildUI();
        this.setPreferredSize(new Dimension(600, 440));
        this.logger = Logger.getLogger((String)groovyStep.getName());
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                GroovyScriptStepDesktopPanel.this.editor.requestFocusInWindow();
            }
        });
    }

    private void buildUI() {
        this.editor = new GroovyEditor(new ScriptStepGroovyEditorModel());
        this.logArea = new JLogList("Groovy Test Log");
        this.logArea.addLogger(this.groovyStep.getName(), true);
        this.logArea.getLogList().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                String value = GroovyScriptStepDesktopPanel.this.logArea.getLogList().getSelectedValue().toString();
                if (value == null) {
                    return;
                }
                GroovyScriptStepDesktopPanel.this.editor.selectError(value);
            }
        });
        this.mainSplit = UISupport.createVerticalSplit(new JScrollPane(this.editor), this.logArea);
        this.mainSplit.setDividerLocation(280);
        this.mainSplit.setResizeWeight(0.8);
        this.add((Component)this.mainSplit, "Center");
        this.add((Component)this.buildToolbar(), "North");
        this.add(this.buildStatusBar(), "South");
        this.componentEnabler.add(this.editor);
    }

    private Component buildStatusBar() {
        this.statusBar = new JEditorStatusBarWithProgress(this.editor);
        return this.statusBar;
    }

    private JComponent buildToolbar() {
        JXToolBar toolBar = UISupport.createToolbar();
        JButton runButton = UISupport.createToolbarButton(this.runAction);
        toolBar.add(runButton);
        toolBar.add(Box.createHorizontalGlue());
        JLabel label = new JLabel("<html>Script is invoked with <code>log</code>, <code>context</code> and <code>testRunner</code> variables</html>");
        label.setToolTipText(label.getText());
        label.setMaximumSize(label.getPreferredSize());
        toolBar.add(label);
        toolBar.addRelatedGap();
        toolBar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/groovystep.html#The_Groovy_Script_Editor")));
        this.componentEnabler.add(runButton);
        return toolBar;
    }

    public ModelItem getModelItem() {
        return this.groovyStep;
    }

    public boolean onClose(boolean canCancel) {
        this.componentEnabler.release();
        SoapUI.getSettings().removeSettingsListener(this.settingsListener);
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.groovyStep || modelItem == this.groovyStep.getTestCase() || modelItem == this.groovyStep.getTestCase().getTestSuite() || modelItem == this.groovyStep.getTestCase().getTestSuite().getProject();
    }

    public String getTitle() {
        return this.groovyStep.getTestCase().getName() + " - " + this.groovyStep.getName();
    }

    public String getDescription() {
        return "Goto: [" + this.groovyStep.getName() + "] - " + this.groovyStep.getTestStepTitle();
    }

    public Icon getIcon() {
        return this.getModelItem().getIcon();
    }

    private class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_groovy_script.gif"));
            this.putValue("ShortDescription", "Runs this script using a mock testRunner and testContext");
        }

        public void actionPerformed(ActionEvent e) {
            MockTestRunner mockTestRunner = new MockTestRunner(GroovyScriptStepDesktopPanel.this.groovyStep.getTestCase(), GroovyScriptStepDesktopPanel.this.logger);
            GroovyScriptStepDesktopPanel.this.statusBar.setIndeterminate(true);
            WsdlTestStepResult result = (WsdlTestStepResult)GroovyScriptStepDesktopPanel.this.groovyStep.run(mockTestRunner, new MockTestRunContext(mockTestRunner, GroovyScriptStepDesktopPanel.this.groovyStep));
            GroovyScriptStepDesktopPanel.this.statusBar.setIndeterminate(false);
            if (result.getError() != null) {
                String message = result.getError().getMessage();
                GroovyScriptStepDesktopPanel.this.editor.selectError(message);
                UISupport.showErrorMessage(result.getError().toString());
                GroovyScriptStepDesktopPanel.this.editor.requestFocus();
            }
        }
    }

    private class ScriptStepGroovyEditorModel
    implements GroovyEditorModel {
        private ScriptStepGroovyEditorModel() {
        }

        public String[] getKeywords() {
            return new String[]{"log", "context", "testRunner"};
        }

        public Action getRunAction() {
            return GroovyScriptStepDesktopPanel.this.runAction;
        }

        public String getScript() {
            return GroovyScriptStepDesktopPanel.this.groovyStep.getScript();
        }

        public void setScript(String text) {
            GroovyScriptStepDesktopPanel.this.groovyStep.setScript(text);
        }

        public Settings getSettings() {
            return SoapUI.getSettings();
        }
    }
}

