/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.actions.testcase.TestCaseOptionsAction;
import com.eviware.soapui.impl.wsdl.panels.support.ProgressBarAdapter;
import com.eviware.soapui.impl.wsdl.panels.testcase.TestCaseLog;
import com.eviware.soapui.impl.wsdl.panels.testcase.TestStepList;
import com.eviware.soapui.impl.wsdl.panels.testcase.actions.SetCredentialsAction;
import com.eviware.soapui.impl.wsdl.panels.testcase.actions.SetEndpointAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.PropertiesMap;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.ComponentBag;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestCaseDesktopPanel
extends ModelItemDesktopPanel<WsdlTestCase> {
    private JProgressBar progressBar;
    private TestStepList testStepList;
    private InternalTestRunListener testRunListener = new InternalTestRunListener();
    private JButton runButton;
    private JButton cancelButton;
    private TestRunner runner;
    private JButton setEndpointButton;
    private JButton setCredentialsButton;
    private JButton optionsButton;
    private ComponentBag stateDependantComponents = new ComponentBag();
    private TestCaseLog testCaseLog;
    private JToggleButton loopButton;
    private ProgressBarAdapter progressBarAdapter;
    private InternalTestMonitorListener testMonitorListener;
    public boolean canceled;
    private JTextArea descriptionArea;

    public WsdlTestCaseDesktopPanel(WsdlTestCase testCase) {
        super(testCase);
        this.buildUI();
        this.setPreferredSize(new Dimension(250, 500));
        this.setRunningState();
        testCase.addTestRunListener(this.testRunListener);
        this.progressBarAdapter = new ProgressBarAdapter(this.progressBar, testCase);
        this.testMonitorListener = new InternalTestMonitorListener();
        SoapUI.getTestMonitor().addTestMonitorListener(this.testMonitorListener);
    }

    private void setRunningState() {
        this.stateDependantComponents.setEnabled(!SoapUI.getTestMonitor().hasRunningLoadTest((TestCase)this.getModelItem()));
    }

    private void buildUI() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildToolbar(), "First");
        panel.add(this.buildRunnerBar(), "Center");
        this.add((Component)panel, "North");
        JSplitPane splitPane = UISupport.createVerticalSplit();
        splitPane.setTopComponent(this.buildTestStepList());
        splitPane.setBottomComponent(this.buildTestLog());
        splitPane.setDividerLocation(0.7);
        splitPane.setDividerLocation(250);
        this.add((Component)splitPane, "Center");
        this.add((Component)new JLabel("--"), "Last");
    }

    private Component buildTestLog() {
        this.testCaseLog = new TestCaseLog();
        this.stateDependantComponents.add(this.testCaseLog);
        return this.testCaseLog;
    }

    private Component buildTestStepList() {
        this.testStepList = new TestStepList((WsdlTestCase)this.getModelItem());
        this.stateDependantComponents.add(this.testStepList);
        JTabbedPane tabs = new JTabbedPane(1);
        tabs.addTab("Test Steps", new JScrollPane(this.testStepList));
        tabs.addTab("Description", this.buildDescriptionPanel());
        return UISupport.createTabPanel(tabs, false);
    }

    private Component buildDescriptionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.descriptionArea = new JTextArea(((WsdlTestCase)this.getModelItem()).getDescription());
        this.descriptionArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                ((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem()).setDescription(WsdlTestCaseDesktopPanel.this.descriptionArea.getText());
            }
        });
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        panel.add((Component)new JScrollPane(this.descriptionArea), "Center");
        return panel;
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.runButton = UISupport.createToolbarButton(new RunTestCaseAction());
        this.optionsButton = UISupport.createToolbarButton(new TestCaseOptionsAction((WsdlTestCase)this.getModelItem()));
        this.optionsButton.setText(null);
        this.cancelButton = UISupport.createToolbarButton(new CancelRunTestCaseAction(), false);
        this.loopButton = new JToggleButton(UISupport.createImageIcon("/loop.gif"));
        this.loopButton.setPreferredSize(UISupport.getPreferredButtonSize());
        this.loopButton.setToolTipText("Loop TestCase continuously");
        this.setCredentialsButton = UISupport.createToolbarButton(new SetCredentialsAction((WsdlTestCase)this.getModelItem()));
        this.setEndpointButton = UISupport.createToolbarButton(new SetEndpointAction((WsdlTestCase)this.getModelItem()));
        this.stateDependantComponents.add(this.runButton);
        this.stateDependantComponents.add(this.optionsButton);
        this.stateDependantComponents.add(this.cancelButton);
        this.stateDependantComponents.add(this.setCredentialsButton);
        this.stateDependantComponents.add(this.setEndpointButton);
        ((Container)toolbar).add(this.runButton);
        ((Container)toolbar).add(this.cancelButton);
        ((Container)toolbar).add(this.loopButton);
        ((Container)toolbar).add(Box.createHorizontalGlue());
        ((Container)toolbar).add(this.setCredentialsButton);
        ((Container)toolbar).add(this.setEndpointButton);
        ((Container)toolbar).add(this.optionsButton);
        ((Container)toolbar).add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/testcases.html#The_TestCase_Editor")));
        return toolbar;
    }

    private Component buildRunnerBar() {
        this.progressBar = new JProgressBar(0, ((WsdlTestCase)this.getModelItem()).getTestStepCount());
        return UISupport.createProgressBarPanel(this.progressBar, 10, false);
    }

    private void runTestCase() {
        if (this.canceled) {
            this.runButton.setEnabled(true);
            this.cancelButton.setEnabled(false);
            this.testStepList.setEnabled(true);
            return;
        }
        PropertiesMap properties = new PropertiesMap();
        properties.put("loopButton", this.loopButton);
        this.runner = ((WsdlTestCase)this.getModelItem()).run(properties, true);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (canCancel) {
            if (this.runner != null && this.runner.getStatus() == TestRunner.Status.RUNNING) {
                Boolean retval = UISupport.confirmOrCancel("Cancel running TestCase?", "Cancel Run");
                if (retval == null) {
                    return false;
                }
                if (retval.booleanValue()) {
                    this.runner.cancel(null);
                }
            }
        } else if (this.runner != null && this.runner.getStatus() == TestRunner.Status.RUNNING) {
            this.runner.cancel(null);
        }
        SoapUI.getTestMonitor().removeTestMonitorListener(this.testMonitorListener);
        ((WsdlTestCase)this.getModelItem()).removeTestRunListener(this.testRunListener);
        this.testStepList.release();
        return true;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlTestCase)this.getModelItem()).getTestSuite() || modelItem == ((WsdlTestCase)this.getModelItem()).getTestSuite().getProject();
    }

    @Override
    public String getDescription() {
        return "TestCase: [" + ((WsdlTestCase)this.getModelItem()).getName() + "]";
    }

    public class CancelRunTestCaseAction
    extends AbstractAction {
        public CancelRunTestCaseAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/stop_testcase.gif"));
            this.putValue("ShortDescription", "Stops running this testcase");
        }

        public void actionPerformed(ActionEvent e) {
            if (WsdlTestCaseDesktopPanel.this.runner != null) {
                WsdlTestCaseDesktopPanel.this.runner.cancel("canceled in UI");
            }
            WsdlTestCaseDesktopPanel.this.canceled = true;
        }
    }

    public class RunTestCaseAction
    extends AbstractAction {
        public RunTestCaseAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_testcase.gif"));
            this.putValue("ShortDescription", "Runs this testcase");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlTestCaseDesktopPanel.this.canceled = false;
            WsdlTestCaseDesktopPanel.this.runTestCase();
        }
    }

    public class InternalTestRunListener
    extends TestRunListenerAdapter {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        public void beforeRun(TestRunner testRunner, TestRunContext runContext) {
            if (SoapUI.getTestMonitor().hasRunningLoadTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem())) {
                return;
            }
            WsdlTestCaseDesktopPanel.this.runButton.setEnabled(false);
            WsdlTestCaseDesktopPanel.this.cancelButton.setEnabled(true);
            WsdlTestCaseDesktopPanel.this.testStepList.setEnabled(false);
            WsdlTestCaseDesktopPanel.this.testStepList.setSelectedIndex(-1);
            WsdlTestCaseDesktopPanel.this.testCaseLog.clear();
            WsdlTestCaseDesktopPanel.this.testCaseLog.addText("Test started at " + this.dateFormat.format(new Date()));
        }

        public void beforeStep(TestRunner testRunner, TestRunContext runContext) {
            if (SoapUI.getTestMonitor().hasRunningLoadTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem())) {
                return;
            }
            TestStep testStep = runContext.getCurrentStep();
            WsdlTestCaseDesktopPanel.this.testStepList.setSelectedValue(testStep, true);
        }

        public void afterRun(TestRunner testRunner, TestRunContext runContext) {
            if (SoapUI.getTestMonitor().hasRunningLoadTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem())) {
                return;
            }
            WsdlTestCaseRunner wsdlRunner = (WsdlTestCaseRunner)testRunner;
            if (testRunner.getStatus() == TestRunner.Status.CANCELED) {
                WsdlTestCaseDesktopPanel.this.testCaseLog.addText("Test canceled [" + testRunner.getReason() + "], time taken = " + wsdlRunner.getTimeTaken());
            } else {
                WsdlTestCaseDesktopPanel.this.testCaseLog.addText("Test finished, time taken = " + wsdlRunner.getTimeTaken());
            }
            WsdlTestCaseDesktopPanel.this.runner = null;
            JToggleButton loopButton = (JToggleButton)runContext.getProperty("loopButton");
            if (loopButton != null && loopButton.isSelected() && testRunner.getStatus() == TestRunner.Status.FINISHED) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WsdlTestCaseDesktopPanel.this.runTestCase();
                    }
                });
            } else {
                WsdlTestCaseDesktopPanel.this.runButton.setEnabled(true);
                WsdlTestCaseDesktopPanel.this.cancelButton.setEnabled(false);
                WsdlTestCaseDesktopPanel.this.testStepList.setEnabled(true);
            }
        }

        public void afterStep(TestRunner testRunner, TestRunContext runContext, TestStepResult stepResult) {
            if (SoapUI.getTestMonitor().hasRunningLoadTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem())) {
                return;
            }
            WsdlTestCaseDesktopPanel.this.testCaseLog.addTestStepResult(stepResult);
        }
    }

    private final class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        public void loadTestStarted(LoadTestRunner runner) {
            WsdlTestCaseDesktopPanel.this.setRunningState();
        }

        public void loadTestFinished(LoadTestRunner runner) {
            WsdlTestCaseDesktopPanel.this.setRunningState();
        }
    }
}

