/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.ActionSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class TestStepList
extends JPanel {
    private TestStepListModel testStepListModel;
    private JList testStepList;
    private JPopupMenu testListPopup;
    private JMenu appendStepMenu;
    private MoveStepDownAction moveStepDownAction;
    private MoveStepUpAction moveStepUpAction;
    private final WsdlTestCase testCase;

    public TestStepList(WsdlTestCase testCase) {
        super(new BorderLayout());
        this.testCase = testCase;
        this.buildUI();
    }

    private void buildUI() {
        this.testStepListModel = new TestStepListModel();
        this.testStepList = new JList(this.testStepListModel);
        this.testStepList.setCellRenderer(new TestStepCellRenderer());
        this.testStepList.setFixedCellHeight(22);
        this.testStepList.setSelectionMode(0);
        this.testStepList.addKeyListener(new TestStepListKeyHandler());
        this.testStepList.addMouseListener(new StepListMouseListener());
        this.testStepList.addMouseListener(new MouseAdapter(){
            private int newIndex;
            private int prevIndex;

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                this.newIndex = TestStepList.this.testStepList.locationToIndex(e.getPoint());
                if (this.prevIndex == this.newIndex & this.prevIndex != -1) {
                    TestStepList.this.testStepList.clearSelection();
                    this.newIndex = -1;
                }
                this.prevIndex = this.newIndex;
            }
        });
        this.testListPopup = new JPopupMenu();
        this.testListPopup.addSeparator();
        this.appendStepMenu = new JMenu("Append Step");
        WsdlTestStepRegistry registry = WsdlTestStepRegistry.getInstance();
        WsdlTestStepFactory[] factories = registry.getFactories();
        for (int c = 0; c < factories.length; ++c) {
            if (!factories[c].canCreate()) continue;
            this.appendStepMenu.add(new InsertTestStepAction(factories[c]));
        }
        this.testListPopup.add(this.appendStepMenu);
        this.testListPopup.addSeparator();
        this.moveStepDownAction = new MoveStepDownAction();
        this.testListPopup.add(this.moveStepDownAction);
        this.moveStepUpAction = new MoveStepUpAction();
        this.testListPopup.add(this.moveStepUpAction);
        this.testListPopup.addPopupMenuListener(new StepListPopupMenuListener(this.testCase));
        this.testStepList.setComponentPopupMenu(this.testListPopup);
        this.add((Component)this.testStepList, "Center");
    }

    public void setEnabled(boolean enabled) {
        this.testStepList.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setSelectedIndex(int i) {
        this.testStepList.setSelectedIndex(i);
    }

    public void setSelectedValue(TestStep testStep, boolean b) {
        this.testStepList.setSelectedValue(testStep, true);
    }

    public void release() {
        this.testStepListModel.release();
    }

    public class InsertTestStepAction
    extends AbstractAction {
        private final WsdlTestStepFactory factory;

        public InsertTestStepAction(WsdlTestStepFactory factory) {
            super(factory.getTestStepName());
            this.putValue("ShortDescription", factory.getTestStepDescription());
            this.putValue("SmallIcon", factory.getTestStepIcon());
            this.factory = factory;
        }

        public void actionPerformed(ActionEvent e) {
            TestStepConfig newTestStepConfig;
            String name = UISupport.prompt("Specify name for new step", "Insert Step", this.factory.getTestStepName());
            if (name != null && (newTestStepConfig = this.factory.createNewTestStep(TestStepList.this.testCase, name)) != null) {
                WsdlTestStep testStep = TestStepList.this.testCase.addTestStep(newTestStepConfig);
                UISupport.selectAndShow(testStep);
            }
        }
    }

    private class MoveStepUpAction
    extends AbstractAction {
        public MoveStepUpAction() {
            super("Move up");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu UP"));
        }

        public void actionPerformed(ActionEvent e) {
            int ix = TestStepList.this.testStepList.getSelectedIndex();
            if (ix < 1) {
                return;
            }
            TestStepList.this.testCase.moveTestStep(ix, -1);
            TestStepList.this.testStepList.setSelectedIndex(ix - 1);
        }
    }

    private class MoveStepDownAction
    extends AbstractAction {
        public MoveStepDownAction() {
            super("Move down");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu DOWN"));
        }

        public void actionPerformed(ActionEvent e) {
            int ix = TestStepList.this.testStepList.getSelectedIndex();
            if (ix == -1 || ix >= TestStepList.this.testCase.getTestStepCount() - 1) {
                return;
            }
            TestStepList.this.testCase.moveTestStep(ix, 1);
            TestStepList.this.testStepList.setSelectedIndex(ix + 1);
        }
    }

    private class TestStepListModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private TestStepListTestSuiteListener testStepListTestSuiteListener = new TestStepListTestSuiteListener();

        public TestStepListModel() {
            for (int c = 0; c < this.getSize(); ++c) {
                TestStepList.this.testCase.getTestStepAt(c).addPropertyChangeListener(this);
            }
            TestStepList.this.testCase.getTestSuite().addTestSuiteListener(this.testStepListTestSuiteListener);
        }

        public int getSize() {
            return TestStepList.this.testCase.getTestStepCount();
        }

        public Object getElementAt(int index) {
            return TestStepList.this.testCase.getTestStepAt(index);
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            int ix = TestStepList.this.testCase.getIndexOfTestStep((TestStep)arg0.getSource());
            if (ix == -1) {
                return;
            }
            this.fireContentsChanged(this, ix, ix);
        }

        public void release() {
            TestStepList.this.testCase.getTestSuite().removeTestSuiteListener(this.testStepListTestSuiteListener);
            for (int c = 0; c < this.getSize(); ++c) {
                TestStepList.this.testCase.getTestStepAt(c).removePropertyChangeListener(this);
            }
        }

        private class TestStepListTestSuiteListener
        extends TestSuiteListenerAdapter {
            private TestStepListTestSuiteListener() {
            }

            public void testStepAdded(TestStep testStep, int ix) {
                if (testStep.getTestCase() == TestStepList.this.testCase) {
                    testStep.addPropertyChangeListener(TestStepListModel.this);
                    TestStepListModel.this.fireIntervalAdded(TestStepListModel.this, ix, ix);
                }
            }

            public void testStepRemoved(TestStep testStep, int ix) {
                if (testStep.getTestCase() == TestStepList.this.testCase) {
                    testStep.removePropertyChangeListener(TestStepListModel.this);
                    TestStepListModel.this.fireIntervalRemoved(TestStepListModel.this, ix, ix);
                }
            }
        }
    }

    private static final class TestStepCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public TestStepCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            WsdlTestStep testStep = (WsdlTestStep)value;
            this.setText(testStep.getName());
            this.setIcon(testStep.getIcon());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            return this;
        }
    }

    private final class StepListMouseListener
    extends MouseAdapter {
        private StepListMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            ModelItem modelItem = (ModelItem)TestStepList.this.testStepList.getSelectedValue();
            if (modelItem == null) {
                return;
            }
            Action defaultAction = modelItem.getActions().getDefaultAction();
            if (defaultAction != null) {
                defaultAction.actionPerformed(new ActionEvent(TestStepList.this, 0, null));
            }
        }
    }

    private final class StepListPopupMenuListener
    implements PopupMenuListener {
        private StepListPopupMenuListener(WsdlTestCase case1) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            while (TestStepList.this.testListPopup.getComponentCount() > 4) {
                TestStepList.this.testListPopup.remove(0);
            }
            int ix = TestStepList.this.testStepList.getSelectedIndex();
            if (SoapUI.getTestMonitor().hasRunningLoadTest(TestStepList.this.testCase)) {
                TestStepList.this.appendStepMenu.setEnabled(false);
                TestStepList.this.moveStepDownAction.setEnabled(false);
                TestStepList.this.moveStepUpAction.setEnabled(false);
                return;
            }
            TestStepList.this.appendStepMenu.setEnabled(true);
            TestStepList.this.moveStepUpAction.setEnabled(ix > 0);
            TestStepList.this.moveStepDownAction.setEnabled(ix > -1 && ix < TestStepList.this.testCase.getTestStepCount() - 1);
            if (ix >= 0) {
                WsdlTestStep testStep = TestStepList.this.testCase.getTestStepAt(ix);
                TestStepList.this.testListPopup.add((Component)new JPopupMenu.Separator(), 0);
                ActionSupport.insertActions(testStep.getActions(), TestStepList.this.testListPopup, 0);
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private final class TestStepListKeyHandler
    extends KeyAdapter {
        private TestStepListKeyHandler() {
        }

        public void keyPressed(KeyEvent e) {
            int ctrlKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            if ((e.getModifiers() & ctrlKey) == ctrlKey && e.getKeyCode() == 40) {
                TestStepList.this.moveStepDownAction.actionPerformed(new ActionEvent(TestStepList.this.testStepList, 0, "DOWN"));
                e.consume();
            } else if ((e.getModifiers() & ctrlKey) == ctrlKey && e.getKeyCode() == 38) {
                TestStepList.this.moveStepUpAction.actionPerformed(new ActionEvent(TestStepList.this.testStepList, 0, "UP"));
                e.consume();
            } else if (e.getKeyChar() == '\n') {
                int ix = TestStepList.this.testStepList.getSelectedIndex();
                if (ix != -1) {
                    WsdlTestStep testStep = TestStepList.this.testCase.getTestStepAt(ix);
                    UISupport.selectAndShow(testStep);
                    e.consume();
                }
            } else {
                WsdlTestStep testStep;
                ActionList actions;
                int ix = TestStepList.this.testStepList.getSelectedIndex();
                if (ix != -1 && (actions = (testStep = TestStepList.this.testCase.getTestStepAt(ix)).getActions()) != null) {
                    actions.dispatchKeyEvent(e);
                }
            }
        }
    }
}

